/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import sidekick.IAsset;
import sidekick.SideKickCompletion;
import sidekick.SideKickCompletionPopup;
import sidekick.SideKickParsedData;
import sidekick.SideKickParser;
import sidekick.SideKickPlugin;

public class SideKickActions {
    private static boolean completeDelay;
    private static boolean completeInstant;
    private static boolean autoCompletePopupGetFocus;
    private static int delay;
    private static WeakReference<JEditTextArea> delayedCompletionTarget;
    private static int caretWhenCompleteKeyPressed;
    private static Timer timer;
    private static SideKickCompletionPopup popup;
    public static final int COMPLETE_COMMAND = 0;
    public static final int COMPLETE_DELAY_KEY = 1;
    public static final int COMPLETE_INSTANT_KEY = 2;
    public static String acceptChars;
    public static String insertChars;

    public static void keyComplete(View view) {
        if (timer != null) {
            timer.stop();
        }
        if (!completeInstant) {
            return;
        }
        SideKickActions.complete(view, 2);
    }

    public static void keyCompleteWithDelay(View view) {
        if (!completeDelay) {
            return;
        }
        if (timer != null) {
            timer.stop();
        }
        JEditTextArea textArea = view.getTextArea();
        if (delayedCompletionTarget == null || delayedCompletionTarget.get() != textArea) {
            delayedCompletionTarget = new WeakReference<JEditTextArea>(textArea);
        }
        caretWhenCompleteKeyPressed = textArea.getCaretPosition();
        if (timer == null) {
            timer = new Timer(0, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JEditTextArea textArea = (JEditTextArea)delayedCompletionTarget.get();
                    if (textArea != null && caretWhenCompleteKeyPressed == textArea.getCaretPosition()) {
                        SideKickActions.complete(textArea.getView(), 1);
                    }
                }
            });
            timer.setInitialDelay(delay);
            timer.setRepeats(false);
        }
        timer.start();
    }

    public static void complete(View view, int mode) {
        EditPane editPane = view.getEditPane();
        Buffer buffer = editPane.getBuffer();
        JEditTextArea textArea = editPane.getTextArea();
        SideKickParser parser = SideKickPlugin.getParserForBuffer(buffer);
        SideKickParsedData data = SideKickParsedData.getParsedData(view);
        SideKickCompletion complete = null;
        if (buffer.isEditable() && data != null && parser != null && parser.supportsCompletion()) {
            complete = parser.complete(editPane, textArea.getCaretPosition());
        }
        if (complete == null || complete.size() == 0) {
            if (mode == 2 || mode == 1) {
                return;
            }
            view.getToolkit().beep();
            return;
        }
        if (complete.size() == 1 && (mode == 0 || mode == 2)) {
            complete.insert(0);
            return;
        }
        if (popup != null) {
            return;
        }
        boolean active = mode == 0 || autoCompletePopupGetFocus;
        popup = parser.getCompletionPopup(view, textArea.getCaretPosition(), complete, active);
        popup.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                popup = null;
            }
        });
    }

    public static void selectAsset(View view) {
        SideKickParsedData data = SideKickParsedData.getParsedData(view);
        if (data == null) {
            view.getToolkit().beep();
            return;
        }
        JEditTextArea textArea = view.getTextArea();
        IAsset asset = data.getAssetAtOffset(textArea.getCaretPosition());
        if (asset == null || asset.getEnd() == null) {
            view.getToolkit().beep();
            return;
        }
        int pos = asset.getEnd().getOffset();
        if (pos > textArea.getBuffer().getLength()) {
            view.getToolkit().beep();
            return;
        }
        textArea.setCaretPosition(pos);
        textArea.addToSelection((Selection)new Selection.Range(asset.getStart().getOffset(), pos));
    }

    public static void narrowToAsset(View view) {
        SideKickParsedData data = SideKickParsedData.getParsedData(view);
        if (data == null) {
            view.getToolkit().beep();
            return;
        }
        JEditTextArea textArea = view.getTextArea();
        TreePath path = data.getTreePathForPosition(textArea.getCaretPosition());
        if (path == null) {
            view.getToolkit().beep();
            return;
        }
        IAsset asset = (IAsset)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        if (asset == null || asset.getEnd() == null) {
            view.getToolkit().beep();
            return;
        }
        textArea.getDisplayManager().narrow(textArea.getLineOfOffset(asset.getStart().getOffset()), textArea.getLineOfOffset(asset.getStart().getOffset()));
    }

    public static void goToPrevAsset(View view) {
        SideKickParsedData data = SideKickParsedData.getParsedData(view);
        if (data == null) {
            view.getToolkit().beep();
            return;
        }
        JEditTextArea textArea = view.getTextArea();
        int caret = textArea.getCaretPosition();
        TreePath path = data.getTreePathForPosition(caret);
        if (path == null) {
            view.getToolkit().beep();
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        for (int i = 0; i < node.getChildCount(); ++i) {
            IAsset asset;
            Object userObject = ((DefaultMutableTreeNode)node.getChildAt(i)).getUserObject();
            if (!(userObject instanceof IAsset) || (asset = (IAsset)userObject).getEnd() == null || caret != asset.getEnd().getOffset()) continue;
            textArea.setCaretPosition(asset.getStart().getOffset());
            return;
        }
        IAsset asset = (IAsset)node.getUserObject();
        if (caret == asset.getStart().getOffset()) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            if (parent != null) {
                for (int i = 0; i < parent.getChildCount(); ++i) {
                    if (node != parent.getChildAt(i)) continue;
                    if (i == 0) {
                        if (parent.getUserObject() instanceof IAsset) {
                            textArea.setCaretPosition(((IAsset)parent.getUserObject()).getStart().getOffset());
                        }
                    } else {
                        IAsset prevAsset;
                        Object child = ((DefaultMutableTreeNode)parent.getChildAt(i - 1)).getUserObject();
                        if (child instanceof IAsset && (prevAsset = (IAsset)child).getEnd() != null) {
                            textArea.setCaretPosition(prevAsset.getEnd().getOffset());
                        }
                    }
                    return;
                }
            }
        } else {
            textArea.setCaretPosition(asset.getStart().getOffset());
        }
    }

    public static void goToNextAsset(View view) {
        int offset;
        SideKickParsedData data = SideKickParsedData.getParsedData(view);
        if (data == null) {
            view.getToolkit().beep();
            return;
        }
        JEditTextArea textArea = view.getTextArea();
        int caret = textArea.getCaretPosition();
        TreePath path = data.getTreePathForPosition(caret);
        if (path == null) {
            view.getToolkit().beep();
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        for (int i = 0; i < node.getChildCount(); ++i) {
            IAsset asset;
            Object userObject = ((DefaultMutableTreeNode)node.getChildAt(i)).getUserObject();
            if (!(userObject instanceof IAsset) || caret != (asset = (IAsset)userObject).getEnd().getOffset()) continue;
            if (i == node.getChildCount() - 1) break;
            IAsset nextAsset = (IAsset)((DefaultMutableTreeNode)node.getChildAt(i + 1)).getUserObject();
            int offset2 = nextAsset.getStart().getOffset() >= textArea.getBufferLength() ? textArea.getBufferLength() - 1 : nextAsset.getStart().getOffset();
            textArea.setCaretPosition(offset2);
            return;
        }
        offset = (offset = ((IAsset)node.getUserObject()).getEnd().getOffset()) >= textArea.getBufferLength() ? textArea.getBufferLength() - 1 : offset;
        textArea.setCaretPosition(offset);
    }

    public static void propertiesChanged() {
        completeDelay = jEdit.getBooleanProperty((String)"sidekick.complete-delay.toggle");
        completeInstant = jEdit.getBooleanProperty((String)"sidekick.complete-instant.toggle");
        autoCompletePopupGetFocus = jEdit.getBooleanProperty((String)"sidekick.auto-complete-popup-get-focus");
        acceptChars = MiscUtilities.escapesToChars((String)jEdit.getProperty((String)"sidekick.complete-popup.accept-characters"));
        insertChars = MiscUtilities.escapesToChars((String)jEdit.getProperty((String)"sidekick.complete-popup.insert-characters"));
        delay = jEdit.getIntegerProperty((String)"sidekick.complete-delay", (int)500);
        if (timer != null) {
            timer.setInitialDelay(delay);
        }
    }

    public static class ToggleParser
    extends SideKickAction {
        public String getLabel() {
            return this.parserName + " (Toggle)";
        }

        public ToggleParser(String parserName) {
            super("sidekick.parser." + parserName + "-toggle", parserName);
            this.parserName = parserName;
        }

        public String getCode() {
            return "new sidekick.SideKickActions.ToggleAction(\"" + this.parserName + "\").invoke(view)";
        }

        public void invoke(View view) {
        }
    }

    public static abstract class SideKickAction
    extends EditAction {
        protected String parserName;

        protected SideKickAction(String actionName, String parserName) {
            super(actionName, new Object[]{parserName});
            this.parserName = parserName;
        }
    }
}

