/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.awt.Color;
import java.awt.Font;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.IPropertyManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class SyntaxUtilities {
    public static IPropertyManager propertyManager;
    private static final Pattern COLOR_MATRIX_PATTERN;
    private static final Pattern COMMA_BETWEEN_BRACKETS_SEPARATOR_PATTERN;
    private static final Pattern COMMA_SEPARATOR_PATTERN;
    private static volatile StyleExtender _styleExtender;

    public static String getThemeProperty(String name) {
        String s = GUIUtilities.getThemeSuffix();
        String a = propertyManager.getProperty(name);
        String b = propertyManager.getProperty(name + s);
        return b == null ? a : b;
    }

    public static String getColorHexString(Color c) {
        String mask = "#ff000000";
        String colString = Integer.toHexString(c.getRGB());
        return mask.substring(0, mask.length() - colString.length()).concat(colString);
    }

    public static Color parseColor(String name) {
        return SyntaxUtilities.parseColor(name, GUIUtilities.defaultFgColor());
    }

    public static Color parseColor(String name, Color defaultColor) {
        if (name == null || ((String)name).isEmpty()) {
            return defaultColor;
        }
        if (((String)(name = ((String)name).trim())).charAt(0) == '#') {
            try {
                name = ((String)name).substring(1);
                if (((String)name).length() == 6) {
                    name = "ff" + (String)name;
                }
                BigInteger bi = new BigInteger((String)name, 16);
                return new Color(bi.intValue(), true);
            }
            catch (NumberFormatException nf) {
                return defaultColor;
            }
        }
        if ("red".equals(name)) {
            return Color.red;
        }
        if ("green".equals(name)) {
            return Color.green;
        }
        if ("blue".equals(name)) {
            return Color.blue;
        }
        if ("yellow".equals(name)) {
            return Color.yellow;
        }
        if ("orange".equals(name)) {
            return Color.orange;
        }
        if ("white".equals(name)) {
            return Color.white;
        }
        if ("lightGray".equals(name)) {
            return Color.lightGray;
        }
        if ("gray".equals(name)) {
            return Color.gray;
        }
        if ("darkGray".equals(name)) {
            return Color.darkGray;
        }
        if ("black".equals(name)) {
            return Color.black;
        }
        if ("cyan".equals(name)) {
            return Color.cyan;
        }
        if ("magenta".equals(name)) {
            return Color.magenta;
        }
        if ("pink".equals(name)) {
            return Color.pink;
        }
        return defaultColor;
    }

    public static String getColorMatrixString(Color[][] matrix) {
        if (matrix == null) {
            return null;
        }
        return Arrays.stream(matrix).map(row -> Arrays.stream(row).map(SyntaxUtilities::getColorHexString).collect(Collectors.joining(",", "[", "]"))).collect(Collectors.joining(",", "[", "]"));
    }

    public static Color[][] parseColorMatrix(String matrix, Color[][] defaultColorMatrix) {
        if (matrix == null || !COLOR_MATRIX_PATTERN.matcher(matrix).matches()) {
            return defaultColorMatrix;
        }
        Color[][] result = (Color[][])COMMA_BETWEEN_BRACKETS_SEPARATOR_PATTERN.splitAsStream((matrix = matrix.strip()).substring(1, matrix.length() - 1)).map(row -> {
            row = row.strip();
            return (Color[])COMMA_SEPARATOR_PATTERN.splitAsStream(row.substring(1, row.length() - 1)).map(String::strip).map(color -> SyntaxUtilities.parseColor(color, null)).toArray(Color[]::new);
        }).toArray(x$0 -> new Color[x$0][]);
        if (Arrays.stream(result).flatMap(Arrays::stream).anyMatch(Objects::isNull) || Arrays.stream(result).mapToInt(row -> ((Color[])row).length).distinct().count() != 1L) {
            return defaultColorMatrix;
        }
        return result;
    }

    public static SyntaxStyle parseStyle(String str, String family, int size, boolean color, Color defaultFgColor) throws IllegalArgumentException {
        Color fgColor = defaultFgColor;
        Color bgColor = null;
        boolean italic = false;
        boolean bold = false;
        StringTokenizer st = new StringTokenizer(str);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("color:")) {
                if (!color) continue;
                fgColor = SyntaxUtilities.parseColor(s.substring(6), GUIUtilities.defaultFgColor());
                continue;
            }
            if (s.startsWith("bgColor:")) {
                if (!color) continue;
                bgColor = SyntaxUtilities.parseColor(s.substring(8), null);
                continue;
            }
            if (s.startsWith("style:")) {
                for (int i = 6; i < s.length(); ++i) {
                    if (s.charAt(i) == 'i') {
                        italic = true;
                        continue;
                    }
                    if (s.charAt(i) == 'b') {
                        bold = true;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid style: " + s);
                }
                continue;
            }
            throw new IllegalArgumentException("Invalid directive: " + s);
        }
        return new SyntaxStyle(fgColor, bgColor, new Font(family, (italic ? 2 : 0) | (bold ? 1 : 0), size));
    }

    public static SyntaxStyle parseStyle(String str, String family, int size, boolean color) throws IllegalArgumentException {
        return SyntaxUtilities.parseStyle(str, family, size, color, GUIUtilities.defaultFgColor());
    }

    public static SyntaxStyle[] loadStyles(String family, int size) {
        return SyntaxUtilities.loadStyles(family, size, true);
    }

    public static SyntaxStyle[] loadStyles(String family, int size, boolean color) {
        SyntaxStyle[] styles = new SyntaxStyle[19];
        for (int i = 1; i < styles.length; ++i) {
            try {
                String styleName = "view.style." + Token.tokenToString((byte)i).toLowerCase(Locale.ENGLISH);
                styles[i] = SyntaxUtilities.parseStyle(SyntaxUtilities.getThemeProperty(styleName), family, size, color);
                continue;
            }
            catch (Exception e) {
                Log.log(9, StandardUtilities.class, e);
            }
        }
        styles[0] = new SyntaxStyle(jEdit.getColorProperty("view.fgColor", GUIUtilities.defaultFgColor()), null, new Font(family, 0, size));
        return _styleExtender.extendStyles(styles);
    }

    public static void setStyleExtender(StyleExtender ext) {
        _styleExtender = ext;
    }

    private SyntaxUtilities() {
    }

    static {
        COLOR_MATRIX_PATTERN = Pattern.compile("(?x)\n^\n\\s*+ # optionally preceded by whitespace\n\\[\n    (?: # one or more comma-separated matrix rows\n        \\s*+ # optionally preceded by whitespace\n        (?> # one matrix row\n            \\s*+ # optionally preceded by whitespace\n            \\[\n                (?: # one or more comma-separated colors\n                    \\s*+ # optionally preceded by whitespace\n                    (?>                                       # one color\n                        \\#\\p{XDigit}{6}(?:\\p{XDigit}{2})?+ # with '#' and 6 to 8 hex digits\n                        | red                                 # or as simple word\n                        | green\n                        | blue\n                        | yellow\n                        | orange\n                        | white\n                        | lightGray\n                        | gray\n                        | darkGray\n                        | black\n                        | cyan\n                        | magenta\n                        | pink\n                    )\n                    \\s*+ # optionally followed by whitespace\n                    (?:           # optionally followed\n                        ,         # by a comma\n                        (?!\\s*]) # that is not followed by a closing bracket\n                    )?+ \n                )++\n                \\s*+\n            ]\n        )\n        \\s*+ # optionally followed by whitespace\n        (?:           # optionally followed\n            ,         # by a comma\n            (?!\\s*]) # that is not followed by a closing bracket\n        )?+\n    )++\n    \\s*+ # optionally followed by whitespace\n]\n\\s*+ # optionally followed by whitespace\n$");
        COMMA_BETWEEN_BRACKETS_SEPARATOR_PATTERN = Pattern.compile("(?<=])\\s*+,\\s*+(?=\\[)");
        COMMA_SEPARATOR_PATTERN = Pattern.compile("\\s*+,\\s*+");
        _styleExtender = new StyleExtender();
    }

    public static class StyleExtender {
        public SyntaxStyle[] extendStyles(SyntaxStyle[] styles) {
            return styles;
        }
    }
}

