/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;

class SelectionManager {
    List<Selection> selection;
    private final TextArea textArea;

    SelectionManager(TextArea textArea) {
        this.textArea = textArea;
        this.selection = new ArrayList<Selection>();
    }

    int getSelectionCount() {
        return this.selection.size();
    }

    @Nonnull
    public Selection[] getSelection() {
        return this.selection.toArray(new Selection[0]);
    }

    void setSelection(Selection[] selection) {
        this.selection.clear();
        this.addToSelection(selection);
    }

    void addToSelection(Selection[] selection) {
        if (selection != null) {
            for (Selection s : selection) {
                if (s == null) continue;
                this.addToSelection(s);
            }
        }
    }

    void addToSelection(Selection addMe) {
        if (addMe.start > addMe.end) {
            throw new IllegalArgumentException(addMe.start + " > " + addMe.end);
        }
        if (addMe.start == addMe.end) {
            if (addMe instanceof Selection.Range) {
                return;
            }
            if (addMe instanceof Selection.Rect && ((Selection.Rect)addMe).extraEndVirt == 0) {
                return;
            }
        }
        Iterator<Selection> iter = this.selection.iterator();
        while (iter.hasNext()) {
            Selection s = iter.next();
            if (!s.overlaps(addMe)) continue;
            addMe.start = Math.min(s.start, addMe.start);
            addMe.end = Math.max(s.end, addMe.end);
            iter.remove();
        }
        addMe.startLine = this.textArea.getLineOfOffset(addMe.start);
        addMe.endLine = this.textArea.getLineOfOffset(addMe.end);
        boolean added = false;
        for (int i = 0; i < this.selection.size(); ++i) {
            Selection s = this.selection.get(i);
            if (addMe.start >= s.start) continue;
            this.selection.add(i, addMe);
            added = true;
            break;
        }
        if (!added) {
            this.selection.add(addMe);
        }
        this.textArea.invalidateLineRange(addMe.startLine, addMe.endLine);
    }

    void clearSelection() {
        this.selection.clear();
    }

    void setSelection(Selection selection) {
        this.selection.clear();
        if (selection != null) {
            this.addToSelection(selection);
        }
    }

    Selection getSelectionAtOffset(int offset) {
        if (this.selection != null) {
            for (Selection s : this.selection) {
                if (offset < s.start || offset > s.end) continue;
                return s;
            }
        }
        return null;
    }

    void removeFromSelection(Selection sel) {
        this.selection.remove(sel);
    }

    void resizeSelection(int offset, int end, int extraEndVirt, boolean rect) {
        Selection newSel;
        boolean reversed = false;
        if (end < offset) {
            int tmp = offset;
            offset = end;
            end = tmp;
            reversed = true;
        }
        if (rect) {
            Selection.Rect rectSel = new Selection.Rect(offset, end);
            if (reversed) {
                rectSel.extraStartVirt = extraEndVirt;
            } else {
                rectSel.extraEndVirt = extraEndVirt;
            }
            newSel = rectSel;
        } else {
            newSel = new Selection.Range(offset, end);
        }
        this.addToSelection(newSel);
    }

    int[] getSelectedLines() {
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (Selection s : this.selection) {
            int endLine = s.end == this.textArea.getLineStartOffset(s.endLine) ? s.endLine - 1 : s.endLine;
            for (int j = s.startLine; j <= endLine; ++j) {
                set.add(j);
            }
        }
        int[] returnValue = new int[set.size()];
        int i = 0;
        for (Integer line : set) {
            returnValue[i++] = line;
        }
        return returnValue;
    }

    void invertSelection() {
        Selection[] newSelection = new Selection[this.selection.size() + 1];
        int lastOffset = 0;
        for (int i = 0; i < this.selection.size(); ++i) {
            Selection s = this.selection.get(i);
            newSelection[i] = new Selection.Range(lastOffset, s.getStart());
            lastOffset = s.getEnd();
        }
        newSelection[this.selection.size()] = new Selection.Range(lastOffset, this.textArea.getBufferLength());
        this.setSelection(newSelection);
    }

    int[] getSelectionStartAndEnd(int screenLine, int physicalLine, Selection s) {
        int x2;
        int x1;
        int start = this.textArea.getScreenLineStartOffset(screenLine);
        int end = this.textArea.getScreenLineEndOffset(screenLine);
        if (end <= s.start || start > s.end) {
            return null;
        }
        int selStartScreenLine = this.textArea.displayManager.isLineVisible(s.startLine) ? this.textArea.getScreenLineOfOffset(s.start) : -1;
        int selEndScreenLine = this.textArea.displayManager.isLineVisible(s.endLine) ? this.textArea.getScreenLineOfOffset(s.end) : -1;
        JEditBuffer buffer = this.textArea.getBuffer();
        int lineStart = buffer.getLineStartOffset(physicalLine);
        if (s instanceof Selection.Rect) {
            start -= lineStart;
            end -= lineStart;
            Selection.Rect rect = (Selection.Rect)s;
            int _start = rect.getStartColumn(buffer);
            int _end = rect.getEndColumn(buffer);
            int lineLen = buffer.getLineLength(physicalLine);
            int[] total = new int[1];
            int rectStart = buffer.getOffsetOfVirtualColumn(physicalLine, _start, total);
            if (rectStart == -1) {
                x1 = (_start - total[0]) * this.textArea.charWidth;
                rectStart = lineLen;
            } else {
                x1 = 0;
            }
            int rectEnd = buffer.getOffsetOfVirtualColumn(physicalLine, _end, total);
            if (rectEnd == -1) {
                x2 = (_end - total[0]) * this.textArea.charWidth;
                rectEnd = lineLen;
            } else {
                x2 = 0;
            }
            if (end <= rectStart || start > rectEnd) {
                return null;
            }
            x1 = rectStart < start ? 0 : x1 + this.textArea.offsetToXY((int)physicalLine, (int)rectStart).x;
            x2 = rectEnd > end ? this.textArea.getWidth() : x2 + this.textArea.offsetToXY((int)physicalLine, (int)rectEnd).x;
        } else if (selStartScreenLine == selEndScreenLine && selStartScreenLine != -1) {
            x1 = this.textArea.offsetToXY((int)physicalLine, (int)(s.start - lineStart)).x;
            x2 = this.textArea.offsetToXY((int)physicalLine, (int)(s.end - lineStart)).x;
        } else if (screenLine == selStartScreenLine) {
            x1 = this.textArea.offsetToXY((int)physicalLine, (int)(s.start - lineStart)).x;
            x2 = this.textArea.getWidth();
        } else if (screenLine == selEndScreenLine) {
            x1 = 0;
            x2 = this.textArea.offsetToXY((int)physicalLine, (int)(s.end - lineStart)).x;
        } else {
            x1 = 0;
            x2 = this.textArea.getWidth();
        }
        if (x1 < 0) {
            x1 = 0;
        }
        if (x2 < 0) {
            x2 = 0;
        }
        if (x1 == x2) {
            // empty if block
        }
        return new int[]{x1, ++x2};
    }

    boolean insideSelection(int x, int y) {
        int offset = this.textArea.xyToOffset(x, y);
        Selection s = this.textArea.getSelectionAtOffset(offset);
        if (s == null) {
            return false;
        }
        int screenLine = this.textArea.getScreenLineOfOffset(offset);
        if (screenLine == -1) {
            return false;
        }
        int[] selectionStartAndEnd = this.getSelectionStartAndEnd(screenLine, this.textArea.getLineOfOffset(offset), s);
        if (selectionStartAndEnd == null) {
            return false;
        }
        return x >= selectionStartAndEnd[0] && x <= selectionStartAndEnd[1];
    }
}

