/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.textarea.Anchor;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;

class FirstLine
extends Anchor {
    private int skew;
    private int preContentRemovedNumLines;

    FirstLine(DisplayManager displayManager, TextArea textArea) {
        super(displayManager, textArea);
    }

    @Override
    void preContentInserted(int startLine, int numLines) {
        int scrollLines = 0;
        int currentPhysicalLine = this.getPhysicalLine();
        int numLinesVisible = 0;
        int i = 0;
        for (int physicalLine = startLine; physicalLine < currentPhysicalLine; ++physicalLine) {
            if (this.getDisplayManager().isLineVisible(physicalLine)) {
                scrollLines += this.getDisplayManager().getScreenLineCount(physicalLine);
            }
            if (i < numLines) {
                ++numLinesVisible;
            }
            ++i;
        }
        this.preContentInsertedScrollLines = scrollLines;
    }

    @Override
    void contentInserted(int startLine, int numLines) {
        int currentPhysicalLine;
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "contentInserted() before:" + String.valueOf(this));
        }
        if (startLine == (currentPhysicalLine = this.getPhysicalLine())) {
            this.setCallChanged(true);
        } else if (startLine < currentPhysicalLine) {
            int scrollLines = 0;
            int physicalLine = startLine;
            int endLine = currentPhysicalLine + numLines;
            int numLinesVisible = 0;
            int i = 0;
            while (physicalLine < endLine) {
                if (this.getDisplayManager().isLineVisible(physicalLine)) {
                    scrollLines += this.getDisplayManager().getScreenLineCount(physicalLine);
                }
                if (i < numLines) {
                    ++numLinesVisible;
                }
                ++physicalLine;
                ++i;
            }
            this.movePhysicalLine(numLinesVisible);
            this.moveScrollLine(scrollLines - this.preContentInsertedScrollLines);
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "contentInserted() after:" + String.valueOf(this));
        }
        if (Debug.SCROLL_VERIFY) {
            this.scrollVerify();
        }
    }

    @Override
    void preContentRemoved(int startLine, int offset, int numLines) {
        int scrollLines = 0;
        int currentPhysicalLine = this.getPhysicalLine();
        int numLinesVisible = 0;
        int i = 0;
        for (int physicalLine = startLine; physicalLine < currentPhysicalLine; ++physicalLine) {
            if (this.getDisplayManager().isLineVisible(physicalLine)) {
                scrollLines += this.getDisplayManager().getScreenLineCount(physicalLine);
            }
            if (i < numLines) {
                ++numLinesVisible;
            }
            ++i;
        }
        this.preContentRemovedScrollLines = scrollLines;
        this.preContentRemovedNumLines = numLinesVisible;
    }

    @Override
    void contentRemoved(int startLine, int startOffset, int numLines) {
        int currentPhysicalLine;
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "contentRemoved() before:" + String.valueOf(this));
        }
        if (startLine == (currentPhysicalLine = this.getPhysicalLine())) {
            this.setCallChanged(true);
        } else if (startLine < currentPhysicalLine) {
            int scrollLines = 0;
            int endLine = currentPhysicalLine - numLines;
            for (int physicalLine = startLine; physicalLine < endLine; ++physicalLine) {
                if (!this.getDisplayManager().isLineVisible(physicalLine)) continue;
                scrollLines += this.getDisplayManager().getScreenLineCount(physicalLine);
            }
            this.movePhysicalLine(-this.preContentRemovedNumLines);
            this.moveScrollLine(scrollLines - this.preContentRemovedScrollLines);
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "contentRemoved() after:" + String.valueOf(this));
        }
        if (Debug.SCROLL_VERIFY) {
            this.scrollVerify();
        }
    }

    @Override
    public void changed() {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "changed() before: " + this.getPhysicalLine() + ":" + this.getScrollLine() + ":" + this.getSkew());
        }
        if (Debug.SCROLL_VERIFY) {
            this.scrollVerify();
        }
        this.ensurePhysicalLineIsVisible();
        int currentPhysicalLine = this.getPhysicalLine();
        int screenLines = this.getDisplayManager().getScreenLineCount(currentPhysicalLine);
        if (this.getSkew() >= screenLines) {
            this.setSkew(screenLines - 1);
        }
        if (Debug.SCROLL_VERIFY) {
            this.scrollVerify();
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "changed() after: " + this.getPhysicalLine() + ":" + this.getScrollLine() + ":" + this.getSkew());
        }
    }

    private void scrollVerify() {
        System.err.println("SCROLL_VERIFY");
        int verifyScrollLine = 0;
        int currentPhysicalLine = this.getPhysicalLine();
        int n = this.getDisplayManager().getBuffer().getLineCount();
        for (int i = 0; i < n && i < currentPhysicalLine; ++i) {
            if (!this.getDisplayManager().isLineVisible(i)) continue;
            verifyScrollLine += this.getDisplayManager().getScreenLineCount(i);
        }
        int scrollLine = this.getScrollLine();
        if (verifyScrollLine != scrollLine) {
            RuntimeException ex = new RuntimeException("ScrollLine is " + scrollLine + " but should be " + verifyScrollLine + " diff = " + (verifyScrollLine - scrollLine));
            Log.log(9, this, ex);
        }
    }

    @Override
    public void reset() {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "reset()");
        }
        int currentPhysicalLine = this.getPhysicalLine();
        int physicalLine = this.getDisplayManager().getFirstVisibleLine();
        int scrollLine = 0;
        while (physicalLine != -1 && physicalLine < currentPhysicalLine) {
            scrollLine += this.getDisplayManager().getScreenLineCount(physicalLine);
            int nextLine = this.getDisplayManager().getNextVisibleLine(physicalLine);
            if (nextLine == -1) break;
            physicalLine = nextLine;
        }
        this.setPhysicalLine(physicalLine);
        this.setScrollLine(scrollLine);
        int screenLines = this.getDisplayManager().getScreenLineCount(physicalLine);
        if (this.getSkew() >= screenLines) {
            this.setSkew(screenLines - 1);
        }
        this.getTextArea().updateScrollBar();
    }

    void physDown(int amount, int screenAmount) {
        int nextPhysicalLine;
        int currentPhysicalLine = this.getPhysicalLine();
        int currentScrollLine = this.getScrollLine();
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "physDown() start: " + currentPhysicalLine + ":" + currentScrollLine);
        }
        this.setSkew(0);
        if (!this.getDisplayManager().isLineVisible(currentPhysicalLine)) {
            int lastVisibleLine = this.getDisplayManager().getLastVisibleLine();
            if (currentPhysicalLine > lastVisibleLine) {
                this.setPhysicalLine(lastVisibleLine);
            } else {
                nextPhysicalLine = this.getDisplayManager().getNextVisibleLine(currentPhysicalLine);
                assert (nextPhysicalLine > 0);
                amount -= nextPhysicalLine - currentPhysicalLine;
                this.moveScrollLine(this.getDisplayManager().getScreenLineCount(currentPhysicalLine));
                this.setPhysicalLine(nextPhysicalLine);
            }
        }
        currentPhysicalLine = this.getPhysicalLine();
        int scrollLines = 0;
        while ((nextPhysicalLine = this.getDisplayManager().getNextVisibleLine(currentPhysicalLine)) != -1 && nextPhysicalLine <= currentPhysicalLine + amount) {
            scrollLines += this.getDisplayManager().getScreenLineCount(currentPhysicalLine);
            amount -= nextPhysicalLine - currentPhysicalLine;
            currentPhysicalLine = nextPhysicalLine;
        }
        this.setPhysicalLine(currentPhysicalLine);
        this.moveScrollLine(scrollLines);
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "physDown() end: " + this.getPhysicalLine() + ":" + this.getScrollLine());
        }
        if (screenAmount < 0) {
            this.scrollUp(-screenAmount);
        } else if (screenAmount > 0) {
            this.scrollDown(screenAmount);
        }
    }

    void physUp(int amount, int screenAmount) {
        int prevPhysicalLine;
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "physUp() start: " + this.getPhysicalLine() + ":" + this.getScrollLine());
        }
        this.setSkew(0);
        int currentPhysicalLine = this.getPhysicalLine();
        if (!this.getDisplayManager().isLineVisible(currentPhysicalLine)) {
            int firstVisibleLine = this.getDisplayManager().getFirstVisibleLine();
            if (currentPhysicalLine < firstVisibleLine) {
                this.setPhysicalLine(firstVisibleLine);
            } else {
                prevPhysicalLine = this.getDisplayManager().getPrevVisibleLine(currentPhysicalLine);
                amount -= currentPhysicalLine - prevPhysicalLine;
            }
        }
        currentPhysicalLine = this.getPhysicalLine();
        int scrollLines = 0;
        while ((prevPhysicalLine = this.getDisplayManager().getPrevVisibleLine(currentPhysicalLine)) != -1 && prevPhysicalLine >= currentPhysicalLine - amount) {
            scrollLines -= this.getDisplayManager().getScreenLineCount(prevPhysicalLine);
            amount -= currentPhysicalLine - prevPhysicalLine;
            currentPhysicalLine = prevPhysicalLine;
        }
        this.setPhysicalLine(currentPhysicalLine);
        this.moveScrollLine(scrollLines);
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "physUp() end: " + this.getPhysicalLine() + ":" + this.getScrollLine());
        }
        if (screenAmount < 0) {
            this.scrollUp(-screenAmount);
        } else if (screenAmount > 0) {
            this.scrollDown(screenAmount);
        }
    }

    void scrollDown(int amount) {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "scrollDown()");
        }
        this.ensurePhysicalLineIsVisible();
        amount += this.getSkew();
        this.setSkew(0);
        int physicalLine = this.getPhysicalLine();
        int screenLinesSum = 0;
        while (amount > 0) {
            int screenLines = this.getDisplayManager().getScreenLineCount(physicalLine);
            if (amount < screenLines) {
                this.setSkew(amount);
                break;
            }
            int nextLine = this.getDisplayManager().getNextVisibleLine(physicalLine);
            if (nextLine == -1) break;
            boolean visible = this.getDisplayManager().isLineVisible(physicalLine);
            physicalLine = nextLine;
            if (!visible) continue;
            amount -= screenLines;
            screenLinesSum += screenLines;
        }
        this.setPhysicalLine(physicalLine);
        this.moveScrollLine(screenLinesSum);
    }

    void scrollUp(int amount) {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "scrollUp() before:" + String.valueOf(this));
        }
        this.ensurePhysicalLineIsVisible();
        if (amount <= this.getSkew()) {
            this.setSkew(this.getSkew() - amount);
        } else {
            int prevLine;
            amount -= this.getSkew();
            this.setSkew(0);
            int physicalLine = this.getPhysicalLine();
            int screenLinesSum = 0;
            while (amount > 0 && (prevLine = this.getDisplayManager().getPrevVisibleLine(physicalLine)) != -1) {
                physicalLine = prevLine;
                int screenLines = this.getDisplayManager().getScreenLineCount(physicalLine);
                screenLinesSum -= screenLines;
                if (amount < screenLines) {
                    this.setSkew(screenLines - amount);
                    break;
                }
                amount -= screenLines;
            }
            this.setPhysicalLine(physicalLine);
            this.moveScrollLine(screenLinesSum);
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "scrollUp() after:" + String.valueOf(this));
        }
    }

    void ensurePhysicalLineIsVisible() {
        int physicalLine = this.getPhysicalLine();
        if (!this.getDisplayManager().isLineVisible(physicalLine)) {
            if (physicalLine > this.getDisplayManager().getLastVisibleLine()) {
                this.setPhysicalLine(this.getDisplayManager().getLastVisibleLine());
                this.setScrollLine(this.getDisplayManager().getScrollLineCount() - 1);
            } else if (physicalLine < this.getDisplayManager().getFirstVisibleLine()) {
                this.setPhysicalLine(this.getDisplayManager().getFirstVisibleLine());
                this.setScrollLine(0);
            } else {
                int nextLine = this.getDisplayManager().getNextVisibleLine(physicalLine);
                assert (nextLine > 0);
                int screenLineCount = 0;
                screenLineCount = this.getDisplayManager().getScreenLineCount(nextLine);
                this.setPhysicalLine(nextLine);
                this.moveScrollLine(screenLineCount);
            }
        }
    }

    @Override
    public String toString() {
        return "FirstLine[" + this.getPhysicalLine() + "," + this.getScrollLine() + "," + this.getSkew() + "]";
    }

    int getSkew() {
        return this.skew;
    }

    void setSkew(int skew) {
        if (this.skew != skew) {
            this.skew = skew;
            this.setCallChanged(true);
        }
    }
}

