/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.SystemTray;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.gui.ColorWellButton;
import org.gjt.sp.jedit.gui.FontSelector;
import org.gjt.sp.jedit.gui.NumericTextField;
import org.gjt.sp.jedit.gui.ScreenRectangleSelectionButton;
import org.gjt.sp.jedit.gui.tray.JTrayIconManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.IconTheme;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;

public class AppearanceOptionPane
extends AbstractOptionPane
implements ItemListener {
    public static final String[] builtInIconThemes = new String[]{"tango", "old"};
    private UIManager.LookAndFeelInfo[] lfs;
    private JComboBox<String> lookAndFeel;
    private FontSelector primaryFont;
    private FontSelector secondaryFont;
    private FontSelector helpViewerFont;
    private JTextField history;
    private JTextField menuSpillover;
    private JCheckBox showTips;
    private JCheckBox showSplash;
    private JCheckBox textColors;
    private JCheckBox decorateFrames;
    private JCheckBox decorateDialogs;
    private JComboBox<String> iconThemes;
    private JCheckBox systemTrayIcon;
    private JRadioButton systemTrayIconBackgroundDefault;
    private JRadioButton systemTrayIconBackgroundAutodetect;
    private JRadioButton systemTrayIconBackgroundFixedColor;
    private JRadioButton systemTrayIconBackgroundPickedRectangle;
    private ColorWellButton systemTrayIconBackgroundColor;
    private ScreenRectangleSelectionButton systemTrayIconBackgroundRectangle;
    private boolean lnfChanged = false;

    public AppearanceOptionPane() {
        super("appearance");
    }

    @Override
    protected void _init() {
        this.lfs = UIManager.getInstalledLookAndFeels();
        String[] names = new String[this.lfs.length];
        String lf = UIManager.getLookAndFeel().getClass().getName();
        int index = 0;
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.lfs[i].getName();
            if (!lf.equals(this.lfs[i].getClassName())) continue;
            index = i;
        }
        this.lookAndFeel = new JComboBox<String>(names);
        this.lookAndFeel.setSelectedIndex(index);
        this.lookAndFeel.addItemListener(this);
        this.addComponent(jEdit.getProperty("options.appearance.lf"), this.lookAndFeel);
        String[] themes = IconTheme.builtInNames();
        this.iconThemes = new JComboBox<String>(themes);
        String oldTheme = IconTheme.get();
        for (int i = 0; i < themes.length; ++i) {
            if (!themes[i].equals(oldTheme)) continue;
            this.iconThemes.setSelectedIndex(i);
            break;
        }
        Font pf = jEdit.getFontProperty("metal.primary.font");
        this.primaryFont = new FontSelector(pf);
        this.primaryFont.setEnabled(true);
        this.addComponent(jEdit.getProperty("options.appearance.primaryFont"), (Component)this.primaryFont);
        this.secondaryFont = new FontSelector(jEdit.getFontProperty("metal.secondary.font"));
        this.secondaryFont.setEnabled(true);
        this.addComponent(jEdit.getProperty("options.appearance.secondaryFont"), (Component)this.secondaryFont);
        this.helpViewerFont = new FontSelector(jEdit.getFontProperty("helpviewer.font", pf));
        this.addComponent(jEdit.getProperty("options.appearance.helpViewerFont"), (Component)this.helpViewerFont);
        this.history = new NumericTextField(jEdit.getProperty("history"), true);
        this.addComponent(jEdit.getProperty("options.appearance.history"), (Component)this.history);
        this.menuSpillover = new NumericTextField(jEdit.getProperty("menu.spillover"), true);
        this.addComponent(jEdit.getProperty("options.appearance.menuSpillover"), (Component)this.menuSpillover);
        this.addSeparator("options.appearance.systrayicon.label");
        this.systemTrayIcon = new JCheckBox(jEdit.getProperty("options.appearance.systrayicon"), jEdit.getBooleanProperty("systrayicon", true));
        if (!SystemTray.isSupported()) {
            this.systemTrayIcon.setSelected(false);
            this.systemTrayIcon.setEnabled(false);
            this.addComponent(new JLabel(jEdit.getProperty("options.appearance.systrayicon.not.supported")));
        }
        this.addComponent(this.systemTrayIcon);
        if (OperatingSystem.isX11()) {
            String systemTrayIconBackground = jEdit.getProperty("systrayicon.background", "autodetect").toLowerCase();
            this.systemTrayIconBackgroundDefault = new JRadioButton(jEdit.getProperty("options.appearance.systrayicon.background.default"), systemTrayIconBackground.equals("default"));
            this.systemTrayIconBackgroundDefault.setEnabled(this.systemTrayIcon.isSelected());
            this.systemTrayIconBackgroundAutodetect = new JRadioButton(jEdit.getProperty("options.appearance.systrayicon.background.autodetect"), systemTrayIconBackground.equals("autodetect"));
            this.systemTrayIconBackgroundAutodetect.setEnabled(this.systemTrayIcon.isSelected());
            this.systemTrayIconBackgroundFixedColor = new JRadioButton(jEdit.getProperty("options.appearance.systrayicon.background.fixed"), systemTrayIconBackground.equals("fixed"));
            this.systemTrayIconBackgroundFixedColor.setEnabled(this.systemTrayIcon.isSelected());
            this.systemTrayIconBackgroundPickedRectangle = new JRadioButton(jEdit.getProperty("options.appearance.systrayicon.background.picked"), systemTrayIconBackground.equals("picked"));
            this.systemTrayIconBackgroundPickedRectangle.setEnabled(this.systemTrayIcon.isSelected());
            ButtonGroup systemTrayIconBackgroundButtonGroup = new ButtonGroup();
            systemTrayIconBackgroundButtonGroup.add(this.systemTrayIconBackgroundDefault);
            systemTrayIconBackgroundButtonGroup.add(this.systemTrayIconBackgroundAutodetect);
            systemTrayIconBackgroundButtonGroup.add(this.systemTrayIconBackgroundFixedColor);
            systemTrayIconBackgroundButtonGroup.add(this.systemTrayIconBackgroundPickedRectangle);
            this.addComponent(this.systemTrayIconBackgroundDefault);
            this.addComponent(this.systemTrayIconBackgroundAutodetect);
            this.addComponent(this.systemTrayIconBackgroundFixedColor);
            this.systemTrayIconBackgroundColor = new ColorWellButton(jEdit.getColorProperty("systrayicon.bgColor"));
            this.systemTrayIconBackgroundColor.setEnabled(this.systemTrayIconBackgroundFixedColor.isEnabled() && this.systemTrayIconBackgroundFixedColor.isSelected());
            JLabel systemTrayIconBackgroundColorLabel = this.newLabel(jEdit.getProperty("options.appearance.systrayicon.background.color.label"), this.systemTrayIconBackgroundColor);
            systemTrayIconBackgroundColorLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 12));
            systemTrayIconBackgroundColorLabel.setEnabled(this.systemTrayIconBackgroundFixedColor.isEnabled() && this.systemTrayIconBackgroundFixedColor.isSelected());
            this.addComponent(systemTrayIconBackgroundColorLabel, (Component)this.systemTrayIconBackgroundColor, 3);
            this.systemTrayIconBackgroundFixedColor.addItemListener(itemEvent -> {
                boolean selected = itemEvent.getStateChange() == 1;
                systemTrayIconBackgroundColorLabel.setEnabled(selected);
                this.systemTrayIconBackgroundColor.setEnabled(selected);
            });
            this.addComponent(this.systemTrayIconBackgroundPickedRectangle);
            Color[][] systemTrayIconBackgroundRectangleColorMatrix = jEdit.getColorMatrixProperty("systrayicon.bgPixel");
            BufferedImage systemTrayIconBackgroundRectangleImage = null;
            if (systemTrayIconBackgroundRectangleColorMatrix != null) {
                int[] systemTrayIconBackgroundRectangleColors = Arrays.stream(systemTrayIconBackgroundRectangleColorMatrix).flatMap(Arrays::stream).mapToInt(Color::getRGB).toArray();
                int width = systemTrayIconBackgroundRectangleColorMatrix[0].length;
                int height = systemTrayIconBackgroundRectangleColorMatrix.length;
                systemTrayIconBackgroundRectangleImage = new BufferedImage(width, height, 1);
                systemTrayIconBackgroundRectangleImage.setRGB(0, 0, width, height, systemTrayIconBackgroundRectangleColors, 0, width);
            }
            this.systemTrayIconBackgroundRectangle = new ScreenRectangleSelectionButton(systemTrayIconBackgroundRectangleImage);
            JLabel systemTrayBackgroundRectangleLabel = this.newLabel(jEdit.getProperty("options.appearance.systrayicon.background.pixel.label"), this.systemTrayIconBackgroundRectangle);
            if (SystemTray.isSupported()) {
                this.systemTrayIconBackgroundRectangle.setRectangleDimension(SystemTray.getSystemTray().getTrayIconSize());
                this.systemTrayIconBackgroundRectangle.setEnabled(this.systemTrayIconBackgroundPickedRectangle.isEnabled() && this.systemTrayIconBackgroundPickedRectangle.isSelected());
                systemTrayBackgroundRectangleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 12));
                systemTrayBackgroundRectangleLabel.setEnabled(this.systemTrayIconBackgroundPickedRectangle.isEnabled() && this.systemTrayIconBackgroundPickedRectangle.isSelected());
                this.addComponent(systemTrayBackgroundRectangleLabel, (Component)this.systemTrayIconBackgroundRectangle, 3);
            }
            this.systemTrayIconBackgroundPickedRectangle.addItemListener(itemEvent -> {
                boolean selected = itemEvent.getStateChange() == 1;
                systemTrayBackgroundRectangleLabel.setEnabled(selected);
                this.systemTrayIconBackgroundRectangle.setEnabled(selected);
            });
            this.systemTrayIcon.addItemListener(itemEvent -> {
                boolean selected = itemEvent.getStateChange() == 1;
                this.systemTrayIconBackgroundDefault.setEnabled(selected);
                this.systemTrayIconBackgroundAutodetect.setEnabled(selected);
                this.systemTrayIconBackgroundFixedColor.setEnabled(selected);
                this.systemTrayIconBackgroundPickedRectangle.setEnabled(selected);
                if (selected) {
                    systemTrayIconBackgroundColorLabel.setEnabled(this.systemTrayIconBackgroundFixedColor.isSelected());
                    this.systemTrayIconBackgroundColor.setEnabled(this.systemTrayIconBackgroundFixedColor.isSelected());
                    systemTrayBackgroundRectangleLabel.setEnabled(this.systemTrayIconBackgroundPickedRectangle.isSelected());
                    this.systemTrayIconBackgroundRectangle.setEnabled(this.systemTrayIconBackgroundPickedRectangle.isSelected());
                } else {
                    systemTrayIconBackgroundColorLabel.setEnabled(false);
                    this.systemTrayIconBackgroundColor.setEnabled(false);
                    systemTrayBackgroundRectangleLabel.setEnabled(false);
                    this.systemTrayIconBackgroundRectangle.setEnabled(false);
                }
            });
        }
        this.addSeparator("options.appearance.startup.label");
        this.showSplash = new JCheckBox(jEdit.getProperty("options.appearance.showSplash"));
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory == null) {
            this.showSplash.setSelected(true);
        } else {
            this.showSplash.setSelected(!new File(settingsDirectory, "nosplash").exists());
        }
        this.addComponent(this.showSplash);
        this.showTips = new JCheckBox(jEdit.getProperty("options.appearance.showTips"));
        this.showTips.setSelected(jEdit.getBooleanProperty("tip.show"));
        this.addComponent(this.showTips);
        this.addSeparator("options.appearance.experimental.label");
        this.addComponent(GUIUtilities.createMultilineLabel(jEdit.getProperty("options.appearance.experimental.caption")));
        this.textColors = new JCheckBox(jEdit.getProperty("options.appearance.textColors"));
        this.textColors.setSelected(jEdit.getBooleanProperty("textColors"));
        this.addComponent(this.textColors);
        this.decorateFrames = new JCheckBox(jEdit.getProperty("options.appearance.decorateFrames"));
        this.decorateFrames.setSelected(jEdit.getBooleanProperty("decorate.frames"));
        this.addComponent(this.decorateFrames);
        this.decorateDialogs = new JCheckBox(jEdit.getProperty("options.appearance.decorateDialogs"));
        this.decorateDialogs.setSelected(jEdit.getBooleanProperty("decorate.dialogs"));
        this.addComponent(this.decorateDialogs);
        this.lnfChanged = false;
    }

    @Override
    protected void _save() {
        if (this.lnfChanged) {
            String lf = this.lfs[this.lookAndFeel.getSelectedIndex()].getClassName();
            jEdit.setProperty("lookAndFeel", lf);
        }
        jEdit.setFontProperty("metal.primary.font", this.primaryFont.getFont());
        jEdit.setFontProperty("metal.secondary.font", this.secondaryFont.getFont());
        jEdit.setFontProperty("helpviewer.font", this.helpViewerFont.getFont());
        jEdit.setProperty("history", this.history.getText());
        jEdit.setProperty("menu.spillover", this.menuSpillover.getText());
        jEdit.setBooleanProperty("tip.show", this.showTips.isSelected());
        if (SystemTray.isSupported()) {
            jEdit.setBooleanProperty("systrayicon", this.systemTrayIcon.isSelected());
            if (OperatingSystem.isX11()) {
                String systemTrayIconBackgroundOld = jEdit.getProperty("systrayicon.background", "autodetect");
                String systemTrayIconBackgroundNew = this.systemTrayIconBackgroundDefault.isSelected() ? "default" : (this.systemTrayIconBackgroundAutodetect.isSelected() ? "autodetect" : (this.systemTrayIconBackgroundFixedColor.isSelected() ? "fixed" : (this.systemTrayIconBackgroundPickedRectangle.isSelected() ? "picked" : "autodetect")));
                jEdit.setProperty("systrayicon.background", systemTrayIconBackgroundNew);
                Color systemTrayIconBackgroundColorOld = jEdit.getColorProperty("systrayicon.bgColor");
                Color systemTrayIconBackgroundColorNew = this.systemTrayIconBackgroundColor.getSelectedColor();
                jEdit.setColorProperty("systrayicon.bgColor", systemTrayIconBackgroundColorNew);
                Color[][] systemTrayIconBackgroundRectangleColorMatrixOld = jEdit.getColorMatrixProperty("systrayicon.bgPixel");
                BufferedImage systemTrayIconBackgroundRectangleImage = this.systemTrayIconBackgroundRectangle.getSelectedImage();
                Color[][] systemTrayIconBackgroundRectangleColorMatrixNew = null;
                if (systemTrayIconBackgroundRectangleImage != null) {
                    int width = systemTrayIconBackgroundRectangleImage.getWidth();
                    int height = systemTrayIconBackgroundRectangleImage.getHeight();
                    Color[] systemTrayIconBackgroundRectangleColors = (Color[])Arrays.stream(systemTrayIconBackgroundRectangleImage.getRGB(0, 0, width, height, null, 0, width)).mapToObj(Color::new).toArray(Color[]::new);
                    systemTrayIconBackgroundRectangleColorMatrixNew = (Color[][])IntStream.range(0, height).mapToObj(i -> Arrays.copyOfRange(systemTrayIconBackgroundRectangleColors, i * width, (i + 1) * width)).toArray(x$0 -> new Color[x$0][]);
                }
                jEdit.setColorMatrixProperty("systrayicon.bgPixel", systemTrayIconBackgroundRectangleColorMatrixNew);
                if (!systemTrayIconBackgroundOld.equals(systemTrayIconBackgroundNew) || systemTrayIconBackgroundNew.equals("fixed") && !systemTrayIconBackgroundColorOld.equals(systemTrayIconBackgroundColorNew) || systemTrayIconBackgroundNew.equals("picked") && !Arrays.deepEquals((Object[])systemTrayIconBackgroundRectangleColorMatrixOld, systemTrayIconBackgroundRectangleColorMatrixNew)) {
                    JTrayIconManager.removeTrayIcon();
                    JTrayIconManager.addTrayIcon();
                }
            }
        }
        IconTheme.set(this.iconThemes.getSelectedItem().toString());
        if (!jEdit.getProperty("lookAndFeel").startsWith("com.formdev.flatlaf.")) {
            this.setFonts();
        }
        this.setFileFlag("nosplash", !this.showSplash.isSelected());
        jEdit.setBooleanProperty("textColors", this.textColors.isSelected());
        jEdit.setBooleanProperty("decorate.frames", this.decorateFrames.isSelected());
        jEdit.setBooleanProperty("decorate.dialogs", this.decorateDialogs.isSelected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setFileFlag(String fileName, boolean present) {
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory == null) return;
        File file = new File(settingsDirectory, fileName);
        if (!present) {
            file.delete();
            return;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(10);
            out.close();
        }
        catch (IOException io) {
            try {
                Log.log(9, this, io);
            }
            catch (Throwable throwable) {
                IOUtilities.closeQuietly(out);
                throw throwable;
            }
            IOUtilities.closeQuietly(out);
            return;
        }
        IOUtilities.closeQuietly(out);
        return;
    }

    private void setFonts() {
        UIManager.put("Button.font", this.primaryFont.getFont());
        UIManager.put("CheckBox.font", this.primaryFont.getFont());
        UIManager.put("CheckBoxMenuItem.font", this.primaryFont.getFont());
        UIManager.put("ColorChooser.font", this.primaryFont.getFont());
        UIManager.put("DesktopIcon.font", this.primaryFont.getFont());
        UIManager.put("Label.font", this.primaryFont.getFont());
        UIManager.put("Menu.font", this.primaryFont.getFont());
        UIManager.put("MenuBar.font", this.primaryFont.getFont());
        UIManager.put("MenuItem.font", this.primaryFont.getFont());
        UIManager.put("OptionPane.font", this.primaryFont.getFont());
        UIManager.put("Panel.font", this.primaryFont.getFont());
        UIManager.put("PopupMenu.font", this.primaryFont.getFont());
        UIManager.put("ProgressBar.font", this.primaryFont.getFont());
        UIManager.put("RadioButton.font", this.primaryFont.getFont());
        UIManager.put("RadioButtonMenuItem.font", this.primaryFont.getFont());
        UIManager.put("ScrollPane.font", this.primaryFont.getFont());
        UIManager.put("Slider.font", this.primaryFont.getFont());
        UIManager.put("TabbedPane.font", this.primaryFont.getFont());
        UIManager.put("Table.font", this.primaryFont.getFont());
        UIManager.put("TableHeader.font", this.primaryFont.getFont());
        UIManager.put("TitledBorder.font", this.primaryFont.getFont());
        UIManager.put("ToggleButton.font", this.primaryFont.getFont());
        UIManager.put("ToolBar.font", this.primaryFont.getFont());
        UIManager.put("ToolTip.font", this.primaryFont.getFont());
        UIManager.put("Tree.font", this.primaryFont.getFont());
        UIManager.put("Viewport.font", this.primaryFont.getFont());
        UIManager.put("ComboBox.font", this.secondaryFont.getFont());
        UIManager.put("EditorPane.font", this.secondaryFont.getFont());
        UIManager.put("FormattedTextField.font", this.secondaryFont.getFont());
        UIManager.put("List.font", this.secondaryFont.getFont());
        UIManager.put("PasswordField.font", this.secondaryFont.getFont());
        UIManager.put("Spinner.font", this.secondaryFont.getFont());
        UIManager.put("TextArea.font", this.secondaryFont.getFont());
        UIManager.put("TextField.font", this.secondaryFont.getFont());
        UIManager.put("TextPane.font", this.secondaryFont.getFont());
    }

    @Override
    public final void itemStateChanged(ItemEvent evt) {
        this.lnfChanged = true;
    }
}

