/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.concurrent.GuardedBy;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.BufferHistory;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.gui.FilesChangedDialog;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.manager.BufferManager;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.AwtRunnableQueue;
import org.gjt.sp.util.StandardUtilities;

public class BufferManagerImpl
implements BufferManager {
    public static final Buffer[] EMPTY_BUFFER_ARRAY = new Buffer[0];
    private final Object bufferListLock = new Object();
    private final Map<String, Buffer> bufferHash = new HashMap<String, Buffer>();
    private boolean sortBuffers;
    private boolean sortByName;
    private int bufferCount;
    private Buffer buffersFirst;
    private Buffer buffersLast;

    public Object getBufferListLock() {
        return this.bufferListLock;
    }

    @Override
    @GuardedBy(value="bufferListLock")
    public List<Buffer> getBuffers() {
        ArrayList<Buffer> buffers = new ArrayList<Buffer>(this.bufferCount);
        this.forEach(buffers::add);
        return buffers;
    }

    @GuardedBy(value="bufferListLock")
    public List<Buffer> getBuffers(Predicate<Buffer> predicate) {
        ArrayList<Buffer> buffers = new ArrayList<Buffer>(this.bufferCount);
        this.forEach(buffer -> {
            if (predicate.test((Buffer)buffer)) {
                buffers.add((Buffer)buffer);
            }
        });
        return buffers;
    }

    @Override
    public List<Buffer> getTitledBuffers() {
        return this.getBuffers(Buffer::isTitled);
    }

    @Override
    public List<Buffer> getUntitledBuffers() {
        return this.getBuffers(Buffer::isUntitled);
    }

    @Override
    public List<Buffer> getNonUntitledDirtyBuffers() {
        Predicate<Buffer> isTitled = Buffer::isTitled;
        Predicate<Buffer> isDirty = JEditBuffer::isDirty;
        return this.getBuffers(isTitled.and(isDirty));
    }

    @Override
    public List<Buffer> getDirtyBuffers() {
        return this.getBuffers(JEditBuffer::isDirty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="bufferListLock")
    public void forEach(Consumer<? super Buffer> action) {
        Object object = this.bufferListLock;
        synchronized (object) {
            Buffer buffer = this.buffersFirst;
            for (int i = 0; i < this.bufferCount; ++i) {
                action.accept(buffer);
                buffer = buffer.getNext();
            }
        }
    }

    @Override
    public int size() {
        return this.bufferCount;
    }

    @Override
    public Buffer getFirst() {
        return this.buffersFirst;
    }

    public Buffer getLast() {
        return this.buffersLast;
    }

    public void checkBufferStatus(View view, boolean currentBuffer, boolean autoReload) {
        Buffer buffer = this.buffersFirst;
        int[] states = new int[this.bufferCount];
        int i = 0;
        boolean notifyFileChanged = false;
        while (buffer != null) {
            if (currentBuffer && buffer != view.getBuffer()) {
                buffer = buffer.getNext();
                ++i;
                continue;
            }
            states[i] = buffer.checkFileStatus(view);
            switch (states[i]) {
                case 1: {
                    if (buffer.getAutoReload()) {
                        if (buffer.isDirty()) {
                            notifyFileChanged = true;
                        } else {
                            buffer.load(view, true);
                            Buffer b = buffer;
                            AwtRunnableQueue.INSTANCE.runAfterIoTasks(() -> this.updateBufferHash(b));
                        }
                    } else {
                        autoReload = false;
                    }
                    if (!buffer.getAutoReloadDialog()) break;
                    notifyFileChanged = true;
                    break;
                }
                case 2: {
                    notifyFileChanged = true;
                }
            }
            buffer = buffer.getNext();
            ++i;
        }
        if (notifyFileChanged) {
            new FilesChangedDialog(view, states, autoReload);
        }
    }

    public void setSortBuffers(boolean sortBuffers) {
        this.sortBuffers = sortBuffers;
    }

    public void setSortByName(boolean sortByName) {
        this.sortByName = sortByName;
    }

    @Override
    public Optional<Buffer> getBuffer(String path) {
        return this._getBuffer(MiscUtilities.resolveSymlinks(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Buffer> _getBuffer(String path) {
        if ((VFSManager.getVFSForPath(path).getCapabilities() & 0x80) != 0) {
            path = path.toLowerCase();
        }
        Object object = this.bufferListLock;
        synchronized (object) {
            return Optional.ofNullable(this.bufferHash.get(path));
        }
    }

    @Override
    public int getNextUntitledBufferId() {
        int untitledCount = 0;
        for (Buffer buffer = this.buffersFirst; buffer != null; buffer = buffer.getNext()) {
            if (!buffer.getName().startsWith("Untitled-")) continue;
            try {
                untitledCount = Math.max(untitledCount, Integer.parseInt(buffer.getName().substring(9)));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return untitledCount + 1;
    }

    public void updateBufferHash(Buffer buffer) {
        this.bufferHash.values().removeIf(b -> buffer == b);
        String path = BufferManagerImpl.getPathForBufferHash(buffer);
        this.bufferHash.put(path, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBufferFromList(Buffer buffer) {
        Object object = this.bufferListLock;
        synchronized (object) {
            --this.bufferCount;
            String path = buffer.getPath();
            if (OperatingSystem.isCaseInsensitiveFS()) {
                path = path.toLowerCase();
            }
            this.bufferHash.remove(path);
            if (buffer == this.buffersFirst && buffer == this.buffersLast) {
                this.buffersLast = null;
                this.buffersFirst = null;
                return;
            }
            if (buffer == this.buffersFirst) {
                this.buffersFirst = buffer.getNext();
                buffer.getNext().setPrev(null);
            } else if (buffer.getPrev() != null) {
                buffer.getPrev().setNext(buffer.getNext());
            }
            if (buffer == this.buffersLast) {
                this.buffersLast = this.buffersLast.getPrev();
                buffer.getPrev().setNext(null);
            } else if (buffer.getNext() != null) {
                buffer.getNext().setPrev(buffer.getPrev());
            }
            buffer.setNext(null);
            buffer.setPrev(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBufferToList(Buffer buffer) {
        Object object = this.bufferListLock;
        synchronized (object) {
            String symlinkPath = BufferManagerImpl.getPathForBufferHash(buffer);
            ++this.bufferCount;
            this.bufferHash.put(symlinkPath, buffer);
            if (this.buffersFirst == null) {
                this.buffersFirst = this.buffersLast = buffer;
                return;
            }
            if (this.sortBuffers) {
                String str12;
                String str11;
                if (this.sortByName) {
                    str11 = buffer.getName();
                    str12 = buffer.getDirectory();
                } else {
                    str11 = buffer.getDirectory();
                    str12 = buffer.getName();
                }
                for (Buffer _buffer = this.buffersFirst; _buffer != null; _buffer = _buffer.getNext()) {
                    String str22;
                    String str21;
                    if (this.sortByName) {
                        str21 = _buffer.getName();
                        str22 = _buffer.getDirectory();
                    } else {
                        str21 = _buffer.getDirectory();
                        str22 = _buffer.getName();
                    }
                    int comp = StandardUtilities.compareStrings(str11, str21, true);
                    if (comp >= 0 && (comp != 0 || StandardUtilities.compareStrings(str12, str22, true) >= 0)) continue;
                    buffer.setNext(_buffer);
                    buffer.setPrev(_buffer.getPrev());
                    _buffer.setPrev(buffer);
                    if (_buffer != this.buffersFirst) {
                        buffer.getPrev().setNext(buffer);
                    } else {
                        this.buffersFirst = buffer;
                    }
                    return;
                }
            }
            buffer.setPrev(this.buffersLast);
            buffer.setNext(null);
            this.buffersLast.setNext(buffer);
            this.buffersLast = buffer;
        }
    }

    public void updatePosition(String oldPath, Buffer buffer) {
        if ((VFSManager.getVFSForPath(oldPath).getCapabilities() & 0x80) != 0) {
            oldPath = oldPath.toLowerCase();
        }
        this.bufferHash.remove(oldPath);
        String path = BufferManagerImpl.getPathForBufferHash(buffer);
        this.bufferHash.put(path, buffer);
        if (this.sortBuffers) {
            this.removeBufferFromList(buffer);
            this.addBufferToList(buffer);
        }
    }

    public void removeBuffer(Buffer buffer) {
        String path = BufferManagerImpl.getPathForBufferHash(buffer);
        this.bufferHash.remove(path);
        this.removeBufferFromList(buffer);
    }

    private static String getPathForBufferHash(Buffer buffer) {
        String path = buffer.getSymlinkPath();
        if ((VFSManager.getVFSForPath(path).getCapabilities() & 0x80) != 0) {
            path = path.toLowerCase();
        }
        return path;
    }

    public void closeAllBuffers(View view, boolean isExiting, boolean autosaveUntitled, boolean saveRecent, boolean persistentMarkers) {
        this.buffersLast = null;
        this.buffersFirst = null;
        this.bufferHash.clear();
        this.bufferCount = 0;
        for (Buffer buffer = this.buffersFirst; buffer != null; buffer = buffer.getNext()) {
            if ((!buffer.isNewFile() || buffer.isUntitled() && autosaveUntitled) && saveRecent) {
                Integer _caret = (Integer)buffer.getProperty("Buffer__caret");
                int caret = _caret == null ? 0 : _caret;
                BufferHistory.setEntry(buffer.getPath(), caret, (Selection[])buffer.getProperty("Buffer__selection"), buffer.getStringProperty("encoding"), buffer.getMode().getName());
            }
            if (!(isExiting || buffer.isUntitled() && autosaveUntitled)) {
                EditBus.send(new BufferUpdate(buffer, view, BufferUpdate.CLOSING));
            }
            buffer.close();
            DisplayManager.bufferClosed(buffer);
            if (!(isExiting || buffer.isUntitled() && autosaveUntitled)) {
                jEdit.getBufferSetManager().removeBuffer(buffer);
                EditBus.send(new BufferUpdate(buffer, view, BufferUpdate.CLOSED));
            }
            if (!jEdit.getBooleanProperty("persistentMarkers")) continue;
            buffer.updateMarkersFile(view);
        }
    }
}

