/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JComponent;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusBarEventType;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;

public class StatsBarWidgetPanel
extends Box {
    private final String propertyName;
    private final View view;
    private final List<Widget> widgets;
    private String statusBarProperty;

    public StatsBarWidgetPanel(String propertyName, View view) {
        super(0);
        this.propertyName = propertyName;
        this.view = view;
        this.widgets = new ArrayList<Widget>();
    }

    public void propertiesChanged() {
        Color fg = jEdit.getColorProperty("view.status.foreground");
        Color bg = jEdit.getColorProperty("view.status.background");
        String statusBarProperty = jEdit.getProperty(this.propertyName);
        if (!Objects.equals(this.statusBarProperty, statusBarProperty)) {
            this.removeAll();
            this.statusBarProperty = statusBarProperty;
            StringTokenizer tokenizer = new StringTokenizer(statusBarProperty);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                Widget widget = this.getWidget(token);
                if (widget == null) continue;
                this.widgets.add(widget);
                JComponent widgetComponent = widget.getComponent();
                ((Component)widgetComponent).setBackground(bg);
                ((Component)widgetComponent).setForeground(fg);
                this.add(widgetComponent);
                widget.update();
                widget.propertiesChanged();
            }
        }
    }

    public void updateEvent(StatusBarEventType statusBarEventType) {
        this.widgets.stream().filter(widget -> widget.test(statusBarEventType)).forEach(Widget::update);
    }

    private Widget getWidget(String name) {
        StatusWidgetFactory widgetFactory = ServiceManager.getService(StatusWidgetFactory.class, name);
        if (widgetFactory == null) {
            return null;
        }
        return widgetFactory.getWidget(this.view);
    }
}

