/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.util.Log;

public class LastModifiedWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        return new LastModifiedWidget(view);
    }

    public static class LastModifiedWidget
    implements Widget {
        private final JLabel label;
        private final View view;

        LastModifiedWidget(View view) {
            this.view = view;
            this.label = new ToolTipLabel(){

                @Override
                public void addNotify() {
                    super.addNotify();
                    this.update();
                    EditBus.addToBus(this);
                }

                @Override
                public void removeNotify() {
                    super.removeNotify();
                    EditBus.removeFromBus(this);
                }
            };
            this.label.setToolTipText(jEdit.getProperty("fileprop.lastmod"));
            this.update();
        }

        @Override
        public JComponent getComponent() {
            return this.label;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update() {
            Buffer buffer = this.view.getBuffer();
            String path = buffer.getPath();
            VFS vfs = VFSManager.getVFSForPath(path);
            Object session = vfs.createVFSSession(path, this.view);
            try {
                VFSFile file = vfs._getFile(session, path, this.view);
                if (file == null) {
                    this.label.setText("");
                } else {
                    this.label.setText(file.getExtendedAttribute("modified"));
                }
            }
            catch (IOException e) {
                Log.log(9, this, e);
            }
            finally {
                try {
                    vfs._endVFSSession(session, this.view);
                }
                catch (IOException iOException) {}
            }
        }

        @EditBus.EBHandler
        public void handleMessage(EditPaneUpdate message) {
            if (message.getWhat() == EditPaneUpdate.BUFFER_CHANGED && message.getEditPane().getView() == this.view) {
                this.update();
            }
        }

        @EditBus.EBHandler
        public void handleMessage(BufferUpdate message) {
            if (message.getBuffer() == this.view.getBuffer()) {
                this.update();
            }
        }
    }
}

