/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.event.MouseEvent;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.AbstractLabelWidget;
import org.gjt.sp.jedit.gui.statusbar.StatusBarEventType;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.StandardUtilities;

public class CaretStatusWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        return new CaretStatus(view);
    }

    private static class CaretStatus
    extends AbstractLabelWidget {
        private final StringBuilder buf = new StringBuilder();
        private final Segment seg = new Segment();
        private boolean lineNumberOption;
        private boolean dotOption;
        private boolean virtualOption;
        private boolean offsetOption;
        private boolean bufferlength;

        CaretStatus(View view) {
            super(view);
            this.label.setToolTipText(jEdit.getProperty("view.status.caret-tooltip"));
        }

        @Override
        protected void doubleClick(MouseEvent e) {
            this.view.getTextArea().showGoToLineDialog();
        }

        @Override
        public void propertiesChanged() {
            this.lineNumberOption = jEdit.getBooleanProperty("view.status.show-caret-linenumber", true);
            this.dotOption = jEdit.getBooleanProperty("view.status.show-caret-dot", true);
            this.virtualOption = jEdit.getBooleanProperty("view.status.show-caret-virtual", true);
            this.offsetOption = jEdit.getBooleanProperty("view.status.show-caret-offset", true);
            this.bufferlength = jEdit.getBooleanProperty("view.status.show-caret-bufferlength", true);
        }

        @Override
        public void update() {
            Buffer buffer = this.view.getBuffer();
            if (!buffer.isLoaded() || buffer != this.view.getTextArea().getBuffer()) {
                this.label.setText(" ");
                return;
            }
            JEditTextArea textArea = this.view.getTextArea();
            int caretPosition = textArea.getCaretPosition();
            int currLine = textArea.getCaretLine();
            if (currLine >= buffer.getLineCount()) {
                return;
            }
            int start = textArea.getLineStartOffset(currLine);
            int dot = caretPosition - start;
            if (dot < 0) {
                return;
            }
            int bufferLength = buffer.getLength();
            buffer.getText(start, dot, this.seg);
            int virtualPosition = StandardUtilities.getVirtualWidth(this.seg, buffer.getTabSize());
            this.seg.array = null;
            this.seg.count = 0;
            if (this.lineNumberOption) {
                this.buf.append(currLine + 1);
                this.buf.append(',');
            }
            if (this.dotOption) {
                this.buf.append(dot + 1);
            }
            if (this.virtualOption && virtualPosition != dot) {
                this.buf.append('-');
                this.buf.append(virtualPosition + 1);
            }
            if (this.buf.length() > 0) {
                this.buf.append(' ');
            }
            if (this.offsetOption && this.bufferlength) {
                this.buf.append('(');
                this.buf.append(caretPosition);
                this.buf.append('/');
                this.buf.append(bufferLength);
                this.buf.append(')');
            } else if (this.offsetOption) {
                this.buf.append('(');
                this.buf.append(caretPosition);
                this.buf.append(')');
            } else if (this.bufferlength) {
                this.buf.append('(');
                this.buf.append(bufferLength);
                this.buf.append(')');
            }
            this.label.setText(this.buf.toString());
            this.buf.setLength(0);
        }

        @Override
        public boolean test(StatusBarEventType statusBarEventType) {
            return statusBarEventType == StatusBarEventType.Caret;
        }
    }
}

