/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;

class PropertyManager {
    private final Properties system = new Properties();
    private final List<Properties> plugins = new LinkedList<Properties>();
    private final Properties site = new Properties();
    private final Properties localization = new Properties();
    private final List<Properties> pluginLocalizations = new LinkedList<Properties>();
    private final Properties user = new Properties();

    PropertyManager() {
    }

    Properties getProperties() {
        Properties total = new Properties();
        total.putAll((Map<?, ?>)this.system);
        for (Properties plugin : this.plugins) {
            total.putAll((Map<?, ?>)plugin);
        }
        total.putAll((Map<?, ?>)this.site);
        total.putAll((Map<?, ?>)this.localization);
        for (Properties pluginLocalization : this.pluginLocalizations) {
            total.putAll((Map<?, ?>)pluginLocalization);
        }
        total.putAll((Map<?, ?>)this.user);
        return total;
    }

    void loadSystemProps(String path) throws IOException {
        Optional<Reader> resourceOptional = jEdit.getResourceAsUTF8Text(path);
        if (resourceOptional.isPresent()) {
            try (Reader in = resourceOptional.get();){
                PropertyManager.loadProps(this.system, in);
            }
        } else {
            throw new IOException("Resource not found: " + path);
        }
    }

    void loadSiteProps(InputStream in) throws IOException {
        PropertyManager.loadProps(this.site, in);
    }

    void loadLocalizationProps(String path) throws IOException {
        Optional<Reader> resourceOptional = jEdit.getResourceAsUTF8Text(path);
        if (resourceOptional.isPresent()) {
            try (Reader in = resourceOptional.get();){
                PropertyManager.loadProps(this.localization, in);
            }
        } else {
            this.localization.clear();
        }
    }

    void loadUserProps(InputStream in) throws IOException {
        PropertyManager.loadProps(this.user, in);
    }

    void saveUserProps(OutputStream out) throws IOException {
        MiscUtilities.storeProperties(this.user, out, "jEdit properties");
    }

    Properties loadPluginProps(InputStream in) throws IOException {
        Properties plugin = new Properties();
        PropertyManager.loadProps(plugin, in);
        this.plugins.add(plugin);
        return plugin;
    }

    void addPluginProps(Properties props) {
        this.plugins.add(props);
    }

    void removePluginProps(Properties props) {
        this.plugins.remove(props);
    }

    Properties loadPluginLocalizationProps(Reader in) throws IOException {
        Properties pluginLocalization = new Properties();
        PropertyManager.loadProps(pluginLocalization, in);
        this.pluginLocalizations.add(pluginLocalization);
        return pluginLocalization;
    }

    void addPluginLocalizationProps(Properties props) {
        this.pluginLocalizations.add(props);
    }

    void removePluginLocalizationProps(Properties props) {
        this.pluginLocalizations.remove(props);
    }

    String getProperty(String name) {
        String value = this.user.getProperty(name);
        if (value != null) {
            return value;
        }
        for (Properties pluginLocalization : this.pluginLocalizations) {
            value = pluginLocalization.getProperty(name);
            if (value == null) continue;
            return value;
        }
        value = this.localization.getProperty(name);
        if (value != null) {
            return value;
        }
        return this.getDefaultProperty(name);
    }

    void setProperty(String name, String value) {
        String prop = this.getDefaultProperty(name);
        if (value == null) {
            if (prop == null || prop.isEmpty()) {
                this.user.remove(name);
            } else {
                this.user.setProperty(name, "");
            }
        } else if (value.equals(prop)) {
            this.user.remove(name);
        } else {
            this.user.setProperty(name, value);
        }
    }

    public void setTemporaryProperty(String name, String value) {
        this.user.remove(name);
        this.system.setProperty(name, value);
    }

    void unsetProperty(String name) {
        if (this.getDefaultProperty(name) != null) {
            this.user.setProperty(name, "");
        } else {
            this.user.remove(name);
        }
    }

    public void resetProperty(String name) {
        this.user.remove(name);
    }

    private String getDefaultProperty(String name) {
        String value = this.site.getProperty(name);
        if (value != null) {
            return value;
        }
        List<Properties> list = Collections.synchronizedList(this.plugins);
        for (Properties plugin : list) {
            value = plugin.getProperty(name);
            if (value == null) continue;
            return value;
        }
        return this.system.getProperty(name);
    }

    private static void loadProps(Properties into, InputStream in) throws IOException {
        try {
            into.load(in);
        }
        finally {
            in.close();
        }
    }

    private static void loadProps(Properties into, Reader in) throws IOException {
        try {
            into.load(in);
        }
        finally {
            in.close();
        }
    }
}

