/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.swing.UIManager;
import org.gjt.sp.jedit.BeanShellFacade;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.JARClassLoader;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bsh.BshMethod;
import org.gjt.sp.jedit.bsh.EvalError;
import org.gjt.sp.jedit.bsh.Interpreter;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.gui.BeanShellErrorDialog;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.TaskManager;

public class BeanShell {
    private static final BeanShellFacade<View> bsh = new MyBeanShellFacade();
    private static boolean running;

    static void init() {
        Log.log(3, BeanShell.class, "Beanshell Init");
    }

    public static void evalSelection(View view, JEditTextArea textArea) {
        bsh.evalSelection(view, textArea);
    }

    public static void showEvaluateDialog(View view) {
        Object command = GUIUtilities.input(view, "beanshell-eval-input", null);
        if (command != null) {
            if (!((String)command).endsWith(";")) {
                command = (String)command + ";";
            }
            int repeat = view.getInputHandler().getRepeatCount();
            if (view.getMacroRecorder() != null) {
                view.getMacroRecorder().record(repeat, (String)command);
            }
            Object returnValue = null;
            try {
                for (int i = 0; i < repeat; ++i) {
                    returnValue = bsh._eval(view, bsh.getNameSpace(), (String)command);
                }
            }
            catch (Throwable e) {
                Log.log(9, BeanShell.class, e);
                bsh.handleException(view, null, e);
            }
            if (returnValue != null) {
                Object[] args = new String[]{returnValue.toString()};
                GUIUtilities.message(view, "beanshell-eval", args);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showEvaluateLinesDialog(View view) {
        Object command = GUIUtilities.input(view, "beanshell-eval-line", null);
        JEditTextArea textArea = view.getTextArea();
        Buffer buffer = view.getBuffer();
        if (command == null || ((String)command).isEmpty()) {
            return;
        }
        Selection[] selection = textArea.getSelection();
        if (selection.length == 0) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        if (!((String)command).endsWith(";")) {
            command = (String)command + ";";
        }
        String script = "int[] lines = textArea.getSelectedLines();\nfor(int i = 0; i < lines.length; i++)\n{\nline = lines[i];\nindex = line - lines[0];\nstart = buffer.getLineStartOffset(line);\nend = buffer.getLineEndOffset(line);\ntext = buffer.getText(start,end - start - 1);\nnewText = " + (String)command + "\nif(newText != null)\n{\nbuffer.remove(start,end - start - 1);\nbuffer.insert(start,String.valueOf(newText));\n}\n}\n";
        if (view.getMacroRecorder() != null) {
            view.getMacroRecorder().record(1, script);
        }
        try {
            buffer.beginCompoundEdit();
            bsh.eval(view, script);
        }
        finally {
            buffer.endCompoundEdit();
        }
        textArea.selectNone();
    }

    public static void runScript(View view, String path, Reader in, boolean ownNamespace) {
        try {
            BeanShell._runScript(view, path, in, ownNamespace);
        }
        catch (Throwable e) {
            Log.log(9, BeanShell.class, e);
            bsh.handleException(view, path, e);
        }
    }

    public static void runScript(View view, String path, Reader in, NameSpace namespace) {
        try {
            BeanShell._runScript(view, path, in, namespace);
        }
        catch (Throwable e) {
            Log.log(9, BeanShell.class, e);
            bsh.handleException(view, path, e);
        }
    }

    public static void _runScript(View view, String path, Reader in, boolean ownNamespace) throws Exception {
        BeanShell._runScript(view, path, in, ownNamespace ? new NameSpace(bsh.getNameSpace(), "namespace") : bsh.getNameSpace());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _runScript(View view, String path, Reader in, NameSpace namespace) throws Exception {
        Log.log(3, BeanShell.class, "Running script " + path);
        Interpreter interp = BeanShellFacade.createInterpreter(namespace);
        try {
            if (in == null) {
                Buffer buffer = jEdit.openTemporary(null, null, path, false);
                if (!buffer.isLoaded()) {
                    TaskManager.instance.waitForIoTasks();
                }
                in = new StringReader(buffer.getText(0, buffer.getLength()));
            }
            bsh.setupDefaultVariables(namespace, view);
            interp.set("scriptPath", path);
            running = true;
            interp.eval(in, namespace, path);
        }
        catch (Exception e) {
            BeanShellFacade.unwrapException(e);
        }
        finally {
            running = false;
            try {
                if (namespace == bsh.getNameSpace()) {
                    bsh.resetDefaultVariables(namespace);
                    interp.unset("scriptPath");
                }
            }
            catch (EvalError evalError) {}
        }
    }

    public static Object eval(View view, NameSpace namespace, String command) {
        return bsh.eval(view, namespace, command);
    }

    public static Object _eval(View view, NameSpace namespace, String command) throws Exception {
        return bsh._eval(view, namespace, command);
    }

    public static BshMethod cacheBlock(String id, String code, boolean namespace) throws Exception {
        return bsh.cacheBlock(id, code, namespace);
    }

    public static Object runCachedBlock(BshMethod method, View view, NameSpace namespace) throws Exception {
        return bsh.runCachedBlock(method, view, namespace);
    }

    public static boolean isScriptRunning() {
        return running;
    }

    public static NameSpace getNameSpace() {
        return bsh.getNameSpace();
    }

    static void resetClassManager() {
        bsh.resetClassManager();
    }

    private static class MyBeanShellFacade
    extends BeanShellFacade<View> {
        private MyBeanShellFacade() {
            this.classManager.setClassLoader(new JARClassLoader());
        }

        @Override
        protected void init() {
            super.init();
            this.global.importPackage("org.gjt.sp.jedit.browser");
            this.global.importPackage("org.gjt.sp.jedit.bufferset");
            this.global.importPackage("org.gjt.sp.jedit.statusbar");
            this.global.importPackage("org.gjt.sp.jedit.gui");
            this.global.importPackage("org.gjt.sp.jedit.help");
            this.global.importPackage("org.gjt.sp.jedit.io");
            this.global.importPackage("org.gjt.sp.jedit.menu");
            this.global.importPackage("org.gjt.sp.jedit.msg");
            this.global.importPackage("org.gjt.sp.jedit.options");
            this.global.importPackage("org.gjt.sp.jedit.pluginmgr");
            this.global.importPackage("org.gjt.sp.jedit.print");
            this.global.importPackage("org.gjt.sp.jedit.search");
            this.global.importPackage("org.jedit.io");
        }

        @Override
        protected void setupDefaultVariables(NameSpace namespace, View view) throws UtilEvalError {
            if (view != null) {
                EditPane editPane = view.getEditPane();
                this.setVariable(namespace, "view", view);
                this.setVariable(namespace, "editPane", editPane);
                this.setVariable(namespace, "buffer", editPane.getBuffer());
                this.setVariable(namespace, "textArea", editPane.getTextArea());
                this.setVariable(namespace, "wm", view.getDockableWindowManager());
            }
        }

        @Override
        protected void resetDefaultVariables(NameSpace namespace) throws UtilEvalError {
            namespace.setVariable("view", null, false);
            namespace.setVariable("editPane", null, false);
            namespace.setVariable("buffer", null, false);
            namespace.setVariable("textArea", null, false);
            namespace.setVariable("wm", null, false);
        }

        @Override
        protected void handleException(View view, String path, Throwable t) {
            if (t instanceof IOException) {
                VFSManager.error(view, path, "ioerror.read-error", new String[]{t.toString()});
            } else {
                new BeanShellErrorDialog(view, t);
            }
        }
    }
}

