/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.Highlight;
import gatchan.highlight.HighlightDialog;
import gatchan.highlight.HighlightHypersearchResults;
import gatchan.highlight.HighlightManager;
import gatchan.highlight.HighlightManagerTableModel;
import gatchan.highlight.HighlightOverview;
import gatchan.highlight.Highlighter;
import gatchan.highlight.color.FlexColorPainter;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import javax.swing.event.CaretListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.DockableWindowUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.jedit.visitors.JEditVisitor;
import org.gjt.sp.jedit.visitors.JEditVisitorAdapter;
import org.gjt.sp.util.Log;

public class HighlightPlugin
extends EditPlugin {
    private static HighlightManager highlightManager;
    private int layer;
    private float alpha;
    private boolean roundCorner;
    private boolean highlightOverview;
    private boolean highlightOverviewSameColor;
    private Color highlightOverviewColor;
    private int extraLineSpacing;

    public void start() {
        this.layer = jEdit.getIntegerProperty((String)"gatchan.highlight.layer", (int)Integer.MAX_VALUE);
        this.highlightOverview = jEdit.getBooleanProperty((String)"gatchan.highlight.overview");
        Optional<Path> highlightFile = this.getDataFile();
        highlightManager = HighlightManagerTableModel.createInstance(highlightFile.orElse(null));
        highlightManager.propertiesChanged();
        jEdit.visit((JEditVisitor)new TextAreaInitializer());
        jEdit.visit((JEditVisitor)new ViewInitializer());
        EditBus.addToBus((Object)((Object)this));
    }

    public void stop() {
        Buffer[] buffers;
        EditBus.removeFromBus((Object)((Object)this));
        jEdit.resetProperty((String)"plugin.gatchan.highlight.HighlightPlugin.activate");
        for (Buffer buffer : buffers = jEdit.getBuffers()) {
            buffer.unsetProperty("highlights");
        }
        jEdit.visit((JEditVisitor)new TextAreaUninitializer());
        jEdit.visit((JEditVisitor)new ViewUninitializer());
        highlightManager.dispose();
        highlightManager = null;
    }

    private static void uninitTextArea(JEditTextArea textArea) {
        FlexColorPainter flexColorPainter;
        TextAreaPainter painter = textArea.getPainter();
        Highlighter highlighter = (Highlighter)textArea.getClientProperty(Highlighter.class);
        if (highlighter != null) {
            painter.removeExtension((TextAreaExtension)highlighter);
            textArea.putClientProperty(Highlighter.class, null);
            highlightManager.removeHighlightChangeListener(highlighter);
        }
        if ((flexColorPainter = (FlexColorPainter)((Object)textArea.getClientProperty(FlexColorPainter.class))) != null) {
            painter.removeExtension((TextAreaExtension)flexColorPainter);
            textArea.putClientProperty(FlexColorPainter.class, null);
        }
        HighlightPlugin.removeHighlightOverview(textArea);
        textArea.removeCaretListener((CaretListener)highlightManager);
    }

    private void initTextArea(JEditTextArea textArea) {
        Highlighter highlighter = new Highlighter((TextArea)textArea);
        highlightManager.addHighlightChangeListener(highlighter);
        TextAreaPainter painter = textArea.getPainter();
        painter.addExtension(this.layer, (TextAreaExtension)highlighter);
        textArea.putClientProperty(Highlighter.class, (Object)highlighter);
        textArea.addCaretListener((CaretListener)highlightManager);
        FlexColorPainter flexColorPainter = new FlexColorPainter((TextArea)textArea);
        textArea.putClientProperty(FlexColorPainter.class, (Object)flexColorPainter);
        painter.addExtension(this.layer - 1, (TextAreaExtension)flexColorPainter);
        if (this.highlightOverview) {
            HighlightPlugin.addHighlightOverview(textArea);
        }
        textArea.revalidate();
    }

    private static void addHighlightOverview(JEditTextArea textArea) {
        HighlightOverview currentOverview = (HighlightOverview)textArea.getClientProperty(HighlightOverview.class);
        if (currentOverview == null) {
            currentOverview = new HighlightOverview(textArea);
            highlightManager.addHighlightChangeListener(currentOverview);
            textArea.addLeftOfScrollBar((Component)currentOverview);
            textArea.putClientProperty(HighlightOverview.class, (Object)currentOverview);
        }
        if (!jEdit.getBooleanProperty((String)"gatchan.highlight.overview.samecolor")) {
            currentOverview.setOverviewColor(jEdit.getColorProperty((String)"gatchan.highlight.overview.color"));
        } else {
            currentOverview.setOverviewColor(null);
        }
    }

    private static void removeHighlightOverview(JEditTextArea textArea) {
        HighlightOverview overview = (HighlightOverview)textArea.getClientProperty(HighlightOverview.class);
        if (overview != null) {
            textArea.removeLeftOfScrollBar((Component)overview);
            textArea.putClientProperty(HighlightOverview.class, null);
            highlightManager.removeHighlightChangeListener(overview);
            textArea.revalidate();
        }
    }

    private static void initView(View view) {
        HighlightHypersearchResults highlighter = new HighlightHypersearchResults(view);
        highlighter.start();
        view.getDockableWindowManager().putClientProperty(HighlightHypersearchResults.class, (Object)highlighter);
    }

    private static void uninitView(View view) {
        HighlightHypersearchResults highlighter = (HighlightHypersearchResults)view.getDockableWindowManager().getClientProperty(HighlightHypersearchResults.class);
        if (highlighter == null) {
            return;
        }
        highlighter.stop();
        view.getDockableWindowManager().putClientProperty(HighlightHypersearchResults.class, null);
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged propertiesChanged) {
        boolean newOverview = jEdit.getBooleanProperty((String)"gatchan.highlight.overview");
        boolean newOverviewSameColor = jEdit.getBooleanProperty((String)"gatchan.highlight.overview.samecolor");
        Color newOverviewColor = jEdit.getColorProperty((String)"gatchan.highlight.overview.color");
        int layer = jEdit.getIntegerProperty((String)"gatchan.highlight.layer", (int)Integer.MAX_VALUE);
        float alpha = (float)jEdit.getIntegerProperty((String)"gatchan.highlight.alpha", (int)50) / 100.0f;
        boolean roundCorner = jEdit.getBooleanProperty((String)"gatchan.highlight.roundcorner");
        int extraLineSpacing = jEdit.getIntegerProperty((String)"options.textarea.extraLineSpacing");
        if (this.extraLineSpacing != extraLineSpacing || this.roundCorner != roundCorner || this.layer != layer || this.alpha != alpha || newOverview != this.highlightOverview || newOverviewSameColor != this.highlightOverviewSameColor || this.highlightOverviewColor != null && !this.highlightOverviewColor.equals(newOverviewColor)) {
            this.highlightOverview = newOverview;
            this.highlightOverviewSameColor = newOverviewSameColor;
            this.highlightOverviewColor = newOverviewColor;
            this.layer = layer;
            this.alpha = alpha;
            this.roundCorner = roundCorner;
            this.extraLineSpacing = extraLineSpacing;
            jEdit.visit((JEditVisitor)new JEditVisitorAdapter(){

                public void visit(JEditTextArea textArea) {
                    TextAreaPainter painter = textArea.getPainter();
                    Highlighter highlighter = (Highlighter)textArea.getClientProperty(Highlighter.class);
                    highlighter.setAlphaComposite(HighlightPlugin.this.alpha);
                    highlighter.setRoundcorner(HighlightPlugin.this.roundCorner);
                    painter.removeExtension((TextAreaExtension)highlighter);
                    painter.addExtension(HighlightPlugin.this.layer, (TextAreaExtension)highlighter);
                    if (HighlightPlugin.this.highlightOverview) {
                        HighlightPlugin.addHighlightOverview(textArea);
                    } else {
                        HighlightPlugin.removeHighlightOverview(textArea);
                    }
                }
            });
        }
        highlightManager.propertiesChanged();
    }

    @EditBus.EBHandler
    public void handleViewUpdate(ViewUpdate vu) {
        View view = vu.getView();
        Object what = vu.getWhat();
        if (what == ViewUpdate.CREATED) {
            HighlightPlugin.initView(view);
        } else if (what == ViewUpdate.CLOSED) {
            HighlightPlugin.uninitView(view);
        } else if (what == ViewUpdate.EDIT_PANE_CHANGED) {
            highlightManager.caretUpdate(view.getTextArea());
        }
    }

    @EditBus.EBHandler
    public void handleEditPaneUpdate(EditPaneUpdate editPaneUpdate) {
        JEditTextArea textArea = editPaneUpdate.getEditPane().getTextArea();
        Object what = editPaneUpdate.getWhat();
        if (what == EditPaneUpdate.CREATED) {
            this.initTextArea(textArea);
        } else if (what == EditPaneUpdate.DESTROYED) {
            HighlightPlugin.uninitTextArea(textArea);
        }
    }

    @EditBus.EBHandler
    public void handleBufferPaneUpdate(BufferUpdate bufferUpdate) {
        if (bufferUpdate.getWhat() == BufferUpdate.CLOSED) {
            highlightManager.bufferClosed(bufferUpdate.getBuffer());
        }
    }

    @EditBus.EBHandler
    public void handleDockableWindowUpdate(DockableWindowUpdate dockableUpdate) {
        if (dockableUpdate.getWhat() == DockableWindowUpdate.ACTIVATED && "hypersearch-results".equals(dockableUpdate.getDockable())) {
            View view = ((DockableWindowManager)dockableUpdate.getSource()).getView();
            HighlightHypersearchResults highlighter = (HighlightHypersearchResults)view.getDockableWindowManager().getClientProperty(HighlightHypersearchResults.class);
            if (highlighter == null) {
                HighlightPlugin.initView(view);
            } else {
                highlighter.start();
            }
        }
    }

    public static void highlightThis(JEditTextArea textArea) {
        HighlightPlugin.highlightThis(textArea, 0);
    }

    public static void highlightThis(JEditTextArea textArea, int scope) {
        String text = HighlightPlugin.getCurrentWord((TextArea)textArea);
        if (text == null) {
            return;
        }
        Highlight highlight = new Highlight(text);
        highlight.setScope(scope);
        if (scope == 2) {
            highlight.setBuffer(textArea.getBuffer());
        }
        highlightManager.addElement(highlight);
    }

    private static String getCurrentWord(TextArea textArea) {
        String text = textArea.getSelectedText();
        if (text == null) {
            textArea.selectWord();
            text = textArea.getSelectedText();
        }
        return text;
    }

    public static void highlightEntireWord(JEditTextArea textArea) {
        HighlightPlugin.highlightEntireWord(textArea, 0);
    }

    public static void highlightEntireWord(JEditTextArea textArea, int scope) {
        String text = HighlightPlugin.getCurrentWord((TextArea)textArea);
        if (text == null) {
            return;
        }
        Highlight highlight = new Highlight("\\b" + text + "\\b", true, false);
        highlight.setScope(scope);
        if (scope == 2) {
            highlight.setBuffer(textArea.getBuffer());
        }
        highlightManager.addElement(highlight);
    }

    public static void highlightCurrentSearch() {
        HighlightPlugin.highlightCurrentSearch(0);
    }

    public static void highlightCurrentSearch(int scope) {
        Highlight h = new Highlight();
        h.setScope(scope);
        if (scope == 2) {
            h.setBuffer((JEditBuffer)jEdit.getActiveView().getBuffer());
        }
        h.init(SearchAndReplace.getSearchString(), SearchAndReplace.getRegexp(), SearchAndReplace.getIgnoreCase(), Highlight.getNextColor());
        HighlightPlugin.addHighlight(h);
    }

    public static void highlightDialog(View view, TextArea textArea) {
        String currentWord = HighlightPlugin.getCurrentWord(textArea);
        HighlightDialog d = new HighlightDialog(view);
        if (currentWord != null && !currentWord.isEmpty()) {
            d.setString(currentWord);
        }
        d.setVisible(true);
    }

    public static void addHighlight(Highlight highlight) {
        highlightManager.addElement(highlight);
    }

    public static void removeAllHighlights() {
        highlightManager.removeAll();
    }

    public static void enableHighlights() {
        highlightManager.setHighlightEnable(true);
    }

    public static void disableHighlights() {
        highlightManager.setHighlightEnable(false);
    }

    public static void toggleHighlights() {
        highlightManager.setHighlightEnable(!highlightManager.isHighlightEnable());
    }

    public static void highlightHyperSearchResult(View view) {
        HighlightHypersearchResults h = (HighlightHypersearchResults)view.getDockableWindowManager().getClientProperty(HighlightHypersearchResults.class);
        if (h == null) {
            return;
        }
        h.start();
    }

    public static boolean isHighlightEnable() {
        return highlightManager.isHighlightEnable();
    }

    public Optional<Path> getDataFile() {
        File pluginHome = this.getPluginHome();
        if (pluginHome == null) {
            return Optional.empty();
        }
        Path pluginHomePath = pluginHome.toPath();
        try {
            Files.createDirectories(pluginHomePath, new FileAttribute[0]);
            return Optional.of(Path.of(pluginHomePath.toString(), "highlights.ser"));
        }
        catch (IOException e) {
            Log.log((int)9, (Object)((Object)this), (Object)"unable to create plugin home folder", (Throwable)e);
            return Optional.empty();
        }
    }

    private static class ViewUninitializer
    extends JEditVisitorAdapter {
        private ViewUninitializer() {
        }

        public void visit(View view) {
            HighlightPlugin.uninitView(view);
        }
    }

    private static class ViewInitializer
    extends JEditVisitorAdapter {
        private ViewInitializer() {
        }

        public void visit(View view) {
            HighlightPlugin.initView(view);
        }
    }

    private static class TextAreaUninitializer
    extends JEditVisitorAdapter {
        private TextAreaUninitializer() {
        }

        public void visit(JEditTextArea textArea) {
            HighlightPlugin.uninitTextArea(textArea);
        }
    }

    private class TextAreaInitializer
    extends JEditVisitorAdapter {
        private TextAreaInitializer() {
        }

        public void visit(JEditTextArea textArea) {
            HighlightPlugin.this.initTextArea(textArea);
        }
    }
}

