/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.Highlight;
import gatchan.highlight.HighlightManagerTableModel;
import gatchan.highlight.HighlightTablePanel;
import gatchan.highlight.InvalidHighlightException;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;

public class HighlightDialog
extends EnhancedDialog {
    private final Highlight highlight;
    private final HighlightTablePanel panel = new HighlightTablePanel();
    private final JComboBox<Integer> scopeCombo = new JComboBox<Integer>(new Integer[]{0, 1, 2});
    private final JSpinner spinner;

    public HighlightDialog(View owner, Highlight highlight) {
        super((Frame)owner, "Highlight", false);
        this.highlight = highlight;
        this.panel.setDialog(this);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel scopePanel = new JPanel(new FlowLayout(0));
        scopePanel.add(new JLabel("scope : "));
        this.scopeCombo.setRenderer(new MyListCellRenderer());
        scopePanel.add(this.scopeCombo);
        this.spinner = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 5));
        this.spinner.setToolTipText(jEdit.getProperty((String)"gatchan.highlight.expire.tooltip"));
        JButton ok = new JButton(jEdit.getProperty((String)"common.ok"));
        ok.addActionListener(e -> this.ok());
        JButton cancel = new JButton(jEdit.getProperty((String)"common.cancel"));
        cancel.addActionListener(e -> this.cancel());
        JPanel buttonsPanel = new JPanel();
        BoxLayout layout = new BoxLayout(buttonsPanel, 0);
        buttonsPanel.setLayout(layout);
        buttonsPanel.add(Box.createGlue());
        buttonsPanel.add(ok);
        buttonsPanel.add(Box.createHorizontalStrut(6));
        buttonsPanel.add(cancel);
        buttonsPanel.add(Box.createGlue());
        contentPane.add(this.panel);
        contentPane.add(scopePanel);
        contentPane.add(this.spinner);
        contentPane.add(buttonsPanel);
        this.pack();
        this.setLocationRelativeTo((Component)owner);
    }

    public HighlightDialog(View owner) {
        this(owner, new Highlight());
    }

    public void setString(String s) {
        this.panel.setString(s);
    }

    public void ok() {
        try {
            this.panel.save(this.highlight);
            long expire = ((Number)this.spinner.getValue()).longValue();
            if (expire != 0L) {
                this.highlight.setDuration(expire * 1000L);
            }
            Integer selectedItem = (Integer)this.scopeCombo.getSelectedItem();
            int scope = selectedItem;
            this.highlight.setScope(scope);
            if (scope == 2) {
                Buffer buffer = jEdit.getActiveView().getBuffer();
                this.highlight.setBuffer((JEditBuffer)buffer);
            }
            HighlightManagerTableModel.getManager().addElement(this.highlight);
            this.dispose();
        }
        catch (InvalidHighlightException e) {
            GUIUtilities.error((Component)jEdit.getActiveView(), (String)"gatchan-highlight.errordialog.invalidHighlight", null);
            this.panel.focus();
        }
    }

    public void cancel() {
        this.dispose();
    }

    private static class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            int scope = (Integer)value;
            switch (scope) {
                case 0: {
                    this.setText("permanent");
                    break;
                }
                case 1: {
                    this.setText("session");
                    break;
                }
                case 2: {
                    this.setText("buffer");
                }
            }
            return this;
        }
    }
}

