/*
 * Decompiled with CFR 0.152.
 */
package org.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OptionGroup;
import org.gjt.sp.jedit.OptionPane;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.jedit.options.OptionGroupPane;

public class TabbedOptionDialog
extends EnhancedDialog
implements ActionListener,
ChangeListener {
    JTabbedPane tabs;
    LinkedList<OptionPane> panes;
    Set<OptionPane> shownPanes;
    private JButton ok;
    private JButton cancel;
    private JButton apply;

    public TabbedOptionDialog(Frame frame, String name) {
        super(frame, jEdit.getProperty(name + ".title"), true);
        this.setName(name);
        this.setupTabs();
    }

    public TabbedOptionDialog(Dialog dialog, String name) {
        super(dialog, jEdit.getProperty(name + ".title"), true);
        this.setName(name);
        this.setupTabs();
    }

    public void setSelectedIndex(int index) {
        this.tabs.setSelectedIndex(index);
    }

    void setupTabs() {
        this.panes = new LinkedList();
        this.shownPanes = new HashSet<OptionPane>();
        this.tabs = new JTabbedPane();
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        content.add((Component)this.tabs, "Center");
        Box buttons = new Box(0);
        buttons.setBorder(BorderFactory.createEmptyBorder(12, 0, 0, 0));
        buttons.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(this);
        this.getRootPane().setDefaultButton(this.ok);
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(this);
        this.apply = new JButton(jEdit.getProperty("common.apply"));
        this.apply.addActionListener(this);
        int width = Math.max(Math.max(this.ok.getPreferredSize().width, this.cancel.getPreferredSize().width), this.apply.getPreferredSize().width);
        this.ok.setPreferredSize(new Dimension(width, this.ok.getPreferredSize().height));
        this.cancel.setPreferredSize(new Dimension(width, this.cancel.getPreferredSize().height));
        this.apply.setPreferredSize(new Dimension(width, this.apply.getPreferredSize().height));
        buttons.add(this.ok);
        buttons.add(Box.createHorizontalStrut(6));
        buttons.add(this.cancel);
        buttons.add(Box.createHorizontalStrut(6));
        buttons.add(this.apply);
        content.add((Component)buttons, "South");
        this.setContentPane(content);
        GUIUtilities.loadGeometry(this, this.getName());
        this.tabs.addChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.ok) {
            this.ok();
        } else if (source == this.cancel) {
            this.cancel();
        } else if (source == this.apply) {
            this.ok(false);
        }
    }

    public void addOptionPane(OptionPane pane) {
        this.panes.add(pane);
        JPanel panel = (JPanel)((Object)pane);
        this.tabs.addTab(pane.getName(), panel);
    }

    public void addOptionGroup(OptionGroup group) {
        OptionGroupPane pane = new OptionGroupPane(group);
        pane.addTextListener(new TitleChanger());
        this.addOptionPane(pane);
    }

    @Override
    public void ok() {
        this.ok(true);
    }

    public void ok(boolean dispose) {
        GUIUtilities.saveGeometry(this, this.getName());
        for (OptionPane op : this.panes) {
            if (!this.shownPanes.contains(op)) continue;
            op.save();
        }
        jEdit.propertiesChanged();
        jEdit.saveSettings();
        if (dispose) {
            this.dispose();
        }
    }

    @Override
    public void cancel() {
        GUIUtilities.saveGeometry(this, this.getName());
        this.dispose();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        OptionPane op = (OptionPane)((Object)this.tabs.getSelectedComponent());
        this.shownPanes.add(op);
        jEdit.setIntegerProperty("optional.last.tab", this.tabs.getSelectedIndex());
        this.setTitle(op.getName());
    }

    class TitleChanger
    implements TextListener {
        TitleChanger() {
        }

        @Override
        public void textValueChanged(TextEvent e) {
            TabbedOptionDialog.this.setTitle(e.getSource().toString());
        }
    }
}

