/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.util.Log;

class ScreenLineManager {
    private final JEditBuffer buffer;
    private char[] screenLines;

    ScreenLineManager(JEditBuffer buffer) {
        this.buffer = buffer;
        if (!buffer.isLoading()) {
            this.reset();
        }
    }

    boolean isScreenLineCountValid(int line) {
        if (this.screenLines == null || line < 0 || line >= this.screenLines.length) {
            return false;
        }
        return this.screenLines[line] > '\u0000';
    }

    int getScreenLineCount(int line) {
        assert (this.isScreenLineCountValid(line));
        return this.screenLines[line];
    }

    void setScreenLineCount(int line, int count) {
        assert (count > 0) : "New line count is bogus!";
        if (count > Short.MAX_VALUE) {
            count = Short.MAX_VALUE;
            Log.log(9, this, new Exception("Max screen line count hit!"));
        }
        if (Debug.SCREEN_LINES_DEBUG) {
            Log.log(1, this, "setScreenLineCount(" + line + "," + count + ")");
        }
        if (this.screenLines == null) {
            this.reset();
        }
        this.screenLines[line] = (char)count;
    }

    void invalidateScreenLineCounts() {
        this.invalidateScreenLineCountRange(0, this.buffer.getLineCount());
    }

    private void invalidateScreenLineCount(int physicalLineNo) {
        this.screenLines[physicalLineNo] = '\u0000';
    }

    private void invalidateScreenLineCountRange(int physicalLineStart, int physicalLineEnd) {
        for (int i = physicalLineStart; i < physicalLineEnd; ++i) {
            this.screenLines[i] = '\u0000';
        }
    }

    void reset() {
        this.screenLines = new char[this.buffer.getLineCount()];
    }

    public void contentInserted(int startLine, int numLines) {
        int lineCount = this.buffer.getLineCount();
        if (numLines > 0) {
            int nbLinesBeforeInsert = lineCount - numLines;
            if (this.screenLines.length <= lineCount) {
                int lengthToCopy;
                char[] screenLinesN = new char[lineCount + 1 << 1];
                if (startLine != 0) {
                    System.arraycopy(this.screenLines, 0, screenLinesN, 0, startLine);
                }
                if ((lengthToCopy = nbLinesBeforeInsert - startLine - 1) > 0) {
                    System.arraycopy(this.screenLines, startLine + 1, screenLinesN, startLine + numLines + 1, lengthToCopy);
                }
                this.screenLines = screenLinesN;
            } else {
                int lengthToCopy = nbLinesBeforeInsert - startLine - 1;
                if (lengthToCopy > 0) {
                    System.arraycopy(this.screenLines, startLine + 1, this.screenLines, startLine + numLines + 1, lengthToCopy);
                }
                this.invalidateScreenLineCountRange(startLine, startLine + numLines + 1);
            }
        } else {
            this.invalidateScreenLineCount(startLine);
        }
    }

    public void contentRemoved(int startLine, int numLines) {
        int endLine = startLine + numLines;
        this.invalidateScreenLineCount(startLine);
        if (numLines > 0 && endLine != this.screenLines.length) {
            System.arraycopy(this.screenLines, endLine + 1, this.screenLines, startLine + 1, this.screenLines.length - endLine - 1);
        }
    }
}

