/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import javax.swing.text.Position;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.search.HyperSearchNode;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.ThreadUtilities;

public class HyperSearchResult
implements HyperSearchNode {
    public String path;
    public Buffer buffer;
    public int line;
    public String str;
    public Occur occur;
    public int occurCount;

    @Override
    public Buffer getBuffer(View view) {
        if (this.buffer == null) {
            this.buffer = jEdit.openFile(view, this.path);
        }
        return this.buffer;
    }

    public Selection[] getSelection() {
        if (this.buffer == null) {
            return null;
        }
        Selection[] returnValue = new Selection[this.occurCount];
        Occur o = this.occur;
        int i = 0;
        while (o != null) {
            int start = o.startPos.getOffset();
            int end = o.endPos.getOffset();
            Selection.Range s = new Selection.Range(start, end);
            returnValue[i++] = s;
            o = o.next;
        }
        return returnValue;
    }

    @Override
    public void goTo(EditPane editPane) {
        new GotoDelayed(editPane);
    }

    public String toString() {
        return this.str;
    }

    HyperSearchResult(Buffer buffer, int line) {
        this.path = buffer.getPath();
        if (!buffer.isTemporary()) {
            this.bufferOpened(buffer);
        }
        this.line = line;
        this.str = line + 1 + ": " + buffer.getLineText(line).replace('\t', ' ').trim();
    }

    void bufferOpened(Buffer buffer) {
        this.buffer = buffer;
        Occur o = this.occur;
        while (o != null) {
            o.bufferOpened();
            o = o.next;
        }
    }

    void bufferClosed() {
        this.buffer = null;
        Occur o = this.occur;
        while (o != null) {
            o.bufferClosed();
            o = o.next;
        }
    }

    void addOccur(int start, int end) {
        Occur o = new Occur(start, end);
        o.next = this.occur;
        this.occur = o;
        ++this.occurCount;
    }

    boolean pathEquals(String path) {
        return path.equals(MiscUtilities.resolveSymlinks(this.path));
    }

    public boolean equals(Object compareObj) {
        if (!(compareObj instanceof HyperSearchResult)) {
            return false;
        }
        HyperSearchResult otherResult = (HyperSearchResult)compareObj;
        return this.pathEquals(otherResult.path) && this.line == otherResult.line && this.buffer.equals(otherResult.buffer);
    }

    public class Occur {
        public int start;
        public int end;
        public Position startPos;
        public Position endPos;
        public Occur next;

        Occur(int start, int end) {
            this.start = start;
            this.end = end;
            if (HyperSearchResult.this.buffer != null && !HyperSearchResult.this.buffer.isTemporary()) {
                this.bufferOpened();
            }
        }

        void bufferOpened() {
            this.startPos = HyperSearchResult.this.buffer.createPosition(Math.min(HyperSearchResult.this.buffer.getLength(), this.start));
            this.endPos = HyperSearchResult.this.buffer.createPosition(Math.min(HyperSearchResult.this.buffer.getLength(), this.end));
        }

        void bufferClosed() {
            this.start = this.startPos.getOffset();
            this.end = this.endPos.getOffset();
            this.endPos = null;
            this.startPos = null;
        }
    }

    public class GotoDelayed
    implements Runnable {
        private final EditPane editPane;
        private volatile boolean loadedEventReceived = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private GotoDelayed(EditPane editPane) {
            this.editPane = editPane;
            EditBus.addToBus(this);
            HyperSearchResult.this.buffer = HyperSearchResult.this.getBuffer(editPane.getView());
            if (HyperSearchResult.this.buffer == null) {
                EditBus.removeFromBus(this);
                return;
            }
            editPane.setBuffer(HyperSearchResult.this.buffer);
            GotoDelayed gotoDelayed = this;
            synchronized (gotoDelayed) {
                if (!this.loadedEventReceived && HyperSearchResult.this.buffer.isLoaded()) {
                    this.bufferLoaded();
                }
            }
        }

        @Override
        public void run() {
            Selection[] s = HyperSearchResult.this.getSelection();
            if (s == null) {
                return;
            }
            JEditTextArea textArea = this.editPane.getTextArea();
            if (textArea.isMultipleSelectionEnabled()) {
                textArea.addToSelection(s);
            } else {
                textArea.setSelection(s);
            }
            textArea.moveCaretPosition(HyperSearchResult.this.occur.endPos.getOffset());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bufferLoaded() {
            GotoDelayed gotoDelayed = this;
            synchronized (gotoDelayed) {
                if (!this.loadedEventReceived) {
                    EditBus.removeFromBus(this);
                    this.loadedEventReceived = true;
                    ThreadUtilities.runInDispatchThread(this);
                }
            }
        }

        @EditBus.EBHandler
        public void handleBufferUpdate(BufferUpdate msg) {
            if (msg.getWhat() == BufferUpdate.LOADED && msg.getBuffer() == HyperSearchResult.this.buffer) {
                this.bufferLoaded();
            }
        }
    }
}

