/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginList;
import org.gjt.sp.util.Log;

class CachePluginList {
    public static final long MILLISECONDS_PER_MINUTE = 60000L;
    private final String id;

    CachePluginList(String id) {
        this.id = id;
    }

    Optional<String> getPluginList() {
        if (!this.id.equals(jEdit.getProperty("plugin-manager.mirror.cached-id"))) {
            return Optional.empty();
        }
        return this.getCacheFile().filter(Files::isReadable).filter(CachePluginList::isAcceptableCache).flatMap(this::readCache);
    }

    void saveCache(@Nullable CharSequence xml) {
        if (xml == null) {
            return;
        }
        this.getCacheFile().ifPresent(path -> {
            try {
                Files.writeString(path, xml, new OpenOption[0]);
            }
            catch (IOException e) {
                Log.log(9, this, "Error saving cache data", e);
            }
        });
    }

    private Optional<Path> getCacheFile() {
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory == null) {
            return Optional.empty();
        }
        return Optional.of(Path.of(settingsDirectory, "pluginMgr-Cached.xml"));
    }

    private static boolean isAcceptableCache(Path path) {
        try {
            FileTime lastModifiedTime = Files.getLastModifiedTime(path, new LinkOption[0]);
            Instant lastModified = lastModifiedTime.toInstant();
            long interval = (long)jEdit.getIntegerProperty("plugin-manager.list-cache.minutes", 5) * 60000L;
            Instant lowerTimeLimit = Instant.now().minusMillis(interval);
            return lastModified.isAfter(lowerTimeLimit);
        }
        catch (IOException e) {
            Log.log(9, PluginList.class, "Unable to get last modified time for " + String.valueOf(path), e);
            return false;
        }
    }

    void deleteCache() {
        this.getCacheFile().ifPresent(path -> {
            Log.log(1, PluginList.class, "Unable to read plugin list, deleting cached file and try again");
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                Log.log(7, PluginList.class, "Error while deleting cache file " + String.valueOf(path), e);
            }
        });
    }

    private Optional<String> readCache(Path path) {
        try {
            return Optional.of(Files.readString(path));
        }
        catch (IOException e) {
            Log.log(9, PluginList.class, "Unable to read stream", e);
            this.deleteCache();
            return Optional.empty();
        }
    }
}

