/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.ToolBarEditDialog;
import org.gjt.sp.util.GenericGUIUtilities;

public class ToolBarOptionPane
extends AbstractOptionPane {
    private JCheckBox showToolbar;
    private DefaultListModel<Button> listModel;
    private JList<Button> list;
    private RolloverButton add;
    private RolloverButton remove;
    private RolloverButton moveUp;
    private RolloverButton moveDown;
    private RolloverButton edit;
    private RolloverButton reset;
    private DefaultComboBoxModel<IconListEntry> iconList;

    public ToolBarOptionPane() {
        super("toolbar");
    }

    @Override
    protected void _init() {
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridLayout(2, 1));
        this.showToolbar = new JCheckBox(jEdit.getProperty("options.toolbar.showToolbar"));
        this.showToolbar.setSelected(jEdit.getBooleanProperty("view.showToolbar"));
        panel.add(this.showToolbar);
        panel.add(new JLabel(jEdit.getProperty("options.toolbar.caption")));
        this.add("North", panel);
        this.listModel = new DefaultListModel();
        this.reloadButtonList(jEdit.getProperty("view.toolbar"));
        this.list = new JList<Button>(this.listModel);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(e -> this.updateButtons());
        this.list.setCellRenderer(new ButtonCellRenderer());
        this.add("Center", new JScrollPane(this.list));
        JPanel buttons = new JPanel();
        buttons.setBorder(new EmptyBorder(3, 0, 0, 0));
        buttons.setLayout(new BoxLayout(buttons, 0));
        ActionHandler actionHandler = new ActionHandler();
        this.add = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.toolbar.add.icon")));
        this.add.setToolTipText(jEdit.getProperty("options.toolbar.add"));
        this.add.addActionListener(actionHandler);
        buttons.add(this.add);
        buttons.add(Box.createHorizontalStrut(6));
        this.remove = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.toolbar.remove.icon")));
        this.remove.setToolTipText(jEdit.getProperty("options.toolbar.remove"));
        this.remove.addActionListener(actionHandler);
        buttons.add(this.remove);
        buttons.add(Box.createHorizontalStrut(6));
        this.moveUp = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.toolbar.moveUp.icon")));
        this.moveUp.setToolTipText(jEdit.getProperty("options.toolbar.moveUp"));
        this.moveUp.addActionListener(e -> this.moveItem(-1));
        buttons.add(this.moveUp);
        buttons.add(Box.createHorizontalStrut(6));
        this.moveDown = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.toolbar.moveDown.icon")));
        this.moveDown.setToolTipText(jEdit.getProperty("options.toolbar.moveDown"));
        this.moveDown.addActionListener(e -> this.moveItem(1));
        buttons.add(this.moveDown);
        buttons.add(Box.createHorizontalStrut(6));
        this.edit = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.toolbar.edit.icon")));
        this.edit.setToolTipText(jEdit.getProperty("options.toolbar.edit"));
        this.edit.addActionListener(actionHandler);
        buttons.add(this.edit);
        buttons.add(Box.createGlue());
        this.reset = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.toolbar.reset.icon")));
        this.reset.setToolTipText(jEdit.getProperty("options.toolbar.reset"));
        this.reset.addActionListener(actionHandler);
        buttons.add(this.reset);
        this.updateButtons();
        this.add("South", buttons);
        this.iconList = new DefaultComboBoxModel();
        StringTokenizer st = new StringTokenizer(jEdit.getProperty("icons"));
        while (st.hasMoreElements()) {
            String icon = st.nextToken();
            this.iconList.addElement(new IconListEntry(GUIUtilities.loadIcon(icon), icon));
        }
    }

    @Override
    protected void _save() {
        jEdit.setBooleanProperty("view.showToolbar", this.showToolbar.isSelected());
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            if (i != 0) {
                buf.append(' ');
            }
            Button button = this.listModel.elementAt(i);
            buf.append(button.actionName);
            jEdit.setProperty(button.actionName + ".icon", button.iconName);
        }
        jEdit.setProperty("view.toolbar", buf.toString());
    }

    private void updateButtons() {
        int index = this.list.getSelectedIndex();
        this.remove.setEnabled(index != -1 && this.listModel.getSize() != 0);
        this.moveUp.setEnabled(index > 0);
        this.moveDown.setEnabled(index != -1 && index != this.listModel.getSize() - 1);
        this.edit.setEnabled(index != -1);
    }

    private void reloadButtonList(String toolbar) {
        StringTokenizer st = new StringTokenizer(toolbar);
        this.listModel.clear();
        while (st.hasMoreTokens()) {
            Icon icon;
            String label;
            String actionName = st.nextToken();
            if ("-".equals(actionName)) {
                this.listModel.addElement(new Button("-", null, null, "-"));
                continue;
            }
            EditAction action = jEdit.getAction(actionName);
            if (action == null || (label = action.getLabel()) == null) continue;
            String iconName = jEdit.getProperty(actionName + ".icon");
            if (iconName == null) {
                icon = GUIUtilities.loadIcon(jEdit.getProperty("broken-image.icon"));
            } else {
                icon = GUIUtilities.loadIcon(iconName);
                if (icon == null) {
                    icon = GUIUtilities.loadIcon(jEdit.getProperty("broken-image.icon"));
                }
            }
            this.listModel.addElement(new Button(actionName, iconName, icon, label));
        }
    }

    private void moveItem(int move) {
        int index = this.list.getSelectedIndex();
        Button selected = this.list.getSelectedValue();
        this.listModel.removeElementAt(index);
        this.listModel.insertElementAt(selected, index + move);
        this.list.setSelectedIndex(index + move);
        this.list.ensureIndexIsVisible(index + move);
    }

    static class ButtonCellRenderer
    extends DefaultListCellRenderer {
        ButtonCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Button button = (Button)value;
            this.setIcon(button.icon);
            return this;
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String dialogType;
            int result;
            Object source = evt.getSource();
            if (source == ToolBarOptionPane.this.add) {
                ToolBarEditDialog dialog = new ToolBarEditDialog(ToolBarOptionPane.this, ToolBarOptionPane.this.iconList, null);
                Button selection = dialog.getSelection();
                if (selection == null) {
                    return;
                }
                int index = ToolBarOptionPane.this.list.getSelectedIndex();
                index = index == -1 ? ToolBarOptionPane.this.listModel.getSize() : ++index;
                ToolBarOptionPane.this.listModel.insertElementAt(selection, index);
                ToolBarOptionPane.this.list.setSelectedIndex(index);
                ToolBarOptionPane.this.list.ensureIndexIsVisible(index);
            } else if (source == ToolBarOptionPane.this.remove) {
                int index = ToolBarOptionPane.this.list.getSelectedIndex();
                ToolBarOptionPane.this.listModel.removeElementAt(index);
                if (ToolBarOptionPane.this.listModel.getSize() != 0) {
                    if (ToolBarOptionPane.this.listModel.getSize() == index) {
                        ToolBarOptionPane.this.list.setSelectedIndex(index - 1);
                    } else {
                        ToolBarOptionPane.this.list.setSelectedIndex(index);
                    }
                }
                ToolBarOptionPane.this.updateButtons();
            } else if (source == ToolBarOptionPane.this.edit) {
                ToolBarEditDialog dialog = new ToolBarEditDialog(ToolBarOptionPane.this, ToolBarOptionPane.this.iconList, ToolBarOptionPane.this.list.getSelectedValue());
                Button selection = dialog.getSelection();
                if (selection == null) {
                    return;
                }
                int index = ToolBarOptionPane.this.list.getSelectedIndex();
                ToolBarOptionPane.this.listModel.setElementAt(selection, index);
                ToolBarOptionPane.this.list.setSelectedIndex(index);
                ToolBarOptionPane.this.list.ensureIndexIsVisible(index);
            } else if (source == ToolBarOptionPane.this.reset && (result = GUIUtilities.confirm(ToolBarOptionPane.this.list, dialogType = "options.toolbar.reset.dialog", null, 0, 2)) == 0) {
                String orgToolbar = jEdit.getProperty("view.toolbar");
                jEdit.resetProperty("view.toolbar");
                String defaultToolbar = jEdit.getProperty("view.toolbar");
                jEdit.setProperty("view.toolbar", orgToolbar);
                ToolBarOptionPane.this.reloadButtonList(defaultToolbar);
                ToolBarOptionPane.this.list.setSelectedIndex(0);
                ToolBarOptionPane.this.list.ensureIndexIsVisible(0);
                ToolBarOptionPane.this.updateButtons();
            }
        }
    }

    static class IconListEntry {
        Icon icon;
        String name;

        IconListEntry(Icon icon, String name) {
            this.icon = icon;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    static class Button {
        final String actionName;
        final String iconName;
        private final Icon icon;
        final String label;

        Button(String actionName, String iconName, Icon icon, String label) {
            this.actionName = actionName;
            this.iconName = iconName;
            this.icon = icon;
            this.label = GenericGUIUtilities.prettifyMenuLabel(label);
        }

        public String toString() {
            return this.label;
        }

        public boolean equals(Object o) {
            if (o instanceof Button) {
                return ((Button)o).actionName.equals(this.actionName);
            }
            return false;
        }

        public int hashCode() {
            return this.actionName.hashCode();
        }
    }

    static class IconCellRenderer
    extends DefaultListCellRenderer {
        IconCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            IconListEntry icon = (IconListEntry)value;
            this.setIcon(icon.icon);
            return this;
        }
    }
}

