/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.msg;

import java.io.File;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;

public class PluginUpdate
extends EBMessage {
    public static final Object LOADED = "LOADED";
    public static final Object ACTIVATED = "ACTIVATED";
    public static final Object DEACTIVATED = "DEACTIVATED";
    public static final Object UNLOADED = "UNLOADED";
    public static final Object REMOVED = "REMOVED";
    private PluginJAR jar;
    private File file;
    private final Object what;
    private final boolean exit;
    private String version;

    public PluginUpdate(@Nonnull PluginJAR jar, @Nonnull Object what, boolean exit) {
        super(jar);
        Objects.requireNonNull(jar);
        Objects.requireNonNull(what);
        this.jar = jar;
        EditPlugin plugin = jar.getPlugin();
        if (plugin != null) {
            String clazz = plugin.getClassName();
            this.version = jEdit.getProperty("plugin." + clazz + ".version");
        }
        this.what = what;
        this.exit = exit;
    }

    public PluginUpdate(File file, @Nonnull Object what, boolean exit) {
        super(file);
        Objects.requireNonNull(what);
        this.file = file;
        this.what = what;
        this.exit = exit;
    }

    public Object getWhat() {
        return this.what;
    }

    public boolean isExiting() {
        return this.exit;
    }

    @Nullable
    public PluginJAR getPluginJAR() {
        return this.jar;
    }

    public File getFile() {
        return this.file;
    }

    public String getPluginVersion() {
        return this.version;
    }

    @Override
    public String paramString() {
        return "what=" + String.valueOf(this.what) + ",exit=" + this.exit + ",version=" + this.version + "," + super.paramString();
    }
}

