/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.DynamicMenuProvider;
import org.gjt.sp.jedit.menu.EnhancedMenuItem;
import org.gjt.sp.jedit.menu.MenuItemTextComparator;

public class MacrosProvider
implements DynamicMenuProvider {
    @Override
    public boolean updateEveryTime() {
        return false;
    }

    @Override
    public void update(JMenu menu) {
        Vector macroList = Macros.getMacroHierarchy();
        int count = menu.getMenuComponentCount();
        this.createMacrosMenu(menu, macroList, 0);
        if (count == menu.getMenuComponentCount()) {
            JMenuItem mi = new JMenuItem(jEdit.getProperty("no-macros.label"));
            mi.setEnabled(false);
            menu.add(mi);
        }
    }

    private void createMacrosMenu(JMenu menu, List list, int start) {
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        int maxItems = jEdit.getIntegerProperty("menu.spillover", 20);
        JMenu subMenu = null;
        for (int i = start; i < list.size(); ++i) {
            if (i != start && i % maxItems == 0) {
                subMenu = new JMenu(jEdit.getProperty("common.more"));
                this.createMacrosMenu(subMenu, list, i);
                break;
            }
            Object obj = list.get(i);
            if (obj instanceof String) {
                menuItems.add(new EnhancedMenuItem(jEdit.getProperty(String.valueOf(obj) + ".label"), (String)obj, jEdit.getActionContext()));
                continue;
            }
            if (!(obj instanceof List)) continue;
            List subList = (List)obj;
            String name = (String)subList.get(0);
            JMenu submenu = new JMenu(jEdit.getProperty("macros.folder." + name + ".label", name));
            this.createMacrosMenu(submenu, subList, 1);
            if (submenu.getMenuComponentCount() == 0) continue;
            menuItems.add(submenu);
        }
        menuItems.sort(new MenuItemTextComparator());
        if (subMenu != null) {
            menuItems.add(subMenu);
        }
        for (JMenuItem menuItem : menuItems) {
            menu.add(menuItem);
        }
    }
}

