/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.indent;

import java.util.Collection;
import java.util.List;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.indent.BracketIndentRule;
import org.gjt.sp.jedit.indent.IndentAction;

public class OpenBracketIndentRule
extends BracketIndentRule {
    private boolean aligned;

    public OpenBracketIndentRule(char openBracket, boolean aligned) {
        super(openBracket, TextUtilities.getComplementaryBracket(openBracket, null));
        this.aligned = aligned;
    }

    @Override
    public void apply(JEditBuffer buffer, int thisLineIndex, int prevLineIndex, int prevPrevLineIndex, List<IndentAction> indentActions) {
        int prevOpenBracketCount = this.getOpenBracketCount(buffer, prevLineIndex);
        if (prevOpenBracketCount != 0) {
            OpenBracketIndentRule.handleCollapse(indentActions, true);
            boolean multiple = buffer.getBooleanProperty("multipleBracketIndent");
            IndentAction.Increase increase = new IndentAction.Increase(multiple ? prevOpenBracketCount : 1);
            indentActions.add(increase);
        } else if (this.getOpenBracketCount(buffer, thisLineIndex) != 0) {
            OpenBracketIndentRule.handleCollapse(indentActions, false);
        }
    }

    private int getOpenBracketCount(JEditBuffer buffer, int line) {
        if (line == -1) {
            return 0;
        }
        return this.getBrackets((JEditBuffer)buffer, (int)line).openCount;
    }

    private static void handleCollapse(Collection<IndentAction> indentActions, boolean delPrevPrevCollapse) {
        if (indentActions.contains(IndentAction.PrevCollapse)) {
            indentActions.clear();
            return;
        }
        if (delPrevPrevCollapse && indentActions.contains(IndentAction.PrevPrevCollapse)) {
            indentActions.clear();
        }
    }
}

