/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.help;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.help.HelpTOCLoader;
import org.gjt.sp.jedit.help.HelpViewerInterface;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.EnhancedTreeCellRenderer;
import org.gjt.sp.util.ThreadUtilities;

public class HelpTOCPanel
extends JPanel {
    private final HelpViewerInterface helpViewer;
    private DefaultTreeModel tocModel;
    private final JTree toc;
    private final Map<String, DefaultMutableTreeNode> nodes;

    public HelpTOCPanel(HelpViewerInterface helpViewer) {
        super(new BorderLayout());
        this.helpViewer = helpViewer;
        this.nodes = new HashMap<String, DefaultMutableTreeNode>();
        this.toc = new TOCTree();
        if (!OperatingSystem.isMacOSLF()) {
            this.toc.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.toc.setRowHeight(0);
        this.toc.setCellRenderer(new TOCCellRenderer());
        this.toc.setEditable(false);
        this.toc.setShowsRootHandles(true);
        this.add("Center", new JScrollPane(this.toc));
        this.load();
    }

    public void selectNode(String shortURL) {
        if (this.tocModel == null) {
            return;
        }
        DefaultMutableTreeNode node = this.nodes.get(shortURL);
        if (node == null) {
            return;
        }
        EventQueue.invokeLater(() -> {
            TreePath path = new TreePath(this.tocModel.getPathToRoot(node));
            this.toc.expandPath(path);
            this.toc.setSelectionPath(path);
            this.toc.scrollPathToVisible(path);
        });
    }

    public void load() {
        DefaultTreeModel empty = new DefaultTreeModel(new DefaultMutableTreeNode(jEdit.getProperty("helpviewer.toc.loading")));
        this.toc.setModel(empty);
        this.toc.setRootVisible(true);
        ThreadUtilities.runInBackground(() -> {
            DefaultMutableTreeNode tocRoot = new HelpTOCLoader(this.nodes, this.helpViewer.getBaseURL()).createTOC();
            this.tocModel = new DefaultTreeModel(tocRoot);
            this.toc.setModel(this.tocModel);
            this.toc.setRootVisible(false);
            for (int i = 0; i < tocRoot.getChildCount(); ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tocRoot.getChildAt(i);
                this.toc.expandPath(new TreePath(node.getPath()));
            }
            if (this.helpViewer.getShortURL() != null) {
                this.selectNode(this.helpViewer.getShortURL());
            }
        });
    }

    class TOCTree
    extends JTree {
        TOCTree() {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.selectionModel.setSelectionMode(1);
        }

        @Override
        public final String getToolTipText(MouseEvent evt) {
            Rectangle cellRect;
            TreePath path = this.getPathForLocation(evt.getX(), evt.getY());
            if (path != null && (cellRect = this.getPathBounds(path)) != null && !this.cellRectIsVisible(cellRect)) {
                return path.getLastPathComponent().toString();
            }
            return null;
        }

        @Override
        public void processKeyEvent(KeyEvent evt) {
            if (401 == evt.getID() && 10 == evt.getKeyCode()) {
                TreePath path = this.getSelectionPath();
                this.expandOrGotoPath(path);
                evt.consume();
            } else {
                super.processKeyEvent(evt);
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent evt) {
            switch (evt.getID()) {
                case 500: {
                    TreePath path = this.getPathForLocation(evt.getX(), evt.getY());
                    this.expandOrGotoPath(path);
                    super.processMouseEvent(evt);
                    break;
                }
                default: {
                    super.processMouseEvent(evt);
                }
            }
        }

        private boolean cellRectIsVisible(Rectangle cellRect) {
            Rectangle vr = this.getVisibleRect();
            return vr.contains(cellRect.x, cellRect.y) && vr.contains(cellRect.x + cellRect.width, cellRect.y + cellRect.height);
        }

        private void expandOrGotoPath(TreePath path) {
            if (path != null) {
                Object obj;
                if (!this.isPathSelected(path)) {
                    this.setSelectionPath(path);
                }
                if ((obj = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof HelpTOCLoader.HelpNode) {
                    HelpTOCLoader.HelpNode node = (HelpTOCLoader.HelpNode)obj;
                    HelpTOCPanel.this.helpViewer.gotoURL(node.href, true, 0);
                } else {
                    this.expandPath(path);
                }
            }
        }
    }

    static class TOCCellRenderer
    extends EnhancedTreeCellRenderer {
        EmptyBorder border = new EmptyBorder(1, 0, 1, 1);

        TOCCellRenderer() {
        }

        @Override
        protected TreeCellRenderer newInstance() {
            return new TOCCellRenderer();
        }

        @Override
        protected void configureTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
            this.setIcon(leaf ? FileCellRenderer.fileIcon : (expanded ? FileCellRenderer.openDirIcon : FileCellRenderer.dirIcon));
            this.setBorder(this.border);
        }
    }
}

