/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.event.MouseEvent;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.AbstractLabelWidget;
import org.gjt.sp.jedit.gui.statusbar.StatusBarEventType;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;

public class IndentWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        IndentWidget indent = new IndentWidget(view);
        return indent;
    }

    private static class IndentWidget
    extends AbstractLabelWidget {
        IndentWidget(View view) {
            super(view);
        }

        @Override
        protected void singleClick(MouseEvent e) {
            Buffer buffer = this.view.getBuffer();
            buffer.toggleAutoIndent(this.view);
            this.update();
        }

        @Override
        public void update() {
            Buffer buffer = this.view.getBuffer();
            String indent = buffer.getStringProperty("autoIndent");
            this.label.setToolTipText(jEdit.getProperty("view.status.indent-tooltip"));
            if ("full".equals(indent)) {
                this.label.setEnabled(true);
                this.label.setText("F");
            } else if ("simple".equals(indent)) {
                this.label.setEnabled(true);
                this.label.setText("S");
            } else {
                this.label.setEnabled(false);
                this.label.setText("n");
            }
            this.label.setText(indent);
        }

        @Override
        public boolean test(StatusBarEventType statusBarEventType) {
            return statusBarEventType == StatusBarEventType.Buffer;
        }
    }
}

