/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.gui.BufferOptions;
import org.gjt.sp.jedit.gui.DialogChooser;
import org.gjt.sp.jedit.gui.statusbar.AbstractLabelWidget;
import org.gjt.sp.jedit.gui.statusbar.StatusBarEventType;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.util.StandardUtilities;

public class FoldWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        return new FoldWidget(view);
    }

    private static class FoldWidget
    extends AbstractLabelWidget {
        FoldWidget(View view) {
            super(view);
            this.label.setToolTipText(jEdit.getProperty("view.status.fold-tooltip"));
        }

        @Override
        protected void singleClick(MouseEvent e) {
            Buffer buffer = this.view.getBuffer();
            String currentFoldingMode = buffer.getStringProperty("folding");
            DialogChooser.openListChooserWindow(this.label, currentFoldingMode, listSelectionEvent -> EventQueue.invokeLater(() -> {
                JList list = (JList)StandardUtilities.castUnchecked(listSelectionEvent.getSource());
                String selectedValue = (String)list.getSelectedValue();
                buffer.setStringProperty("folding", selectedValue);
                buffer.propertiesChanged();
                EditBus.send(new BufferUpdate(buffer, null, BufferUpdate.PROPERTIES_CHANGED));
            }), FoldHandler.getFoldModes());
        }

        @Override
        protected void rightClick(MouseEvent e) {
            new BufferOptions(this.view, this.view.getBuffer());
        }

        @Override
        public void update() {
            Buffer buffer = this.view.getBuffer();
            if (buffer.isLoaded()) {
                this.label.setText("Fold: " + String.valueOf(this.view.getBuffer().getProperty("folding")));
            }
        }

        @Override
        public boolean test(StatusBarEventType statusBarEventType) {
            return statusBarEventType == StatusBarEventType.Buffer;
        }
    }
}

