/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.annotation.Nullable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatsBarWidgetPanel;
import org.gjt.sp.jedit.gui.statusbar.StatusBarEventType;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.TaskListener;
import org.gjt.sp.util.TaskManager;

public class StatusBar
extends JPanel {
    private final TaskHandler taskHandler;
    private final View view;
    private final JPanel panel;
    private final StatsBarWidgetPanel leadingWidgetsBox;
    private final StatsBarWidgetPanel trailingWidgetsBox;
    private Component messageComp;
    private final JLabel message;
    @Nullable
    private Timer tempTimer;
    private boolean currentMessageIsIO;

    public StatusBar(View view) {
        super(new BorderLayout());
        this.setName("StatusBar");
        this.setBorder(new CompoundBorder(new EmptyBorder(4, 0, 0, OperatingSystem.isMacOS() ? 18 : 0), UIManager.getBorder("TextField.border")));
        this.view = view;
        this.leadingWidgetsBox = new StatsBarWidgetPanel("view.status-leading", view);
        this.trailingWidgetsBox = new StatsBarWidgetPanel("view.status", view);
        this.panel = new JPanel(new BorderLayout());
        this.panel.add("West", this.leadingWidgetsBox);
        this.panel.add("East", this.trailingWidgetsBox);
        this.add("Center", this.panel);
        this.message = new JLabel(" ");
        this.setMessageComponent(this.message);
        this.taskHandler = new TaskHandler();
    }

    public void propertiesChanged() {
        Color fg = jEdit.getColorProperty("view.status.foreground");
        Color bg = jEdit.getColorProperty("view.status.background");
        this.panel.setBackground(bg);
        this.panel.setForeground(fg);
        this.message.setBackground(bg);
        this.message.setForeground(fg);
        this.leadingWidgetsBox.propertiesChanged();
        this.trailingWidgetsBox.propertiesChanged();
        this.updateBufferStatus();
        this.updateMiscStatus();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        TaskManager.instance.addTaskListener(this.taskHandler);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        TaskManager.instance.removeTaskListener(this.taskHandler);
    }

    public String getMessage() {
        return this.message.getText();
    }

    public void setMessageAndClear(String message) {
        this.setMessage(message);
        this.tempTimer = new Timer(0, evt -> {
            if (this.isShowing()) {
                this.setMessage(null);
            }
        });
        this.tempTimer.setInitialDelay(10000);
        this.tempTimer.setRepeats(false);
        this.tempTimer.start();
    }

    public void setMessage(String message) {
        if (this.tempTimer != null) {
            this.tempTimer.stop();
            this.tempTimer = null;
        }
        this.setMessageComponent(this.message);
        if (message == null) {
            if (this.view.getMacroRecorder() != null) {
                this.message.setText(jEdit.getProperty("view.status.recording"));
            } else {
                this.message.setText(" ");
            }
        } else {
            Exception exn = new Exception();
            if (!exn.getStackTrace()[1].getClassName().startsWith("sidekick.")) {
                this.message.setText(message);
            }
        }
    }

    public void setMessageComponent(Component comp) {
        this.currentMessageIsIO = false;
        if (comp == null || this.messageComp == comp) {
            return;
        }
        this.messageComp = comp;
        this.panel.add("Center", this.messageComp);
    }

    public void updateCaretStatus() {
        this.updateEvent(StatusBarEventType.Caret);
    }

    public void updateBufferStatus() {
        this.updateEvent(StatusBarEventType.Buffer);
    }

    public void updateMiscStatus() {
        this.updateEvent(StatusBarEventType.Misc);
    }

    public void updateEvent(StatusBarEventType statusBarEventType) {
        this.leadingWidgetsBox.updateEvent(statusBarEventType);
        this.trailingWidgetsBox.updateEvent(statusBarEventType);
    }

    private class TaskHandler
    implements TaskListener {
        private final Runnable statusLineIo = new Runnable(){

            @Override
            public void run() {
                if (!StatusBar.this.currentMessageIsIO && StatusBar.this.message != null && !StatusBar.this.message.getText().trim().isEmpty()) {
                    return;
                }
                int requestCount = TaskManager.instance.countIoTasks();
                if (requestCount == 0) {
                    StatusBar.this.setMessageAndClear(jEdit.getProperty("view.status.io.done"));
                    StatusBar.this.currentMessageIsIO = true;
                } else if (requestCount == 1) {
                    StatusBar.this.setMessage(jEdit.getProperty("view.status.io-1"));
                    StatusBar.this.currentMessageIsIO = true;
                } else {
                    Object[] args = new Object[]{requestCount};
                    StatusBar.this.setMessage(jEdit.getProperty("view.status.io", args));
                    StatusBar.this.currentMessageIsIO = true;
                }
            }
        };

        private TaskHandler() {
        }

        @Override
        public void waiting(Task task) {
            SwingUtilities.invokeLater(this.statusLineIo);
        }

        @Override
        public void done(Task task) {
            SwingUtilities.invokeLater(this.statusLineIo);
        }
    }
}

