/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.gui.MutableListModel;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.GenericGUIUtilities;

public class PasteFromListDialog
extends EnhancedDialog {
    private final View view;
    private final MutableListModel<String> listModel;
    private final JList<String> clips;
    private final JTextArea clipText;
    private final JButton insert;

    public PasteFromListDialog(String name, View view, MutableListModel<String> model) {
        super(view, jEdit.getProperty(name + ".title"), true);
        this.view = view;
        this.listModel = model;
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setContentPane(content);
        JPanel center = new JPanel(new GridLayout(2, 1, 2, 12));
        int maxItemLength = jEdit.getIntegerProperty("paste-from-list.max-item-length", 1000);
        this.clips = new JList<String>(model);
        this.clips.setCellRenderer(new Renderer(maxItemLength));
        this.clips.setVisibleRowCount(12);
        this.clips.addMouseListener(new MouseHandler());
        this.clips.addListSelectionListener(e -> {
            this.showClipText();
            this.updateButtons();
        });
        this.insert = new JButton(jEdit.getProperty("common.insert"));
        JButton cancel = new JButton(jEdit.getProperty("common.cancel"));
        JLabel label = new JLabel(jEdit.getProperty(name + ".caption"));
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        content.add("North", label);
        JScrollPane scroller = new JScrollPane(this.clips);
        scroller.setPreferredSize(new Dimension(500, 150));
        center.add(scroller);
        this.clipText = new JTextArea();
        this.clipText.setEditable(false);
        scroller = new JScrollPane(this.clipText);
        scroller.setPreferredSize(new Dimension(500, 150));
        center.add(scroller);
        content.add((Component)center, "Center");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(new EmptyBorder(17, 0, 0, 0));
        panel.add(Box.createGlue());
        panel.add(this.insert);
        panel.add(Box.createHorizontalStrut(6));
        panel.add(cancel);
        GenericGUIUtilities.makeSameSize(this.insert, cancel);
        content.add((Component)panel, "South");
        if (model.getSize() >= 1) {
            this.clips.setSelectedIndex(0);
        }
        this.updateButtons();
        this.getRootPane().setDefaultButton(this.insert);
        this.insert.addActionListener(e -> this.ok());
        cancel.addActionListener(e -> this.cancel());
        GenericGUIUtilities.requestFocus(this, this.clips);
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    @Override
    public void ok() {
        List<String> selected = this.clips.getSelectedValuesList();
        if (selected == null || selected.isEmpty()) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        String text = this.getSelectedClipText();
        for (String sel : selected) {
            this.listModel.removeElement(sel);
            this.listModel.insertElementAt(sel, 0);
        }
        this.view.getTextArea().setSelectedText(text);
        this.cleanup();
    }

    @Override
    public void cancel() {
        this.cleanup();
    }

    private void cleanup() {
        String[] nothing = new String[]{};
        this.clips.setListData((String[])nothing);
        this.dispose();
    }

    private String getSelectedClipText() {
        List<String> selected = this.clips.getSelectedValuesList();
        if (selected == null || selected.isEmpty()) {
            return "";
        }
        if (selected.size() == 1) {
            return selected.get(0);
        }
        StringBuilder clip = new StringBuilder();
        for (int i = 0; i < selected.size(); ++i) {
            if (i != 0) {
                clip.append('\n');
            }
            clip.append(selected.get(i));
        }
        return clip.toString();
    }

    private void updateButtons() {
        int selected = this.clips.getSelectedIndex();
        this.insert.setEnabled(selected != -1);
    }

    private void showClipText() {
        List<String> selected = this.clips.getSelectedValuesList();
        if (selected == null || selected.isEmpty()) {
            this.clipText.setText("");
        } else {
            String text = this.getSelectedClipText();
            int maxPreviewLength = jEdit.getIntegerProperty("paste-from-list.max-preview-length", 100000);
            if (text.length() > maxPreviewLength) {
                this.clipText.setText(text.substring(0, maxPreviewLength) + "<" + (text.length() - maxPreviewLength) + " more bytes>");
            } else {
                this.clipText.setText(text);
            }
        }
        this.clipText.setCaretPosition(0);
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private final int maxItemLength;

        Renderer(int maxItemLength) {
            this.maxItemLength = maxItemLength;
        }

        String shorten(String item) {
            StringBuilder buf = new StringBuilder();
            if (item.toLowerCase().startsWith("<html>")) {
                buf.append(' ');
            }
            boolean ws = true;
            for (int i = 0; i < item.length(); ++i) {
                if (buf.length() == this.maxItemLength) {
                    buf.append("...");
                    break;
                }
                char ch = item.charAt(i);
                if (Character.isWhitespace(ch)) {
                    if (ws) continue;
                    buf.append(' ');
                    ws = true;
                    continue;
                }
                ws = false;
                buf.append(ch);
            }
            if (buf.length() == 0) {
                return jEdit.getProperty("paste-from-list.whitespace");
            }
            return buf.toString();
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.setText(this.shorten(value.toString()));
            return this;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() == 2) {
                PasteFromListDialog.this.ok();
            }
        }
    }
}

