/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.DockableWindowFactory;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.DockableWindowUpdate;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.Log;
import org.jedit.keymap.Keymap;
import org.jedit.keymap.KeymapManager;

public abstract class DockableWindowManager
extends JPanel {
    public static final String FLOATING = "floating";
    public static final String TOP = "top";
    public static final String LEFT = "left";
    public static final String BOTTOM = "bottom";
    public static final String RIGHT = "right";
    private final Map<PluginJAR, Set<String>> plugins = new HashMap<PluginJAR, Set<String>>();
    private final Map<String, String> positions = new HashMap<String, String>();
    protected View view;
    protected DockableWindowFactory factory;
    protected Map<String, JComponent> windows = new HashMap<String, JComponent>();
    private boolean tBottom;
    private boolean tTop;
    private boolean tLeft;
    private boolean tRight;
    private boolean closeToggle = true;
    private static final String ALTERNATE_LAYOUT_PROP = "view.docking.alternateLayout";
    private boolean alternateLayout;

    public DockableWindowManager(View view, DockableWindowFactory instance, View.ViewConfig config) {
        this.view = view;
        this.factory = instance;
        this.alternateLayout = jEdit.getBooleanProperty(ALTERNATE_LAYOUT_PROP);
    }

    public abstract void setMainPanel(JPanel var1);

    public abstract void showDockableWindow(String var1);

    public abstract void hideDockableWindow(String var1);

    public abstract void disposeDockableWindow(String var1);

    public abstract JComponent floatDockableWindow(String var1);

    public abstract boolean isDockableWindowDocked(String var1);

    public abstract boolean isDockableWindowVisible(String var1);

    public abstract void closeCurrentArea();

    public abstract DockingLayout getDockingLayout(View.ViewConfig var1);

    public abstract DockingArea getLeftDockingArea();

    public abstract DockingArea getRightDockingArea();

    public abstract DockingArea getTopDockingArea();

    public abstract DockingArea getBottomDockingArea();

    public void init() {
        EditBus.addToBus(this);
        Iterator<DockableWindowFactory.Window> entries = this.factory.getDockableWindowIterator();
        while (entries.hasNext()) {
            DockableWindowFactory.Window window = entries.next();
            String dockable = window.name;
            this.positions.put(dockable, this.getDockablePosition(dockable));
            this.addPluginDockable(window.plugin, dockable);
        }
    }

    public void close() {
        EditBus.removeFromBus(this);
    }

    public void applyDockingLayout(DockingLayout docking) {
        for (Map.Entry<String, String> entry : this.positions.entrySet()) {
            String dockable = entry.getKey();
            String position = entry.getValue();
            if (position.equals(FLOATING)) continue;
            this.showDockableWindow(dockable);
        }
    }

    public void addDockableWindow(String name) {
        this.showDockableWindow(name);
    }

    public void removeDockableWindow(String name) {
        this.hideDockableWindow(name);
    }

    public void toggleDockableWindow(String name) {
        if (this.isDockableWindowVisible(name)) {
            this.removeDockableWindow(name);
        } else {
            this.addDockableWindow(name);
        }
    }

    public JComponent getDockableWindow(String name) {
        return this.getDockable(name);
    }

    public void toggleDockAreas() {
        if (this.closeToggle) {
            this.tTop = this.getTopDockingArea().getCurrent() != null;
            this.tLeft = this.getLeftDockingArea().getCurrent() != null;
            this.tRight = this.getRightDockingArea().getCurrent() != null;
            this.tBottom = this.getBottomDockingArea().getCurrent() != null;
            this.getBottomDockingArea().show(null);
            this.getTopDockingArea().show(null);
            this.getRightDockingArea().show(null);
            this.getLeftDockingArea().show(null);
        } else {
            if (this.tBottom) {
                this.getBottomDockingArea().showMostRecent();
            }
            if (this.tLeft) {
                this.getLeftDockingArea().showMostRecent();
            }
            if (this.tRight) {
                this.getRightDockingArea().showMostRecent();
            }
            if (this.tTop) {
                this.getTopDockingArea().showMostRecent();
            }
        }
        this.view.closeAllMenus();
        this.closeToggle = !this.closeToggle;
        this.view.getTextArea().requestFocus();
    }

    public boolean willToggleHide() {
        return this.closeToggle;
    }

    public void dockableTitleChanged(String dockable, String newTitle) {
    }

    public KeyListener closeListener(String dockableName) {
        return new KeyHandler(dockableName);
    }

    public View getView() {
        return this.view;
    }

    public JComponent getDockable(String name) {
        return this.windows.get(name);
    }

    public String getDockableTitle(String name) {
        return this.longTitle(name);
    }

    public void setDockableTitle(String dockable, String title) {
        String propName = this.getLongTitlePropertyName(dockable);
        String oldTitle = jEdit.getProperty(propName);
        jEdit.setProperty(propName, title);
        this.firePropertyChange(propName, oldTitle, title);
        this.dockableTitleChanged(dockable, title);
    }

    public static String[] getRegisteredDockableWindows() {
        return DockableWindowFactory.getInstance().getRegisteredDockableWindows();
    }

    public static String getDockableWindowPluginName(String name) {
        String pluginClass = DockableWindowFactory.getInstance().getDockableWindowPluginClass(name);
        if (pluginClass == null) {
            return null;
        }
        return jEdit.getProperty("plugin." + pluginClass + ".name");
    }

    public void setDockingLayout(DockingLayout docking) {
        this.applyDockingLayout(docking);
        this.applyAlternateLayout(this.alternateLayout);
    }

    private void addPluginDockable(PluginJAR plugin, String name) {
        Set dockables = this.plugins.computeIfAbsent(plugin, k -> new HashSet());
        dockables.add(name);
    }

    @EditBus.EBHandler
    public void handleDockableWindowUpdate(DockableWindowUpdate msg) {
        if (msg.getWhat() == DockableWindowUpdate.PROPERTIES_CHANGED) {
            this.propertiesChanged();
        }
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged msg) {
        this.propertiesChanged();
    }

    @EditBus.EBHandler
    public void handlePluginUpdate(PluginUpdate pmsg) {
        Set<String> dockables;
        if (pmsg.getWhat() == PluginUpdate.LOADED) {
            Iterator<DockableWindowFactory.Window> iter = this.factory.getDockableWindowIterator();
            while (iter.hasNext()) {
                DockableWindowFactory.Window w = iter.next();
                if (w.plugin != pmsg.getPluginJAR()) continue;
                String position = this.getDockablePosition(w.name);
                this.positions.put(w.name, position);
                this.addPluginDockable(w.plugin, w.name);
                this.dockableLoaded(w.name, position);
            }
            this.propertiesChanged();
        } else if (!(pmsg.isExiting() || pmsg.getWhat() != PluginUpdate.DEACTIVATED && pmsg.getWhat() != PluginUpdate.UNLOADED || (dockables = this.plugins.remove(pmsg.getPluginJAR())) == null)) {
            for (String dockable : dockables) {
                this.disposeDockableWindow(dockable);
                this.windows.remove(dockable);
            }
        }
    }

    public String longTitle(String name) {
        String title = jEdit.getProperty(this.getLongTitlePropertyName(name));
        if (title == null) {
            return this.shortTitle(name);
        }
        return title;
    }

    public String shortTitle(String name) {
        String title = jEdit.getProperty(name + ".title");
        if (title == null) {
            return "NO TITLE PROPERTY: " + name;
        }
        return title;
    }

    protected void applyAlternateLayout(boolean alternateLayout) {
    }

    protected void dockableLoaded(String dockableName, String position) {
    }

    protected void dockingPositionChanged(String dockableName, String oldPosition, String newPosition) {
    }

    protected boolean getAlternateLayoutProp() {
        return this.alternateLayout;
    }

    protected void propertiesChanged() {
        String[] dockables;
        if (this.view.isPlainView()) {
            return;
        }
        boolean newAlternateLayout = jEdit.getBooleanProperty(ALTERNATE_LAYOUT_PROP);
        if (newAlternateLayout != this.alternateLayout) {
            this.alternateLayout = newAlternateLayout;
            this.applyAlternateLayout(newAlternateLayout);
        }
        for (String dockable : dockables = this.factory.getRegisteredDockableWindows()) {
            String oldPosition = this.positions.get(dockable);
            String newPosition = this.getDockablePosition(dockable);
            if (newPosition.equals(oldPosition)) continue;
            this.positions.put(dockable, newPosition);
            this.dockingPositionChanged(dockable, oldPosition, newPosition);
        }
    }

    protected JComponent createDockable(String name) {
        DockableWindowFactory.Window wf = this.factory.getDockableWindowFactory(name);
        if (wf == null) {
            Log.log(9, this, "Unknown dockable window: " + name);
            return null;
        }
        String position = this.getDockablePosition(name);
        JComponent window = wf.createDockableWindow(this.view, position);
        if (window != null) {
            this.windows.put(name, window);
        }
        return window;
    }

    protected String getDockablePosition(String name) {
        return jEdit.getProperty(name + ".dock-position", FLOATING);
    }

    protected void focusDockable(String name) {
        JComponent c = this.getDockable(name);
        if (c == null) {
            return;
        }
        if (c instanceof DefaultFocusComponent) {
            ((DefaultFocusComponent)((Object)c)).focusOnDefaultComponent();
        } else {
            c.requestFocus();
        }
    }

    protected String getLongTitlePropertyName(String dockableName) {
        return dockableName + ".longtitle";
    }

    public static interface DockingArea {
        public void showMostRecent();

        public String getCurrent();

        public void show(String var1);

        public String[] getDockables();
    }

    class KeyHandler
    extends KeyAdapter {
        static final String action = "close-docking-area";
        private List<KeyEventTranslator.Key> b1;
        private List<KeyEventTranslator.Key> b2;
        private final String name;
        private int match1;
        private int match2;

        KeyHandler(String dockableName) {
            KeymapManager keymapManager = jEdit.getKeymapManager();
            Keymap keymap = keymapManager.getKeymap();
            String shortcut1 = keymap.getShortcut("close-docking-area.shortcut");
            String shortcut2 = keymap.getShortcut("close-docking-area.shortcut2");
            if (shortcut1 != null) {
                this.b1 = this.parseShortcut(shortcut1);
            }
            if (shortcut2 != null) {
                this.b2 = this.parseShortcut(shortcut2);
            }
            this.name = dockableName;
            this.match2 = 0;
            this.match1 = 0;
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (this.b1 != null) {
                this.match1 = this.match(e, this.b1, this.match1);
            }
            if (this.b2 != null) {
                this.match2 = this.match(e, this.b2, this.match2);
            }
            if (this.match1 > 0 && this.b1 != null && this.match1 == this.b1.size() || this.match2 > 0 && this.b2 != null && this.match2 == this.b2.size()) {
                DockableWindowManager.this.hideDockableWindow(this.name);
                this.match2 = 0;
                this.match1 = 0;
            }
        }

        private int match(KeyEvent e, List<KeyEventTranslator.Key> shortcut, int index) {
            char c = e.getKeyChar();
            if (shortcut != null && c == shortcut.get((int)index).key) {
                return index + 1;
            }
            return 0;
        }

        private List<KeyEventTranslator.Key> parseShortcut(String shortcut) {
            String[] parts = shortcut.split("\\s+");
            ArrayList<KeyEventTranslator.Key> keys = new ArrayList<KeyEventTranslator.Key>(parts.length);
            for (String part : parts) {
                if (part.isEmpty()) continue;
                keys.add(KeyEventTranslator.parseKey(part));
            }
            return keys;
        }
    }

    public static abstract class DockingLayout {
        public static final int NO_VIEW_INDEX = -1;

        public abstract boolean loadLayout(String var1, int var2);

        public abstract boolean saveLayout(String var1, int var2);

        public abstract String getName();

        public void setPlainView(boolean plain) {
        }

        public String[] getSavedLayouts() {
            String layoutDir = this.getLayoutDirectory();
            if (layoutDir == null) {
                return null;
            }
            File dir2 = new File(layoutDir);
            File[] files = dir2.listFiles((dir1, name) -> name.endsWith(".xml"));
            if (files == null) {
                return null;
            }
            String[] layouts = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                layouts[i] = DockingLayout.fileToLayout(files[i].getName());
            }
            return layouts;
        }

        private static String fileToLayout(String filename) {
            return filename.replaceFirst(".xml", "");
        }

        private static String layoutToFile(String baseName, int viewIndex) {
            StringBuilder name = new StringBuilder(baseName);
            if (viewIndex != -1) {
                name.append("-view").append(viewIndex);
            }
            name.append(".xml");
            return name.toString();
        }

        public String getLayoutFilename(String baseName, int viewIndex) {
            String dir2 = this.getLayoutDirectory();
            if (dir2 == null) {
                return null;
            }
            return dir2 + File.separator + DockingLayout.layoutToFile(baseName, viewIndex);
        }

        private String getLayoutDirectory() {
            String name = this.getName();
            if (name == null) {
                return null;
            }
            Object dir2 = jEdit.getSettingsDirectory();
            if (dir2 == null) {
                return null;
            }
            File d = new File((String)(dir2 = (String)dir2 + File.separator + name));
            if (!d.exists()) {
                d.mkdir();
            }
            return dir2;
        }
    }
}

