/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.gui.ColorChooserDialog;
import org.gjt.sp.util.GenericGUIUtilities;

public class ColorWellButton
extends JButton {
    public ColorWellButton(Color color) {
        this.setIcon(new ColorWell(color));
        this.setMargin(new Insets(2, 2, 2, 2));
        this.addActionListener(new ActionHandler());
        if (OperatingSystem.isMacOSLF()) {
            this.putClientProperty("JButton.buttonType", "toolbar");
        }
    }

    public Color getSelectedColor() {
        return ((ColorWell)this.getIcon()).color;
    }

    public void setSelectedColor(Color color) {
        ((ColorWell)this.getIcon()).color = color;
        this.repaint();
        this.fireStateChanged();
    }

    private static class ColorWell
    implements Icon {
        Color color;
        private final Rectangle2D bounds = new JLabel("").getFont().createGlyphVector(new FontRenderContext(null, true, false), "AAAA").getVisualBounds();

        ColorWell(Color color) {
            this.color = color;
        }

        @Override
        public int getIconWidth() {
            return (int)Math.ceil(this.bounds.getWidth());
        }

        @Override
        public int getIconHeight() {
            return (int)Math.ceil(this.bounds.getHeight());
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.color == null) {
                return;
            }
            g.setColor(this.color);
            g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
            g.setColor(this.color.darker());
            g.drawRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1);
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Color c;
            JDialog parent = GenericGUIUtilities.getParentDialog(ColorWellButton.this);
            if (parent != null) {
                ColorChooserDialog dialog = new ColorChooserDialog((Window)parent, ColorWellButton.this.getSelectedColor());
                c = dialog.getColor();
            } else {
                ColorChooserDialog dialog = new ColorChooserDialog((Window)SwingUtilities.getRoot(ColorWellButton.this), ColorWellButton.this.getSelectedColor());
                c = dialog.getColor();
            }
            if (c != null) {
                ColorWellButton.this.setSelectedColor(c);
            }
        }
    }
}

