/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.gui.KeyEventWorkaround;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.StandardUtilities;

public class ActionBar
extends JToolBar {
    private static final NameSpace namespace = new NameSpace(BeanShell.getNameSpace(), "action bar namespace");
    private final View view;
    private boolean temp;
    private int repeatCount;
    private final HistoryTextField action;
    private CompletionPopup popup;

    public ActionBar(View view, boolean temp) {
        this.view = view;
        this.temp = temp;
        this.setLayout(new BoxLayout(this, 0));
        this.setFloatable(false);
        this.add(Box.createHorizontalStrut(2));
        JLabel label = new JLabel(jEdit.getProperty("view.action.prompt"));
        this.add(label);
        this.add(Box.createHorizontalStrut(12));
        this.action = new ActionTextField();
        this.add(this.action);
        this.action.setEnterAddsToHistory(false);
        Dimension max = this.action.getPreferredSize();
        max.width = Integer.MAX_VALUE;
        this.action.setMaximumSize(max);
        this.action.addActionListener(e -> this.invoke());
        this.action.getDocument().addDocumentListener(new DocumentHandler());
        if (temp) {
            RolloverButton close = new RolloverButton(GUIUtilities.loadIcon("closebox.gif"));
            close.addActionListener(e -> view.removeToolBar(this));
            close.setToolTipText(jEdit.getProperty("view.action.close-tooltip"));
            this.add(close);
        }
        this.temp = temp;
    }

    public HistoryTextField getField() {
        return this.action;
    }

    public void goToActionBar() {
        this.repeatCount = this.view.getInputHandler().getRepeatCount();
        this.action.setText(null);
        this.action.requestFocus();
    }

    private void invoke() {
        String finalCmd;
        EditAction act;
        String cmd;
        if (this.popup != null) {
            cmd = (String)this.popup.list.getSelectedValue();
        } else {
            cmd = this.action.getText().trim();
            int index = cmd.indexOf(61);
            if (index != -1) {
                this.action.addCurrentToHistory();
                String propName = cmd.substring(0, index).trim();
                String propValue = cmd.substring(index + 1).trim();
                StringBuilder code = new StringBuilder(128);
                if (propName.startsWith("buffer.")) {
                    if (propName.equals("buffer.mode")) {
                        code.append("buffer.setMode(\"").append(StandardUtilities.charsToEscapes(propValue)).append("\");");
                    } else {
                        code.append("buffer.setStringProperty(\"").append(StandardUtilities.charsToEscapes(propName.substring("buffer.".length()))).append("\",\"").append(StandardUtilities.charsToEscapes(propValue)).append("\");");
                    }
                    code.append("\nbuffer.propertiesChanged();");
                } else if (propName.startsWith("!buffer.")) {
                    code.append("jEdit.setProperty(\"").append(StandardUtilities.charsToEscapes(propName.substring(1))).append("\",\"").append(StandardUtilities.charsToEscapes(propValue)).append("\");\njEdit.propertiesChanged();");
                } else {
                    code.append("jEdit.setProperty(\"").append(StandardUtilities.charsToEscapes(propName)).append("\",\"").append(StandardUtilities.charsToEscapes(propValue)).append("\");\njEdit.propertiesChanged();");
                }
                Macros.Recorder recorder = this.view.getMacroRecorder();
                if (recorder != null) {
                    recorder.record(code.toString());
                }
                BeanShell.eval(this.view, namespace, code.toString());
                cmd = null;
            } else if (!cmd.isEmpty()) {
                String[] completions = ActionBar.getCompletions(cmd);
                if (completions.length != 0) {
                    cmd = completions[0];
                }
            } else {
                cmd = null;
            }
        }
        if (this.popup != null) {
            this.popup.dispose();
            this.popup = null;
        }
        EditAction editAction = act = (finalCmd = cmd) == null ? null : jEdit.getAction(finalCmd);
        if (this.temp) {
            this.view.removeToolBar(this);
        }
        SwingUtilities.invokeLater(() -> {
            this.view.getTextArea().requestFocus();
            if (act == null) {
                if (finalCmd != null) {
                    this.view.getStatus().setMessageAndClear(jEdit.getProperty("view.action.no-completions"));
                }
            } else {
                this.view.getInputHandler().setRepeatCount(this.repeatCount);
                this.view.getInputHandler().invokeAction(act);
            }
        });
    }

    private static String[] getCompletions(String str) {
        str = str.toLowerCase();
        String[] actions = jEdit.getActionNames();
        ArrayList<String> returnValue = new ArrayList<String>(actions.length);
        for (String act : actions) {
            if (!act.toLowerCase().contains(str)) continue;
            returnValue.add(act);
        }
        return returnValue.toArray(StandardUtilities.EMPTY_STRING_ARRAY);
    }

    private void complete(boolean insertLongestPrefix) {
        String text = this.action.getText().trim();
        String[] completions = ActionBar.getCompletions(text);
        if (completions.length == 1) {
            if (insertLongestPrefix) {
                this.action.setText(completions[0]);
            }
        } else if (completions.length != 0) {
            String prefix;
            if (insertLongestPrefix && (prefix = MiscUtilities.getLongestPrefix(completions, true)).contains(text)) {
                this.action.setText(prefix);
            }
            if (this.popup != null) {
                this.popup.setModel(completions);
            } else {
                this.popup = new CompletionPopup(completions);
            }
            return;
        }
        if (this.popup != null) {
            this.popup.dispose();
            this.popup = null;
        }
    }

    private class ActionTextField
    extends HistoryTextField {
        boolean repeat;
        boolean nonDigit;

        ActionTextField() {
            super("action");
            this.setSelectAllOnFocus(true);
        }

        @Override
        public boolean getFocusTraversalKeysEnabled() {
            return false;
        }

        @Override
        public void processKeyEvent(KeyEvent evt) {
            if ((evt = KeyEventWorkaround.processKeyEvent(evt)) == null) {
                return;
            }
            switch (evt.getID()) {
                case 400: {
                    char ch = evt.getKeyChar();
                    if (!this.nonDigit && Character.isDigit(ch)) {
                        super.processKeyEvent(evt);
                        this.repeat = true;
                        ActionBar.this.repeatCount = Integer.parseInt(ActionBar.this.action.getText());
                        break;
                    }
                    this.nonDigit = true;
                    if (this.repeat) {
                        this.passToView(evt);
                        break;
                    }
                    super.processKeyEvent(evt);
                    break;
                }
                case 401: {
                    int keyCode = evt.getKeyCode();
                    if (evt.isActionKey() || evt.isControlDown() || evt.isAltDown() || evt.isMetaDown() || keyCode == 8 || keyCode == 127 || keyCode == 10 || keyCode == 9 || keyCode == 27) {
                        this.nonDigit = true;
                        if (this.repeat) {
                            this.passToView(evt);
                            break;
                        }
                        if (keyCode == 9) {
                            ActionBar.this.complete(true);
                            evt.consume();
                        } else {
                            if (keyCode == 27) {
                                evt.consume();
                                if (ActionBar.this.popup != null) {
                                    ActionBar.this.popup.dispose();
                                    ActionBar.this.popup = null;
                                    ActionBar.this.action.requestFocus();
                                    break;
                                }
                                if (ActionBar.this.temp) {
                                    ActionBar.this.view.removeToolBar(ActionBar.this);
                                }
                                ActionBar.this.view.getEditPane().focusOnTextArea();
                                break;
                            }
                            if ((keyCode == 38 || keyCode == 40) && ActionBar.this.popup != null) {
                                ActionBar.this.popup.list.processKeyEvent(evt);
                                break;
                            }
                        }
                    }
                    super.processKeyEvent(evt);
                }
            }
        }

        private void passToView(KeyEvent evt) {
            if (ActionBar.this.temp) {
                ActionBar.this.view.removeToolBar(ActionBar.this);
            }
            ActionBar.this.view.getTextArea().requestFocus();
            SwingUtilities.invokeLater(() -> {
                ActionBar.this.view.getTextArea().requestFocus();
                ActionBar.this.view.getInputHandler().setRepeatCount(ActionBar.this.repeatCount);
                ActionBar.this.view.getInputHandler().processKeyEvent(evt, 2, false);
            });
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.nonDigit = false;
            this.repeat = false;
        }
    }

    private class DocumentHandler
    implements DocumentListener {
        private DocumentHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            if (ActionBar.this.popup != null) {
                ActionBar.this.complete(false);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            if (ActionBar.this.popup != null) {
                ActionBar.this.complete(false);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
        }
    }

    private class CompletionPopup
    extends JWindow {
        CompletionList<String> list;

        CompletionPopup(String[] actions) {
            super(ActionBar.this.view);
            this.setContentPane(new JPanel(new BorderLayout()){

                @Override
                public boolean getFocusTraversalKeysEnabled() {
                    return false;
                }
            });
            this.list = new CompletionList<String>(actions);
            this.list.setVisibleRowCount(8);
            this.list.addMouseListener(new MouseHandler());
            this.list.setSelectedIndex(0);
            this.list.setSelectionMode(0);
            JScrollPane scroller = new JScrollPane(this.list, 22, 31);
            this.getContentPane().add((Component)scroller, "Center");
            GenericGUIUtilities.requestFocus(this, this.list);
            this.pack();
            Point p = new Point(0, -this.getHeight());
            SwingUtilities.convertPointToScreen(p, ActionBar.this.action);
            this.setLocation(p);
            this.setVisible(true);
            KeyHandler keyHandler = new KeyHandler();
            this.addKeyListener(keyHandler);
            this.list.addKeyListener(keyHandler);
        }

        void setModel(String[] actions) {
            this.list.setListData((String[])actions);
            this.list.setSelectedIndex(0);
        }

        class CompletionList<E>
        extends JList<E> {
            CompletionList(E[] data) {
                super(data);
            }

            @Override
            public void processKeyEvent(KeyEvent evt) {
                super.processKeyEvent(evt);
            }
        }

        private class MouseHandler
        extends MouseAdapter {
            private MouseHandler() {
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                ActionBar.this.invoke();
            }
        }

        private class KeyHandler
        extends KeyAdapter {
            private KeyHandler() {
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                ActionBar.this.action.processKeyEvent(evt);
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                int selected;
                int keyCode = evt.getKeyCode();
                if (keyCode == 27) {
                    ActionBar.this.action.processKeyEvent(evt);
                } else if (keyCode == 10) {
                    ActionBar.this.invoke();
                } else if (keyCode == 38) {
                    int selected2 = CompletionPopup.this.list.getSelectedIndex();
                    if (selected2 == 0) {
                        CompletionPopup.this.list.setSelectedIndex(CompletionPopup.this.list.getModel().getSize() - 1);
                        evt.consume();
                    }
                } else if (keyCode == 40 && (selected = CompletionPopup.this.list.getSelectedIndex()) == CompletionPopup.this.list.getModel().getSize() - 1) {
                    CompletionPopup.this.list.setSelectedIndex(0);
                    evt.consume();
                }
            }
        }
    }
}

