/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bufferset;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.visitors.JEditVisitorAdapter;
import org.gjt.sp.util.Log;

public class BufferSetManager {
    private BufferSet.Scope scope;

    public BufferSetManager() {
        EditBus.addToBus(this);
        try {
            this.scope = BufferSet.Scope.valueOf(jEdit.getProperty("bufferset.scope", "global"));
        }
        catch (IllegalArgumentException e) {
            Log.log(9, this, e);
            this.scope = BufferSet.Scope.global;
        }
    }

    @EditBus.EBHandler
    public void handleEditPaneUpdate(EditPaneUpdate message) {
        if (message.getWhat() == EditPaneUpdate.DESTROYED) {
            Buffer[] allBuffers;
            EditPane editPane = message.getEditPane();
            BufferSet bufferSet = editPane.getBufferSet();
            for (Buffer buffer : allBuffers = bufferSet.getAllBuffers()) {
                this._removeBuffer(bufferSet, buffer);
            }
        }
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged msg) {
        jEdit.getEditPaneManager().forEach(editPane -> editPane.getBufferSet().propertiesChanged());
    }

    public int countBufferSets(Buffer buffer) {
        return this.getOwners(buffer).size();
    }

    public void setScope(BufferSet.Scope scope) {
        if (scope == this.scope) {
            return;
        }
        jEdit.setProperty("bufferset.scope", scope.name());
        if (scope.compareTo(this.scope) > 0) {
            if (scope == BufferSet.Scope.global) {
                final List<Buffer> buffers = jEdit.getBufferManager().getBuffers();
                jEdit.visit(new JEditVisitorAdapter(){

                    @Override
                    public void visit(EditPane editPane) {
                        BufferSet bufferSet = editPane.getBufferSet();
                        buffers.forEach(bufferSet::addBuffer);
                    }
                });
            } else {
                final HashMap buffersMap = new HashMap();
                jEdit.visit(new JEditVisitorAdapter(){

                    @Override
                    public void visit(EditPane editPane) {
                        BufferSet bufferSet = editPane.getBufferSet();
                        Buffer[] buffers = bufferSet.getAllBuffers();
                        Set set = buffersMap.computeIfAbsent(editPane.getView(), k -> new HashSet());
                        set.addAll(Arrays.asList(buffers));
                    }
                });
                jEdit.visit(new JEditVisitorAdapter(){

                    @Override
                    public void visit(EditPane editPane) {
                        BufferSet bufferSet = editPane.getBufferSet();
                        Set set = (Set)buffersMap.get(editPane.getView());
                        for (Buffer buffer : set) {
                            bufferSet.addBuffer(buffer);
                        }
                    }
                });
            }
        }
        this.scope = scope;
        EditBus.send(new PropertiesChanged(this));
    }

    public BufferSet.Scope getScope() {
        return this.scope;
    }

    public void addBuffer(View view, Buffer buffer) {
        EditPane editPane = view == null ? null : view.getEditPane();
        this.addBuffer(editPane, buffer);
    }

    public void addBuffer(EditPane editPane, Buffer buffer) {
        if (editPane == null) {
            editPane = jEdit.getActiveView().getEditPane();
        }
        BufferSet bufferSet = editPane.getBufferSet();
        switch (this.scope) {
            case editpane: {
                bufferSet.addBuffer(buffer);
                break;
            }
            case view: {
                editPane.getView().forEachEditPane(pane -> pane.getBufferSet().addBuffer(buffer));
                break;
            }
            case global: {
                jEdit.getEditPaneManager().forEach(pane -> pane.getBufferSet().addBuffer(buffer));
            }
        }
    }

    public void moveBuffer(EditPane editPane, int oldPosition, int newPosition) {
        editPane.getBufferSet().moveBuffer(oldPosition, newPosition);
    }

    public void removeBuffer(EditPane editPane, Buffer buffer) {
        switch (this.scope) {
            case editpane: {
                BufferSet bufferSet = editPane.getBufferSet();
                this.removeBuffer(bufferSet, buffer);
                break;
            }
            case view: {
                editPane.getView().forEachEditPane(pane -> this.removeBuffer(pane.getBufferSet(), buffer));
                break;
            }
            case global: {
                jEdit._closeBuffer(null, buffer);
            }
        }
    }

    void removeBuffer(BufferSet bufferSet, Buffer buffer) {
        Log.log(1, this, "removeBuffer(" + String.valueOf(bufferSet) + "," + String.valueOf(buffer) + ")");
        this._removeBuffer(bufferSet, buffer);
        this.bufferRemoved(bufferSet);
    }

    public void removeBuffer(Buffer buffer) {
        for (BufferSet bufferSet : this.getOwners(buffer)) {
            bufferSet.removeBuffer(buffer);
            this.bufferRemoved(bufferSet);
        }
    }

    private void bufferRemoved(BufferSet bufferSet) {
        if (bufferSet.size() == 0) {
            Buffer newEmptyBuffer = BufferSetManager.createUntitledBuffer();
            EditPane editPaneOwner = BufferSetManager.getOwner(bufferSet);
            this.addBuffer(editPaneOwner, newEmptyBuffer);
        }
    }

    private void _removeBuffer(BufferSet bufferSet, Buffer buffer) {
        Set<BufferSet> owners = this.getOwners(buffer);
        owners.remove(bufferSet);
        bufferSet.removeBuffer(buffer);
        if (owners.isEmpty()) {
            Log.log(1, this, "Buffer:" + String.valueOf(buffer) + " is in no bufferSet anymore, closing it");
            jEdit._closeBuffer(null, buffer);
        }
    }

    public static Buffer createUntitledBuffer() {
        int untitledCount = jEdit.getNextUntitledBufferId();
        View view = jEdit.getActiveView();
        String parent = null;
        if (view != null) {
            Buffer buffer = view.getBuffer();
            parent = buffer.getDirectory();
        }
        if (parent == null) {
            parent = MiscUtilities.getBackupDirectory();
        }
        VFS vfs = null;
        if (parent != null) {
            vfs = VFSManager.getVFSForPath(parent);
        }
        if (vfs != null && (vfs.getCapabilities() & 2) == 0) {
            parent = System.getProperty("user.home");
        }
        Buffer newEmptyBuffer = jEdit.openTemporary(view, parent, "Untitled-" + untitledCount, true, true);
        jEdit.commitTemporary(newEmptyBuffer);
        return newEmptyBuffer;
    }

    public Set<BufferSet> getOwners(Buffer buffer) {
        HashSet<BufferSet> candidates = new HashSet<BufferSet>();
        jEdit.getEditPaneManager().forEach(editPane -> candidates.add(editPane.getBufferSet()));
        candidates.removeIf(bufferSet -> !bufferSet.contains(buffer));
        return candidates;
    }

    private static EditPane getOwner(BufferSet bufferSet) {
        List<View> views = jEdit.getViewManager().getViews();
        for (View view : views) {
            EditPane[] editPanes;
            for (EditPane editPane : editPanes = view.getEditPanes()) {
                if (editPane.getBufferSet() != bufferSet) continue;
                return editPane;
            }
        }
        return null;
    }
}

