/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bufferio;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bufferio.BufferIORequest;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;

public class BufferAutosaveRequest
extends BufferIORequest {
    public BufferAutosaveRequest(View view, Buffer buffer, Object session, VFS vfs, String path) {
        super(view, buffer, session, vfs, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void _run() {
        block14: {
            OutputStream out = null;
            try {
                Object[] args = new String[]{this.vfs.getFileName(this.path)};
                this.setStatus(jEdit.getProperty("vfs.status.autosave", args));
                this.setCancellable(true);
                try {
                    this.buffer.readLock();
                    if (this.buffer.isDirty()) {
                        out = this.vfs._createOutputStream(this.session, this.path, this.view);
                    }
                    if (out != null) {
                        Log.log(1, MiscUtilities.class, "Saving autosave of file \"" + this.buffer.getPath() + "\" to \"" + this.path + "\"");
                        this.write(this.buffer, out);
                    }
                }
                catch (FileNotFoundException e) {
                    Log.log(7, this, "Unable to save " + e.getMessage());
                }
                catch (InterruptedException e) {
                    this.cleanUpIncomplete(out);
                    Thread.currentThread().interrupt();
                }
                catch (Exception e2) {
                    Log.log(9, this, e2);
                    Object[] pp = new String[]{e2.toString()};
                    VFSManager.error(this.view, this.path, "ioerror.write-error", pp);
                    this.cleanUpIncomplete(out);
                    break block14;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.buffer.readUnlock();
                }
            }
            finally {
                IOUtilities.closeQuietly(out);
            }
        }
    }

    private void cleanUpIncomplete(Closeable out) {
        if (out != null) {
            try {
                out.close();
                this.vfs._delete(this.session, this.path, this.view);
            }
            catch (IOException ioe) {
                Log.log(9, this, ioe);
            }
        }
    }
}

