/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.swing.text.Position;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.util.Log;
import org.jedit.util.CleanerService;

class PositionManager {
    boolean iteration;
    private final JEditBuffer buffer;
    private final SortedMap<PosBottomHalf, PosBottomHalf> positions = new TreeMap<PosBottomHalf, PosBottomHalf>();

    PositionManager(JEditBuffer buffer) {
        this.buffer = buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Position createPosition(int offset) {
        PosTopHalf posTopHalf;
        PosBottomHalf existing;
        PositionManager positionManager = this;
        synchronized (positionManager) {
            PosBottomHalf bh = new PosBottomHalf(offset);
            existing = (PosBottomHalf)this.positions.get(bh);
            if (existing == null) {
                this.positions.put(bh, bh);
                existing = bh;
            }
            posTopHalf = new PosTopHalf(existing);
            existing.ref();
        }
        PosBottomHalf finalExisting = existing;
        CleanerService.instance.register(posTopHalf, () -> this.unref(finalExisting));
        return posTopHalf;
    }

    public synchronized void contentInserted(int offset, int length) {
        if (this.positions.isEmpty()) {
            return;
        }
        Iterator<PosBottomHalf> iter = this.positions.tailMap(new PosBottomHalf(offset)).keySet().iterator();
        this.iteration = true;
        while (iter.hasNext()) {
            iter.next().contentInserted(offset, length);
        }
        this.iteration = false;
    }

    public synchronized void contentRemoved(int offset, int length) {
        if (this.positions.isEmpty()) {
            return;
        }
        Iterator<PosBottomHalf> iter = this.positions.tailMap(new PosBottomHalf(offset)).keySet().iterator();
        this.iteration = true;
        while (iter.hasNext()) {
            iter.next().contentRemoved(offset, length);
        }
        this.iteration = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unref(PosBottomHalf posBottomHalf) {
        PositionManager positionManager = this;
        synchronized (positionManager) {
            posBottomHalf.unref();
        }
    }

    class PosBottomHalf
    implements Comparable<PosBottomHalf> {
        private int offset;
        private int ref;

        PosBottomHalf(int offset) {
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }

        void ref() {
            ++this.ref;
        }

        void unref() {
            if (--this.ref == 0) {
                PositionManager.this.positions.remove(this);
            }
        }

        void contentInserted(int offset, int length) {
            if (offset > this.offset) {
                throw new ArrayIndexOutOfBoundsException(offset);
            }
            this.offset += length;
            this.checkInvariants();
        }

        void contentRemoved(int offset, int length) {
            if (offset > this.offset) {
                throw new ArrayIndexOutOfBoundsException(offset);
            }
            this.offset = this.offset <= offset + length ? offset : (this.offset -= length);
            this.checkInvariants();
        }

        public boolean equals(Object o) {
            if (!(o instanceof PosBottomHalf)) {
                return false;
            }
            return ((PosBottomHalf)o).offset == this.offset;
        }

        @Override
        public int compareTo(@Nonnull PosBottomHalf posBottomHalf) {
            if (PositionManager.this.iteration) {
                Log.log(9, this, "Consistency failure");
            }
            return this.offset - posBottomHalf.offset;
        }

        private void checkInvariants() {
            if (this.offset < 0 || this.offset > PositionManager.this.buffer.getLength()) {
                throw new ArrayIndexOutOfBoundsException(this.offset);
            }
        }
    }

    private static class PosTopHalf
    implements Position {
        private final PosBottomHalf bh;

        PosTopHalf(PosBottomHalf bh) {
            this.bh = bh;
        }

        @Override
        public int getOffset() {
            return this.bh.getOffset();
        }
    }
}

