/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Component;
import org.gjt.sp.jedit.BeanShellFacade;
import org.gjt.sp.jedit.JEditAbstractEditAction;
import org.gjt.sp.jedit.bsh.BshMethod;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;

public class JEditBeanShellAction
extends JEditAbstractEditAction<TextArea> {
    private final boolean noRepeat;
    private final boolean noRecord;
    private final boolean noRememberLast;
    private final String code;
    private String isSelected;
    private BshMethod cachedCode;
    private BshMethod cachedIsSelected;
    private final String sanitizedName;
    private static final BeanShellFacade<TextArea> bsh = new MyBeanShellFacade();

    public JEditBeanShellAction(String name, String code, String isSelected, boolean noRepeat, boolean noRecord, boolean noRememberLast) {
        super(name);
        this.code = code;
        this.isSelected = isSelected;
        this.noRepeat = noRepeat;
        this.noRecord = noRecord;
        this.noRememberLast = noRememberLast;
        this.sanitizedName = name.replace('.', '_').replace('-', '_');
    }

    @Override
    public void invoke(TextArea textArea) {
        try {
            if (this.cachedCode == null) {
                String cachedCodeName = "action_" + this.sanitizedName;
                this.cachedCode = bsh.cacheBlock(cachedCodeName, this.code, true);
            }
            bsh.runCachedBlock(this.cachedCode, textArea, new NameSpace(bsh.getNameSpace(), "BeanShellAction.invoke()"));
        }
        catch (Throwable e) {
            Log.log(9, this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSelected(Component comp) {
        if (this.isSelected == null) {
            return false;
        }
        NameSpace global = bsh.getNameSpace();
        try {
            if (this.cachedIsSelected == null) {
                String cachedIsSelectedName = "selected_" + this.sanitizedName;
                this.cachedIsSelected = bsh.cacheBlock(cachedIsSelectedName, this.isSelected, true);
            }
            global.setVariable("_comp", comp);
            boolean cachedIsSelectedName = Boolean.TRUE.equals(bsh.runCachedBlock(this.cachedIsSelected, null, new NameSpace(bsh.getNameSpace(), "BeanShellAction.isSelected()")));
            return cachedIsSelectedName;
        }
        catch (Throwable e) {
            Log.log(9, this, e);
            this.isSelected = null;
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                global.setVariable("_comp", null);
            }
            catch (UtilEvalError err) {
                Log.log(9, this, err);
            }
        }
    }

    public boolean noRepeat() {
        return this.noRepeat;
    }

    public boolean noRecord() {
        return this.noRecord;
    }

    public boolean noRememberLast() {
        return this.noRememberLast;
    }

    public String getCode() {
        return this.code.trim();
    }

    private static class MyBeanShellFacade
    extends BeanShellFacade<TextArea> {
        private MyBeanShellFacade() {
        }

        @Override
        protected void setupDefaultVariables(NameSpace namespace, TextArea textArea) throws UtilEvalError {
            if (textArea != null) {
                this.setVariable(namespace, "buffer", textArea.getBuffer());
                this.setVariable(namespace, "textArea", textArea);
            }
        }

        @Override
        protected void resetDefaultVariables(NameSpace namespace) throws UtilEvalError {
            namespace.setVariable("buffer", null, false);
            namespace.setVariable("textArea", null, false);
        }

        @Override
        protected void handleException(TextArea textArea, String path, Throwable t) {
            Log.log(9, this, t, t);
        }
    }
}

