/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;
import javax.swing.JMenuItem;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.EnhancedMenu;
import org.gjt.sp.util.Log;

public abstract class EditPlugin {
    PluginJAR jar;

    public void start() {
    }

    public void stop() {
    }

    @Nullable
    public File getPluginHome() {
        return EditPlugin.getPluginHome(this.getClassName());
    }

    @Nullable
    public static File getPluginHome(Class<? extends EditPlugin> clazz) {
        return EditPlugin.getPluginHome(clazz.getName());
    }

    @Nullable
    public static File getPluginHome(EditPlugin plugin) {
        return EditPlugin.getPluginHome(plugin.getClassName());
    }

    @Nullable
    private static File getPluginHome(String pluginClassName) {
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory == null) {
            return null;
        }
        File file = new File(settingsDirectory, "plugins");
        if (!file.isDirectory() && !file.mkdir()) {
            Log.log(9, EditPlugin.class, "Can't create directory:" + file.getAbsolutePath());
        }
        return new File(file, pluginClassName);
    }

    public static InputStream getResourceAsStream(Class<? extends EditPlugin> clazz, String path) {
        return EditPlugin.getResourceAsStream(clazz.getName(), path);
    }

    public static InputStream getResourceAsStream(EditPlugin plugin, String path) {
        return EditPlugin.getResourceAsStream(plugin.getClassName(), path);
    }

    private static InputStream getResourceAsStream(String pluginClassName, String path) {
        try {
            File file = EditPlugin.getResourcePath(pluginClassName, path);
            if (file == null || !file.exists()) {
                return null;
            }
            return new FileInputStream(file);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static OutputStream getResourceAsOutputStream(Class<? extends EditPlugin> clazz, String path) {
        return EditPlugin.getResourceAsOutputStream(clazz.getName(), path);
    }

    public static OutputStream getResourceAsOutputStream(EditPlugin plugin, String path) {
        return EditPlugin.getResourceAsOutputStream(plugin.getClassName(), path);
    }

    private static OutputStream getResourceAsOutputStream(String pluginClassName, String path) {
        try {
            File file = EditPlugin.getResourcePath(pluginClassName, path);
            if (file == null) {
                return null;
            }
            File parentFile = file.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                Log.log(9, EditPlugin.class, "Unable to create folder " + parentFile.getPath());
                return null;
            }
            return new FileOutputStream(file);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static File getResourcePath(Class<? extends EditPlugin> clazz, String path) {
        return EditPlugin.getResourcePath(clazz.getName(), path);
    }

    public static File getResourcePath(EditPlugin plugin, String path) {
        return EditPlugin.getResourcePath(plugin.getClassName(), path);
    }

    @Nullable
    private static File getResourcePath(String pluginClassName, String path) {
        File home = EditPlugin.getPluginHome(pluginClassName);
        if (home == null) {
            return null;
        }
        return new File(home, path);
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public PluginJAR getPluginJAR() {
        return this.jar;
    }

    public final JMenuItem createMenuItems() {
        if (this instanceof Broken) {
            return null;
        }
        String menuItemName = jEdit.getProperty("plugin." + this.getClassName() + ".menu-item");
        if (menuItemName != null) {
            return GUIUtilities.loadMenuItem(menuItemName);
        }
        String menuProperty = "plugin." + this.getClassName() + ".menu";
        String codeProperty = "plugin." + this.getClassName() + ".menu.code";
        if (jEdit.getProperty(menuProperty) != null || jEdit.getProperty(codeProperty) != null) {
            String pluginName = jEdit.getProperty("plugin." + this.getClassName() + ".name");
            return new EnhancedMenu(menuProperty, pluginName);
        }
        return null;
    }

    public final JMenuItem createBrowserMenuItems() {
        if (this instanceof Broken) {
            return null;
        }
        String menuItemName = jEdit.getProperty("plugin." + this.getClassName() + ".browser-menu-item");
        if (menuItemName != null) {
            return GUIUtilities.loadMenuItem(VFSBrowser.getActionContext(), menuItemName, false);
        }
        String menuProperty = "plugin." + this.getClassName() + ".browser-menu";
        String codeProperty = "plugin." + this.getClassName() + ".browser-menu.code";
        if (jEdit.getProperty(menuProperty) != null || jEdit.getProperty(codeProperty) != null) {
            String pluginName = jEdit.getProperty("plugin." + this.getClassName() + ".name");
            return new EnhancedMenu(menuProperty, pluginName, VFSBrowser.getActionContext());
        }
        return null;
    }

    public static class Broken
    extends EditPlugin {
        private final String clazz;

        @Override
        public String getClassName() {
            return this.clazz;
        }

        Broken(PluginJAR jar, String clazz) {
            this.jar = jar;
            this.clazz = clazz;
        }
    }

    public static class Deferred
    extends EditPlugin {
        private final String clazz;

        @Override
        public String getClassName() {
            return this.clazz;
        }

        Deferred(PluginJAR jar, String clazz) {
            this.jar = jar;
            this.clazz = clazz;
        }

        EditPlugin loadPluginClass() {
            return null;
        }

        public String toString() {
            return "Deferred[" + this.clazz + "]";
        }
    }
}

