/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.EventQueue;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;

public class EditBus {
    private static final HandlerList components = new HandlerList();

    public static void addToBus(EBComponent comp) {
        EditBus.addToBus((Object)comp);
    }

    public static void addToBus(Object comp) {
        components.addComponent(comp);
    }

    public static void removeFromBus(EBComponent comp) {
        EditBus.removeFromBus((Object)comp);
    }

    public static void removeFromBus(Object comp) {
        components.removeComponent(comp);
    }

    public static void send(EBMessage message) {
        SendMessage sender = new SendMessage(message);
        if (EventQueue.isDispatchThread()) {
            sender.run();
        } else {
            ThreadUtilities.runInDispatchThreadNow(sender);
        }
    }

    public static void sendAsync(EBMessage message) {
        EventQueue.invokeLater(new SendMessage(message));
    }

    private EditBus() {
    }

    private static void dispatch(EBMessageHandler emh, EBMessage msg) throws Exception {
        if (emh.handler != null && emh.comp != null) {
            emh.handler.invoke(emh.comp, msg);
        } else {
            assert (emh.comp instanceof EBComponent);
            ((EBComponent)emh.comp).handleMessage(msg);
        }
    }

    private static void sendImpl(EBMessage message) {
        boolean isExact = true;
        Class<?> type = message.getClass();
        while (!type.equals(Object.class)) {
            List handlers = (List)components.get(type);
            if (handlers != null) {
                try {
                    for (EBMessageHandler emh : handlers) {
                        if (!isExact && emh.source != null && emh.source.exact()) continue;
                        if (Debug.EB_TIMER) {
                            long start = System.nanoTime();
                            EditBus.dispatch(emh, message);
                            long time = System.nanoTime() - start;
                            if (time < 1000000L) continue;
                            Log.log(1, EditBus.class, String.valueOf(emh.comp) + ": " + time + " ns");
                            continue;
                        }
                        EditBus.dispatch(emh, message);
                    }
                }
                catch (InvocationTargetException t) {
                    Log.log(9, EditBus.class, "Exception while sending message on EditBus:");
                    Log.log(9, EditBus.class, t.getCause());
                }
                catch (Throwable t) {
                    Log.log(9, EditBus.class, "Exception while sending message on EditBus:");
                    Log.log(9, EditBus.class, t);
                }
            }
            type = type.getSuperclass();
            isExact = false;
        }
    }

    private static class HandlerList
    extends HashMap<Class<?>, List<EBMessageHandler>> {
        private int lock;
        private final List<Object> add = new LinkedList<Object>();
        private final List<Object> remove = new LinkedList<Object>();

        private HandlerList() {
        }

        public List<EBMessageHandler> safeGet(Class<?> type) {
            return this.computeIfAbsent(type, k -> new LinkedList());
        }

        public synchronized void lock() {
            ++this.lock;
        }

        public synchronized void unlock() {
            --this.lock;
            if (this.lock == 0) {
                for (Object comp : this.add) {
                    this.addComponent(comp);
                }
                for (Object comp : this.remove) {
                    this.removeComponent(comp);
                }
                this.add.clear();
                this.remove.clear();
            }
        }

        public synchronized void removeComponent(Object comp) {
            if (this.lock != 0) {
                this.remove.add(comp);
                return;
            }
            for (Map.Entry entry : this.entrySet()) {
                Class msg = (Class)entry.getKey();
                List handlers = (List)entry.getValue();
                if (handlers == null) continue;
                handlers.removeIf(emh -> emh.comp == comp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void addComponent(Object comp) {
            if (this.lock != 0) {
                this.add.add(comp);
                return;
            }
            for (Method m : comp.getClass().getMethods()) {
                EBHandler source = m.getAnnotation(EBHandler.class);
                if (source == null) continue;
                Class<?>[] params = m.getParameterTypes();
                if (params.length != 1) {
                    Log.log(9, EditBus.class, "Invalid EBHandler method " + m.getName() + " in class " + comp.getClass().getName() + ": too many parameters.");
                    continue;
                }
                if (!EBMessage.class.isAssignableFrom(params[0])) {
                    Log.log(9, EditBus.class, "Invalid parameter " + params[0].getName() + " in method " + m.getName() + " of class " + comp.getClass().getName());
                    continue;
                }
                HandlerList handlerList = components;
                synchronized (handlerList) {
                    this.safeGet(params[0]).add(new EBMessageHandler(comp, m, source));
                }
            }
            if (comp instanceof EBComponent) {
                this.safeGet(EBMessage.class).add(new EBMessageHandler(comp, null, null));
            }
        }
    }

    private static class SendMessage
    implements Runnable {
        private final EBMessage message;

        SendMessage(EBMessage message) {
            this.message = message;
        }

        @Override
        public void run() {
            Log.log(1, EditBus.class, this.message.toString());
            components.lock();
            try {
                EditBus.sendImpl(this.message);
            }
            finally {
                components.unlock();
            }
        }
    }

    private static class EBMessageHandler {
        Object comp;
        Method handler;
        EBHandler source;

        EBMessageHandler(Object comp, Method handler, EBHandler source) {
            this.comp = comp;
            this.handler = handler;
            this.source = source;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface EBHandler {
        public boolean exact() default false;
    }
}

