/*
 * Decompiled with CFR 0.152.
 */
package isabelle.setup;

import isabelle.setup.Build;
import isabelle.setup.Environment;
import isabelle.setup.Exn;
import isabelle.setup.GUI_Setup;
import isabelle.setup.Library;

class Setup {
    Setup() {
    }

    private static void echo(String string) {
        System.out.print(string + "\n");
    }

    private static void echo_err(String string) {
        System.err.print(string + "\n");
    }

    private static void fail(String string) {
        Setup.echo_err(string);
        System.exit(2);
    }

    private static void check_args(boolean bl) {
        if (!bl) {
            Setup.fail("Bad command-line arguments");
        }
    }

    public static void main(String[] stringArray) {
        int n = stringArray.length;
        Setup.check_args(n > 0);
        String string = stringArray[0];
        try {
            switch (string) {
                case "build": {
                    Setup.check_args(n == 1);
                    Build.build_components(System.err, false);
                    break;
                }
                case "build_fresh": {
                    Setup.check_args(n == 1);
                    Build.build_components(System.err, true);
                    break;
                }
                case "classpath": {
                    Setup.check_args(n == 1);
                    Setup.echo(Environment.join_standard_paths(Build.classpath()));
                    break;
                }
                case "gui_setup": {
                    Setup.check_args(n == 1);
                    String string2 = GUI_Setup.gui_setup();
                    if (string2 != null && !string2.isEmpty()) {
                        Setup.echo(string2);
                    }
                    break;
                }
                case "services": {
                    Setup.check_args(n == 1);
                    for (String string3 : Build.services()) {
                        Setup.echo(string3);
                    }
                    break;
                }
                default: {
                    Setup.fail("Bad setup operation " + Library.quote(string));
                }
            }
        }
        catch (Throwable throwable) {
            Setup.echo_err(Exn.print_error(throwable));
            System.exit(Exn.failure_rc(throwable));
        }
    }
}

