{- generated by Isabelle -}

{-  Title:      Isabelle/Markup.hs
    Author:     Makarius
    LICENSE:    BSD 3-clause (Isabelle)

Quasi-abstract markup elements.

See "$ISABELLE_HOME/src/Pure/PIDE/markup.ML".
-}

{-# LANGUAGE OverloadedStrings #-}
{-# OPTIONS_GHC -fno-warn-missing-signatures #-}

module Isabelle.Markup (
  T, empty, is_empty, properties,

  nameN, name, xnameN, xname, kindN,

  bindingN, binding, entityN, entity, defN, refN,

  completionN, completion, no_completionN, no_completion,

  lineN, end_lineN, offsetN, end_offsetN, labelN, fileN, idN, positionN, position,
  position_properties, def_name,

  expressionN, expression,

  pathN, path, urlN, url, docN, doc,

  markupN, consistentN, unbreakableN, indentN, widthN,
  blockN, block, breakN, break, fbreakN, fbreak, itemN, item,

  wordsN, words,

  tfreeN, tfree, tvarN, tvar, freeN, free, skolemN, skolem, boundN, bound, varN, var,
  numeralN, numeral, literalN, literal, delimiterN, delimiter, inner_stringN, inner_string,
  inner_cartoucheN, inner_cartouche,
  token_rangeN, token_range,
  sortingN, sorting, typingN, typing, class_parameterN, class_parameter,

  antiquotedN, antiquoted, antiquoteN, antiquote,

  paragraphN, paragraph, text_foldN, text_fold,

  keyword1N, keyword1, keyword2N, keyword2, keyword3N, keyword3, quasi_keywordN, quasi_keyword,
  improperN, improper, operatorN, operator, stringN, string, alt_stringN, alt_string,
  verbatimN, verbatim, cartoucheN, cartouche, commentN, comment, comment1N, comment1,
  comment2N, comment2, comment3N, comment3,

  forkedN, forked, joinedN, joined, runningN, running, finishedN, finished,
  failedN, failed, canceledN, canceled, initializedN, initialized, finalizedN, finalized,
  consolidatingN, consolidating, consolidatedN, consolidated,

  writelnN, writeln, stateN, state, informationN, information, tracingN, tracing,
  warningN, warning, legacyN, legacy, errorN, error, reportN, report, no_reportN, no_report,

  intensifyN, intensify,
  Output, no_output)
where

import Prelude hiding (words, error, break)
import Data.Map.Strict (Map)
import qualified Data.Map.Strict as Map

import Isabelle.Library
import qualified Isabelle.Properties as Properties
import qualified Isabelle.Value as Value
import qualified Isabelle.Bytes as Bytes
import Isabelle.Bytes (Bytes)


{- basic markup -}

type T = (Bytes, Properties.T)

empty :: T
empty = ("", [])

is_empty :: T -> Bool
is_empty ("", _) = True
is_empty _ = False

properties :: Properties.T -> T -> T
properties more_props (elem, props) =
  (elem, fold_rev Properties.put more_props props)

markup_elem :: Bytes -> T
markup_elem name = (name, [])

markup_string :: Bytes -> Bytes -> Bytes -> T
markup_string name prop = \s -> (name, [(prop, s)])


{- misc properties -}

nameN :: Bytes
nameN = "name"

name :: Bytes -> T -> T
name a = properties [(nameN, a)]

xnameN :: Bytes
xnameN = "xname"

xname :: Bytes -> T -> T
xname a = properties [(xnameN, a)]

kindN :: Bytes
kindN = "kind"


{- formal entities -}

bindingN :: Bytes
bindingN = "binding"
binding :: T
binding = markup_elem bindingN

entityN :: Bytes
entityN = "entity"
entity :: Bytes -> Bytes -> T
entity kind name =
  (entityN,
    (if Bytes.null name then [] else [(nameN, name)]) <>
    (if Bytes.null kind then [] else [(kindN, kind)]))

defN :: Bytes
defN = "def"

refN :: Bytes
refN = "ref"


{- completion -}

completionN :: Bytes
completionN = "completion"
completion :: T
completion = markup_elem completionN

no_completionN :: Bytes
no_completionN = "no_completion"
no_completion :: T
no_completion = markup_elem no_completionN


{- position -}

lineN, end_lineN :: Bytes
lineN = "line"
end_lineN = "end_line"

offsetN, end_offsetN :: Bytes
offsetN = "offset"
end_offsetN = "end_offset"

labelN, fileN, idN :: Bytes
labelN = "label"
fileN = "file"
idN = "id"

positionN :: Bytes
positionN = "position"
position :: T
position = markup_elem positionN

position_properties :: [Bytes]
position_properties = [lineN, offsetN, end_offsetN, labelN, fileN, idN]


{- position "def" names -}

make_def :: Bytes -> Bytes
make_def a = "def_" <> a

def_names :: Map Bytes Bytes
def_names = Map.fromList $ map (\a -> (a, make_def a)) position_properties

def_name :: Bytes -> Bytes
def_name a =
  case Map.lookup a def_names of
    Just b -> b
    Nothing -> make_def a


{- expression -}

expressionN :: Bytes
expressionN = "expression"

expression :: Bytes -> T
expression kind = (expressionN, if kind == "" then [] else [(kindN, kind)])


{- external resources -}

pathN :: Bytes
pathN = "path"
path :: Bytes -> T
path = markup_string pathN nameN

urlN :: Bytes
urlN = "url"
url :: Bytes -> T
url = markup_string urlN nameN

docN :: Bytes
docN = "doc"
doc :: Bytes -> T
doc = markup_string docN nameN


{- pretty printing -}

markupN, consistentN, unbreakableN, indentN :: Bytes
markupN = "markup"
consistentN = "consistent"
unbreakableN = "unbreakable"
indentN = "indent"

widthN :: Bytes
widthN = "width"

blockN :: Bytes
blockN = "block"
block :: Bool -> Int -> T
block c i =
  (blockN,
    (if c then [(consistentN, Value.print_bool c)] else []) <>
    (if i /= 0 then [(indentN, Value.print_int i)] else []))

breakN :: Bytes
breakN = "break"
break :: Int -> Int -> T
break w i =
  (breakN,
    (if w /= 0 then [(widthN, Value.print_int w)] else []) <>
    (if i /= 0 then [(indentN, Value.print_int i)] else []))

fbreakN :: Bytes
fbreakN = "fbreak"
fbreak :: T
fbreak = markup_elem fbreakN

itemN :: Bytes
itemN = "item"
item :: T
item = markup_elem itemN


{- text properties -}

wordsN :: Bytes
wordsN = "words"
words :: T
words = markup_elem wordsN


{- inner syntax -}

tfreeN :: Bytes
tfreeN = "tfree"
tfree :: T
tfree = markup_elem tfreeN

tvarN :: Bytes
tvarN = "tvar"
tvar :: T
tvar = markup_elem tvarN

freeN :: Bytes
freeN = "free"
free :: T
free = markup_elem freeN

skolemN :: Bytes
skolemN = "skolem"
skolem :: T
skolem = markup_elem skolemN

boundN :: Bytes
boundN = "bound"
bound :: T
bound = markup_elem boundN

varN :: Bytes
varN = "var"
var :: T
var = markup_elem varN

numeralN :: Bytes
numeralN = "numeral"
numeral :: T
numeral = markup_elem numeralN

literalN :: Bytes
literalN = "literal"
literal :: T
literal = markup_elem literalN

delimiterN :: Bytes
delimiterN = "delimiter"
delimiter :: T
delimiter = markup_elem delimiterN

inner_stringN :: Bytes
inner_stringN = "inner_string"
inner_string :: T
inner_string = markup_elem inner_stringN

inner_cartoucheN :: Bytes
inner_cartoucheN = "inner_cartouche"
inner_cartouche :: T
inner_cartouche = markup_elem inner_cartoucheN


token_rangeN :: Bytes
token_rangeN = "token_range"
token_range :: T
token_range = markup_elem token_rangeN


sortingN :: Bytes
sortingN = "sorting"
sorting :: T
sorting = markup_elem sortingN

typingN :: Bytes
typingN = "typing"
typing :: T
typing = markup_elem typingN

class_parameterN :: Bytes
class_parameterN = "class_parameter"
class_parameter :: T
class_parameter = markup_elem class_parameterN


{- antiquotations -}

antiquotedN :: Bytes
antiquotedN = "antiquoted"
antiquoted :: T
antiquoted = markup_elem antiquotedN

antiquoteN :: Bytes
antiquoteN = "antiquote"
antiquote :: T
antiquote = markup_elem antiquoteN


{- text structure -}

paragraphN :: Bytes
paragraphN = "paragraph"
paragraph :: T
paragraph = markup_elem paragraphN

text_foldN :: Bytes
text_foldN = "text_fold"
text_fold :: T
text_fold = markup_elem text_foldN


{- outer syntax -}

keyword1N :: Bytes
keyword1N = "keyword1"
keyword1 :: T
keyword1 = markup_elem keyword1N

keyword2N :: Bytes
keyword2N = "keyword2"
keyword2 :: T
keyword2 = markup_elem keyword2N

keyword3N :: Bytes
keyword3N = "keyword3"
keyword3 :: T
keyword3 = markup_elem keyword3N

quasi_keywordN :: Bytes
quasi_keywordN = "quasi_keyword"
quasi_keyword :: T
quasi_keyword = markup_elem quasi_keywordN

improperN :: Bytes
improperN = "improper"
improper :: T
improper = markup_elem improperN

operatorN :: Bytes
operatorN = "operator"
operator :: T
operator = markup_elem operatorN

stringN :: Bytes
stringN = "string"
string :: T
string = markup_elem stringN

alt_stringN :: Bytes
alt_stringN = "alt_string"
alt_string :: T
alt_string = markup_elem alt_stringN

verbatimN :: Bytes
verbatimN = "verbatim"
verbatim :: T
verbatim = markup_elem verbatimN

cartoucheN :: Bytes
cartoucheN = "cartouche"
cartouche :: T
cartouche = markup_elem cartoucheN

commentN :: Bytes
commentN = "comment"
comment :: T
comment = markup_elem commentN


{- comments -}

comment1N :: Bytes
comment1N = "comment1"
comment1 :: T
comment1 = markup_elem comment1N

comment2N :: Bytes
comment2N = "comment2"
comment2 :: T
comment2 = markup_elem comment2N

comment3N :: Bytes
comment3N = "comment3"
comment3 :: T
comment3 = markup_elem comment3N


{- command status -}

forkedN, joinedN, runningN, finishedN, failedN, canceledN,
  initializedN, finalizedN, consolidatingN, consolidatedN :: Bytes
forkedN = "forked"
joinedN = "joined"
runningN = "running"
finishedN = "finished"
failedN = "failed"
canceledN = "canceled"
initializedN = "initialized"
finalizedN = "finalized"
consolidatingN = "consolidating"
consolidatedN = "consolidated"

forked, joined, running, finished, failed, canceled,
  initialized, finalized, consolidating, consolidated :: T
forked = markup_elem forkedN
joined = markup_elem joinedN
running = markup_elem runningN
finished = markup_elem finishedN
failed = markup_elem failedN
canceled = markup_elem canceledN
initialized = markup_elem initializedN
finalized = markup_elem finalizedN
consolidating = markup_elem consolidatingN
consolidated = markup_elem consolidatedN


{- messages -}

writelnN :: Bytes
writelnN = "writeln"
writeln :: T
writeln = markup_elem writelnN

stateN :: Bytes
stateN = "state"
state :: T
state = markup_elem stateN

informationN :: Bytes
informationN = "information"
information :: T
information = markup_elem informationN

tracingN :: Bytes
tracingN = "tracing"
tracing :: T
tracing = markup_elem tracingN

warningN :: Bytes
warningN = "warning"
warning :: T
warning = markup_elem warningN

legacyN :: Bytes
legacyN = "legacy"
legacy :: T
legacy = markup_elem legacyN

errorN :: Bytes
errorN = "error"
error :: T
error = markup_elem errorN

reportN :: Bytes
reportN = "report"
report :: T
report = markup_elem reportN

no_reportN :: Bytes
no_reportN = "no_report"
no_report :: T
no_report = markup_elem no_reportN

intensifyN :: Bytes
intensifyN = "intensify"
intensify :: T
intensify = markup_elem intensifyN


{- output -}

type Output = (Bytes, Bytes)

no_output :: Output
no_output = ("", "")
