/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.ints;

public abstract class IntRange {
    private IntRange() {
    }

    public abstract int min();

    public abstract int max();

    public int size() {
        return this.max() - this.min() + 1;
    }

    public boolean contains(int n) {
        return n >= this.min() && n <= this.max();
    }

    public boolean contains(IntRange intRange) {
        return this.min() <= intRange.min() && intRange.max() <= this.max();
    }

    public boolean intersects(IntRange intRange) {
        return this.contains(intRange.min()) || this.contains(intRange.max());
    }

    public boolean equals(Object object) {
        if (object instanceof IntRange) {
            IntRange intRange = (IntRange)object;
            return this.min() == intRange.min() && this.max() == intRange.max();
        }
        return false;
    }

    public int hashCode() {
        return this.min() == this.max() ? this.min() : this.min() ^ this.max();
    }

    public String toString() {
        return "[" + this.min() + ".." + this.max() + "]";
    }

    static final class TwoPointRange
    extends IntRange {
        private final int min;
        private final int max;

        TwoPointRange(int n, int n2) {
            assert (n < n2);
            this.min = n;
            this.max = n2;
        }

        @Override
        public final int min() {
            return this.min;
        }

        @Override
        public final int max() {
            return this.max;
        }
    }

    static final class OnePointRange
    extends IntRange {
        private final int min;

        OnePointRange(int n) {
            this.min = n;
        }

        @Override
        public final int min() {
            return this.min;
        }

        @Override
        public final int max() {
            return this.min;
        }
    }
}

