/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.collections;

import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kodkod.util.collections.Stack;

public final class LinkedStack<T>
extends Stack<T> {
    private StackEntry<T> head = null;
    private int size = 0;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public T push(T t) {
        this.head = new StackEntry<T>(t, this.head);
        ++this.size;
        return t;
    }

    @Override
    public T pop() {
        if (this.head == null) {
            throw new EmptyStackException();
        }
        Object t = this.head.data;
        this.head = this.head.next;
        --this.size;
        return t;
    }

    @Override
    public T peek() {
        if (this.head == null) {
            throw new EmptyStackException();
        }
        return this.head.data;
    }

    @Override
    public int search(Object object) {
        StackEntry<T> stackEntry = this.head;
        int n = 1;
        while (stackEntry != null) {
            if (LinkedStack.equal(object, stackEntry.data)) {
                return n;
            }
            stackEntry = stackEntry.next;
            ++n;
        }
        return -1;
    }

    @Override
    public boolean empty() {
        return this.head == null;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private StackEntry<T> cursor;
            private StackEntry<T> prev;
            private StackEntry<T> pprev;
            {
                this.cursor = LinkedStack.this.head;
                this.prev = null;
                this.pprev = null;
            }

            @Override
            public boolean hasNext() {
                return this.cursor != null;
            }

            @Override
            public T next() {
                if (this.cursor == null) {
                    throw new NoSuchElementException();
                }
                this.pprev = this.prev;
                this.prev = this.cursor;
                this.cursor = this.cursor.next;
                return this.prev.data;
            }

            @Override
            public void remove() {
                if (this.prev == this.pprev) {
                    throw new UnsupportedOperationException();
                }
                if (this.prev == LinkedStack.this.head) {
                    LinkedStack.this.head = this.cursor;
                } else {
                    this.pprev.next = this.cursor;
                    this.prev.next = null;
                }
                this.prev = this.pprev;
                LinkedStack.this.size--;
            }
        };
    }

    private static final class StackEntry<T> {
        T data;
        StackEntry<T> next;

        StackEntry(T t, StackEntry<T> stackEntry) {
            this.data = t;
            this.next = stackEntry;
        }
    }
}

