/*
 * Decompiled with CFR 0.152.
 */
package kodkod.instance;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kodkod.ast.Relation;
import kodkod.instance.TupleSet;
import kodkod.instance.Universe;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.Ints;
import kodkod.util.ints.SparseSequence;
import kodkod.util.ints.TreeSequence;

public final class Instance
implements Cloneable {
    private final Map<Relation, TupleSet> tuples;
    private final SparseSequence<TupleSet> ints;
    private final Universe universe;

    private Instance(Universe universe, Map<Relation, TupleSet> map, SparseSequence<TupleSet> sparseSequence) {
        this.universe = universe;
        this.tuples = map;
        this.ints = sparseSequence;
    }

    public Instance(Universe universe) {
        if (universe == null) {
            throw new NullPointerException("universe=null");
        }
        this.universe = universe;
        this.tuples = new LinkedHashMap<Relation, TupleSet>();
        this.ints = new TreeSequence<TupleSet>();
    }

    public Universe universe() {
        return this.universe;
    }

    public boolean contains(Relation relation) {
        return this.tuples.containsKey(relation);
    }

    public boolean contains(int n) {
        return this.ints.containsIndex(n);
    }

    public Set<Relation> relations() {
        return this.tuples.keySet();
    }

    public IntSet ints() {
        return this.ints.indices();
    }

    public void add(Relation relation, TupleSet tupleSet) {
        if (!tupleSet.universe().equals(this.universe)) {
            throw new IllegalArgumentException("s.universe!=this.universe");
        }
        if (relation.arity() != tupleSet.arity()) {
            throw new IllegalArgumentException("relation.arity!=s.arity");
        }
        this.tuples.put(relation, tupleSet.clone().unmodifiableView());
    }

    public void add(int n, TupleSet tupleSet) {
        if (!tupleSet.universe().equals(this.universe)) {
            throw new IllegalArgumentException("s.universe!=this.universe");
        }
        if (tupleSet.arity() != 1) {
            throw new IllegalArgumentException("s.arity!=1: " + tupleSet);
        }
        if (tupleSet.size() != 1) {
            throw new IllegalArgumentException("s.size()!=1: " + tupleSet);
        }
        this.ints.put(n, tupleSet.clone().unmodifiableView());
    }

    public TupleSet tuples(Relation relation) {
        return this.tuples.get(relation);
    }

    public Map<Relation, TupleSet> relationTuples() {
        return Collections.unmodifiableMap(this.tuples);
    }

    public TupleSet tuples(int n) {
        return this.ints.get(n);
    }

    public SparseSequence<TupleSet> intTuples() {
        return Ints.unmodifiableSequence(this.ints);
    }

    public Instance unmodifiableView() {
        return new Instance(this.universe, Collections.unmodifiableMap(this.tuples), Ints.unmodifiableSequence(this.ints));
    }

    public Instance clone() {
        try {
            return new Instance(this.universe, new LinkedHashMap<Relation, TupleSet>(this.tuples), this.ints.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return "relations: " + this.tuples.toString() + "\nints: " + this.ints;
    }
}

