/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.ucore;

import kodkod.engine.fol2sat.TranslationLog;
import kodkod.engine.satlab.ReductionStrategy;
import kodkod.engine.satlab.ResolutionTrace;
import kodkod.engine.ucore.StrategyUtils;
import kodkod.util.ints.IntCollection;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.IntTreeSet;
import kodkod.util.ints.Ints;

public final class NCEStrategy
implements ReductionStrategy {
    private final IntCollection varsToTry;
    private final IntSet coreVars;

    public NCEStrategy(TranslationLog translationLog) {
        this.varsToTry = StrategyUtils.rootVars(translationLog);
        this.coreVars = new IntTreeSet();
        this.coreVars.addAll(this.varsToTry);
    }

    @Override
    public IntSet next(ResolutionTrace resolutionTrace) {
        if (this.varsToTry.isEmpty()) {
            return Ints.EMPTY_SET;
        }
        this.coreVars.addAll(StrategyUtils.coreTailUnits(resolutionTrace));
        int n = this.varsToTry.iterator().next();
        this.varsToTry.remove(n);
        this.coreVars.remove(n);
        IntSet intSet = StrategyUtils.clausesFor(resolutionTrace, this.coreVars);
        assert (!intSet.isEmpty() && !intSet.contains(resolutionTrace.size() - 1));
        return intSet;
    }
}

