/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.satlab;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.BitSet;
import kodkod.engine.satlab.SATAbortedException;
import kodkod.engine.satlab.SATSolver;

final class ExternalSolver
implements SATSolver {
    private final StringBuilder buffer;
    private final int capacity = 8192;
    private final boolean deleteTemp;
    private final String executable;
    private final String inTemp;
    private final String[] options;
    private final RandomAccessFile cnf;
    private final BitSet solution;
    private volatile Boolean sat;
    private volatile int vars;
    private volatile int clauses;

    ExternalSolver(String string, String string2, boolean bl, String ... stringArray) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string2, "rw");
            randomAccessFile.setLength(0L);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SATAbortedException(fileNotFoundException);
        }
        catch (IOException iOException) {
            ExternalSolver.close(randomAccessFile);
            throw new SATAbortedException(iOException);
        }
        this.deleteTemp = bl;
        this.cnf = randomAccessFile;
        this.buffer = new StringBuilder();
        for (int i = ExternalSolver.headerLength(); i > 0; --i) {
            this.buffer.append(" ");
        }
        this.buffer.append("\n");
        this.sat = null;
        this.solution = new BitSet();
        this.vars = 0;
        this.clauses = 0;
        this.executable = string;
        this.inTemp = string2;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string3 : stringArray) {
            if (string3.isEmpty()) continue;
            arrayList.add(string3);
        }
        this.options = arrayList.toArray(new String[arrayList.size()]);
    }

    private static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static final int headerLength() {
        return String.valueOf(Integer.MAX_VALUE).length() * 2 + 8;
    }

    private final void flush() {
        try {
            this.cnf.writeBytes(this.buffer.toString());
        }
        catch (IOException iOException) {
            ExternalSolver.close(this.cnf);
            throw new SATAbortedException(iOException);
        }
        finally {
            this.buffer.setLength(0);
        }
    }

    @Override
    public boolean addClause(int[] nArray) {
        if (nArray.length > 0) {
            ++this.clauses;
            if (this.buffer.length() > 8192) {
                this.flush();
            }
            for (int n : nArray) {
                this.buffer.append(n);
                this.buffer.append(" ");
            }
            this.buffer.append("0\n");
            return true;
        }
        return false;
    }

    @Override
    public void addVariables(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("vars < 0: " + n);
        }
        this.vars += n;
    }

    @Override
    public synchronized void free() {
        ExternalSolver.close(this.cnf);
        if (this.deleteTemp) {
            new File(this.inTemp).delete();
        }
    }

    protected final void finalize() throws Throwable {
        super.finalize();
        this.free();
    }

    @Override
    public int numberOfClauses() {
        return this.clauses;
    }

    @Override
    public int numberOfVariables() {
        return this.vars;
    }

    private final void updateSolution(int n) {
        int n2 = StrictMath.abs(n);
        if (n2 > this.vars || n2 <= 0) {
            throw new SATAbortedException("Invalid variable value: |" + n + "| !in [1.." + this.vars + "]");
        }
        this.solution.set(n2 - 1, n > 0);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean solve() throws SATAbortedException {
        if (this.sat != null) return this.sat;
        this.flush();
        Process process = null;
        BufferedReader bufferedReader = null;
        try {
            this.cnf.seek(0L);
            this.cnf.writeBytes("p cnf " + this.vars + " " + this.clauses);
            this.cnf.close();
            String[] stringArray = new String[this.options.length + 2];
            stringArray[0] = this.executable;
            System.arraycopy(this.options, 0, stringArray, 1, this.options.length);
            stringArray[stringArray.length - 1] = this.inTemp;
            process = Runtime.getRuntime().exec(stringArray);
            new Thread(ExternalSolver.drain(process.getErrorStream())).start();
            bufferedReader = this.outputReader(process);
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                String[] stringArray2 = string.split("\\s");
                int n2 = stringArray2.length;
                if (n2 <= 0) continue;
                if (stringArray2[0].compareToIgnoreCase("s") == 0) {
                    if (n2 != 2) throw new SATAbortedException("Invalid " + this.executable + " output. Line: " + string);
                    if (stringArray2[1].compareToIgnoreCase("SATISFIABLE") == 0) {
                        this.sat = Boolean.TRUE;
                        continue;
                    }
                    if (stringArray2[1].compareToIgnoreCase("UNSATISFIABLE") != 0) throw new SATAbortedException("Invalid " + this.executable + " output. Line: " + string);
                    this.sat = Boolean.FALSE;
                    continue;
                }
                if (stringArray2[0].compareToIgnoreCase("v") != 0) continue;
                int n3 = n2 - 1;
                for (n = 1; n < n3; ++n) {
                    this.updateSolution(Integer.parseInt(stringArray2[n]));
                }
                n = Integer.parseInt(stringArray2[n3]);
                if (n != 0) {
                    this.updateSolution(n);
                    continue;
                }
                if (this.sat == null) continue;
            }
            if (this.sat == null) {
                throw new SATAbortedException("Invalid " + this.executable + " output: no line specifying the outcome.");
            }
        }
        catch (IOException iOException) {
            try {
                throw new SATAbortedException(iOException);
                catch (NumberFormatException numberFormatException) {
                    throw new SATAbortedException("Invalid " + this.executable + " output: encountered a non-integer variable token.", numberFormatException);
                }
            }
            catch (Throwable throwable) {
                ExternalSolver.close(bufferedReader);
                throw throwable;
            }
        }
        ExternalSolver.close(bufferedReader);
        return this.sat;
    }

    private static Runnable drain(final InputStream inputStream) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int n;
                    byte[] byArray = new byte[8192];
                    while ((n = inputStream.read(byArray)) >= 0) {
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    ExternalSolver.close(inputStream);
                }
            }
        };
    }

    private BufferedReader outputReader(Process process) throws IOException {
        try {
            return new BufferedReader(new InputStreamReader(process.getInputStream(), "ISO-8859-1"));
        }
        catch (IOException iOException) {
            ExternalSolver.close(process.getInputStream());
            throw iOException;
        }
    }

    @Override
    public boolean valueOf(int n) {
        if (!Boolean.TRUE.equals(this.sat)) {
            throw new IllegalStateException();
        }
        if (n < 1 || n > this.vars) {
            throw new IllegalArgumentException(n + " !in [1.." + this.vars + "]");
        }
        return this.solution.get(n - 1);
    }

    public String toString() {
        return this.executable + " " + this.options;
    }
}

