/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.fol2sat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kodkod.ast.Relation;
import kodkod.instance.Bounds;
import kodkod.instance.TupleSet;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.Ints;

final class SymmetryDetector {
    private final Bounds bounds;
    private final List<IntSet> parts;
    private final int usize;

    private SymmetryDetector(Bounds bounds) {
        this.bounds = bounds;
        this.usize = bounds.universe().size();
        this.parts = new LinkedList<IntSet>();
        IntSet intSet = Ints.bestSet(this.usize);
        for (int i = 0; i < this.usize; ++i) {
            intSet.add(i);
        }
        this.parts.add(intSet);
    }

    static Set<IntSet> partition(Bounds bounds) {
        SymmetryDetector symmetryDetector = new SymmetryDetector(bounds);
        symmetryDetector.computePartitions();
        LinkedHashSet<IntSet> linkedHashSet = new LinkedHashSet<IntSet>(symmetryDetector.parts);
        assert (linkedHashSet.size() == symmetryDetector.parts.size());
        return linkedHashSet;
    }

    private final void computePartitions() {
        if (this.usize == 1) {
            return;
        }
        HashMap<IntSet, IntSet> hashMap = new HashMap<IntSet, IntSet>(this.usize * 2 / 3);
        TupleSet[] tupleSetArray = this.bounds.ints().iterator();
        while (tupleSetArray.hasNext()) {
            TupleSet tupleSet = this.bounds.exactBound(tupleSetArray.next());
            this.refinePartitions(tupleSet.indexView(), 1, hashMap);
        }
        for (TupleSet tupleSet : SymmetryDetector.sort(this.bounds)) {
            if (this.parts.size() == this.usize) {
                return;
            }
            this.refinePartitions(tupleSet.indexView(), tupleSet.arity(), hashMap);
        }
    }

    private static TupleSet[] sort(Bounds bounds) {
        ArrayList<TupleSet> arrayList = new ArrayList<TupleSet>(bounds.relations().size());
        for (Relation relation : bounds.relations()) {
            TupleSet tupleSet = bounds.lowerBound(relation);
            TupleSet tupleSet2 = bounds.upperBound(relation);
            if (!tupleSet.isEmpty() && tupleSet.size() < tupleSet2.size()) {
                arrayList.add(tupleSet);
            }
            if (tupleSet2.isEmpty()) continue;
            arrayList.add(tupleSet2);
        }
        TupleSet[] tupleSetArray = arrayList.toArray(new TupleSet[arrayList.size()]);
        Arrays.sort(tupleSetArray, new Comparator<TupleSet>(){

            @Override
            public int compare(TupleSet tupleSet, TupleSet tupleSet2) {
                return tupleSet.size() - tupleSet2.size();
            }
        });
        return tupleSetArray;
    }

    private void refinePartitions(IntSet intSet, int n, Map<IntSet, IntSet> map) {
        if (n == 1) {
            this.refinePartitions(intSet);
            return;
        }
        LinkedList linkedList = new LinkedList();
        int n2 = (int)StrictMath.pow(this.usize, n - 1);
        IntSet intSet2 = Ints.bestSet(this.usize);
        IntIterator intIterator = intSet.iterator();
        while (intIterator.hasNext()) {
            intSet2.add(intIterator.next() / n2);
        }
        this.refinePartitions(intSet2);
        int n3 = (1 - n2) / (1 - this.usize);
        Iterator<IntSet> iterator = this.parts.listIterator();
        while (iterator.hasNext()) {
            IntSet intSet3 = iterator.next();
            if (!intSet2.contains(intSet3.min())) continue;
            map.clear();
            Object object = intSet3.iterator();
            while (object.hasNext()) {
                int n4 = object.next();
                Map.Entry<IntSet, IntSet> entry = Ints.bestSet(n2);
                Object object2 = intSet.iterator(n4 * n2, (n4 + 1) * n2 - 1);
                while (object2.hasNext()) {
                    entry.add(object2.next() % n2);
                }
                object2 = map.get(entry);
                if (object2 != null) {
                    object2.add(n4);
                    continue;
                }
                map.put((IntSet)((Object)entry), SymmetryDetector.oneOf(this.usize, n4));
            }
            iterator.remove();
            object = Ints.bestSet(this.usize);
            for (Map.Entry<IntSet, IntSet> entry : map.entrySet()) {
                if (((IntSet)entry.getValue()).size() == 1 && ((IntSet)entry.getKey()).size() == 1 && ((IntSet)entry.getKey()).min() == ((IntSet)entry.getValue()).min() * n3) {
                    object.add(((IntSet)entry.getValue()).min());
                    continue;
                }
                iterator.add((IntSet)entry.getValue());
                linkedList.add(entry.getKey());
            }
            if (object.isEmpty()) continue;
            iterator.add((IntSet)object);
        }
        for (IntSet intSet3 : linkedList) {
            this.refinePartitions(intSet3, n - 1, map);
        }
    }

    private void refinePartitions(IntSet intSet) {
        ListIterator<IntSet> listIterator = this.parts.listIterator();
        while (listIterator.hasNext()) {
            IntSet intSet2 = listIterator.next();
            IntSet intSet3 = Ints.bestSet(intSet2.min(), intSet2.max());
            intSet3.addAll(intSet2);
            intSet3.retainAll(intSet);
            if (intSet3.isEmpty() || intSet3.size() >= intSet2.size()) continue;
            intSet2.removeAll(intSet3);
            listIterator.add(intSet3);
        }
    }

    private static final IntSet oneOf(int n, int n2) {
        IntSet intSet = Ints.bestSet(n);
        intSet.add(n2);
        return intSet;
    }
}

