/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.fol2sat;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import kodkod.ast.ConstantExpression;
import kodkod.ast.Expression;
import kodkod.ast.Relation;
import kodkod.engine.bool.BooleanFactory;
import kodkod.engine.bool.BooleanMatrix;
import kodkod.engine.bool.Dimensions;
import kodkod.engine.config.Options;
import kodkod.engine.fol2sat.UnboundLeafException;
import kodkod.instance.Bounds;
import kodkod.instance.Instance;
import kodkod.instance.TupleSet;
import kodkod.instance.Universe;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntRange;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.Ints;
import kodkod.util.ints.SparseSequence;

final class LeafInterpreter {
    private final BooleanFactory factory;
    private final Universe universe;
    private final Map<Relation, IntRange> vars;
    private final Map<Relation, TupleSet> lowers;
    private final Map<Relation, TupleSet> uppers;
    private final SparseSequence<TupleSet> ints;

    private LeafInterpreter(Universe universe, Map<Relation, TupleSet> map, Map<Relation, TupleSet> map2, SparseSequence<TupleSet> sparseSequence, BooleanFactory booleanFactory, Map<Relation, IntRange> map3) {
        this.universe = universe;
        this.lowers = map;
        this.uppers = map2;
        this.ints = sparseSequence;
        this.factory = booleanFactory;
        this.vars = map3;
    }

    private LeafInterpreter(Universe universe, Map<Relation, TupleSet> map, SparseSequence<TupleSet> sparseSequence, Options options) {
        this(universe, map, map, sparseSequence, BooleanFactory.constantFactory(options), Collections.EMPTY_MAP);
    }

    static final LeafInterpreter exact(Instance instance, Options options) {
        return new LeafInterpreter(instance.universe(), instance.relationTuples(), instance.intTuples(), options);
    }

    static final LeafInterpreter exact(Bounds bounds, Options options) {
        LinkedHashMap<Relation, IntRange> linkedHashMap = new LinkedHashMap<Relation, IntRange>();
        int n = 1;
        for (Relation relation : bounds.relations()) {
            int n2 = bounds.upperBound(relation).size() - bounds.lowerBound(relation).size();
            if (n2 <= 0) continue;
            linkedHashMap.put(relation, Ints.range(n, n + n2 - 1));
            n += n2;
        }
        return new LeafInterpreter(bounds.universe(), bounds.lowerBounds(), bounds.upperBounds(), bounds.intBounds(), BooleanFactory.factory(n - 1, options), linkedHashMap);
    }

    static final LeafInterpreter overapproximating(Bounds bounds, Options options) {
        return new LeafInterpreter(bounds.universe(), bounds.upperBounds(), bounds.intBounds(), options);
    }

    public final BooleanFactory factory() {
        return this.factory;
    }

    public final Universe universe() {
        return this.universe;
    }

    public final Map<Relation, IntSet> vars() {
        LinkedHashMap<Relation, IntSet> linkedHashMap = new LinkedHashMap<Relation, IntSet>(this.vars.size() * 4 / 3);
        for (Map.Entry<Relation, IntRange> entry : this.vars.entrySet()) {
            linkedHashMap.put(entry.getKey(), Ints.rangeSet(entry.getValue()));
        }
        return linkedHashMap;
    }

    public final BooleanMatrix interpret(Relation relation) {
        if (!this.lowers.containsKey(relation)) {
            throw new UnboundLeafException("Unbound relation: ", relation);
        }
        IntSet intSet = this.lowers.get(relation).indexView();
        IntSet intSet2 = this.uppers.get(relation).indexView();
        BooleanMatrix booleanMatrix = this.factory.matrix(Dimensions.square(this.universe().size(), relation.arity()), intSet2, intSet);
        if (intSet2.size() > intSet.size()) {
            int n = this.vars.get(relation).min();
            IntIterator intIterator = intSet2.iterator();
            while (intIterator.hasNext()) {
                int n2 = intIterator.next();
                if (intSet.contains(n2)) continue;
                booleanMatrix.set(n2, this.factory.variable(n++));
            }
        }
        return booleanMatrix;
    }

    public final BooleanMatrix interpret(ConstantExpression constantExpression) {
        int n = this.universe().size();
        if (constantExpression == Expression.UNIV) {
            IntSet intSet = Ints.rangeSet(Ints.range(0, n - 1));
            return this.factory().matrix(Dimensions.square(n, 1), intSet, intSet);
        }
        if (constantExpression == Expression.IDEN) {
            Dimensions dimensions = Dimensions.square(n, 2);
            IntSet intSet = Ints.bestSet(dimensions.capacity());
            for (int i = 0; i < n; ++i) {
                intSet.add(i * n + i);
            }
            return this.factory().matrix(dimensions, intSet, intSet);
        }
        if (constantExpression == Expression.NONE) {
            return this.factory().matrix(Dimensions.square(n, 1), Ints.EMPTY_SET, Ints.EMPTY_SET);
        }
        if (constantExpression == Expression.INTS) {
            IntSet intSet = Ints.bestSet(n);
            IntIterator intIterator = this.ints().iterator();
            while (intIterator.hasNext()) {
                intSet.add(this.interpret(intIterator.next()));
            }
            return this.factory().matrix(Dimensions.square(n, 1), intSet, intSet);
        }
        throw new IllegalArgumentException("unknown constant expression: " + constantExpression);
    }

    public final IntSet ints() {
        return this.ints.indices();
    }

    public final int interpret(int n) {
        return this.ints.get(n).indexView().min();
    }
}

