/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.bool;

import java.util.Iterator;
import java.util.Set;
import kodkod.engine.bool.BooleanFormula;
import kodkod.engine.bool.BooleanVisitor;
import kodkod.engine.bool.Operator;
import kodkod.util.collections.Containers;
import kodkod.util.ints.Ints;

public final class ITEGate
extends BooleanFormula {
    private final BooleanFormula[] inputs;
    private final int label;
    private final int hashcode;
    private final int labelhash;

    ITEGate(int n, int n2, BooleanFormula booleanFormula, BooleanFormula booleanFormula2, BooleanFormula booleanFormula3) {
        super(null);
        assert (n >= 0);
        this.label = n;
        this.labelhash = Ints.superFastHash(n);
        this.hashcode = n2;
        this.inputs = new BooleanFormula[3];
        this.inputs[0] = booleanFormula;
        this.inputs[1] = booleanFormula2;
        this.inputs[2] = booleanFormula3;
    }

    @Override
    int hash(Operator operator) {
        return this.labelhash;
    }

    @Override
    public Iterator<BooleanFormula> iterator() {
        return Containers.iterate(this.inputs);
    }

    @Override
    public int size() {
        return 3;
    }

    @Override
    public int label() {
        return this.label;
    }

    @Override
    public <T, A> T accept(BooleanVisitor<T, A> booleanVisitor, A a) {
        return booleanVisitor.visit(this, a);
    }

    public String toString() {
        return "(" + this.inputs[0] + "?" + this.inputs[1] + ":" + this.inputs[2] + ")";
    }

    public int hashCode() {
        return this.hashcode;
    }

    @Override
    public Operator op() {
        return Operator.ITE;
    }

    @Override
    public BooleanFormula input(int n) {
        if (n < 0 || n > 2) {
            throw new IndexOutOfBoundsException();
        }
        return this.inputs[n];
    }

    @Override
    int contains(Operator operator, int n, int n2) {
        assert (n2 > 0);
        if (n == this.label) {
            return 1;
        }
        if (operator != Operator.ITE || n2 < 3 || n > this.label || -n > this.label) {
            return -1;
        }
        return this.inputs[0].label() == n || this.inputs[1].label() == n || this.inputs[2].label() == n ? 3 : -3;
    }

    @Override
    void flatten(Operator operator, Set<BooleanFormula> set, int n) {
        assert (n > 0);
        if (operator == Operator.ITE && n > 2) {
            set.add(this.inputs[0]);
            set.add(this.inputs[1]);
            set.add(this.inputs[2]);
        } else {
            set.add(this);
        }
    }
}

