/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.bool;

import java.util.Collection;
import java.util.Iterator;
import kodkod.engine.bool.BooleanAccumulator;
import kodkod.engine.bool.BooleanConstant;
import kodkod.engine.bool.BooleanMatrix;
import kodkod.engine.bool.BooleanValue;
import kodkod.engine.bool.BooleanVariable;
import kodkod.engine.bool.CBCFactory;
import kodkod.engine.bool.Dimensions;
import kodkod.engine.bool.Int;
import kodkod.engine.bool.Operator;
import kodkod.engine.bool.TwosComplementInt;
import kodkod.engine.config.Options;
import kodkod.util.ints.IntSet;

public abstract class BooleanFactory {
    private static CBCFactory CONSTANT_FACTORY;
    private final CBCFactory circuits;
    final int bitwidth;

    private BooleanFactory(int n, int n2, int n3) {
        if (n == 0) {
            if (CONSTANT_FACTORY == null) {
                CONSTANT_FACTORY = new CBCFactory(0, 1);
            }
            this.circuits = CONSTANT_FACTORY;
        } else {
            this.circuits = new CBCFactory(n, 1 << n2);
        }
        this.bitwidth = n3;
    }

    public static BooleanFactory factory(int n, Options options) {
        switch (options.intEncoding()) {
            case TWOSCOMPLEMENT: {
                return new TwosComplementFactory(n, options.sharing(), options.bitwidth());
            }
        }
        throw new IllegalArgumentException("unknown encoding: " + (Object)((Object)options.intEncoding()));
    }

    public static BooleanFactory constantFactory(Options options) {
        return BooleanFactory.factory(0, options);
    }

    public final int comparisonDepth() {
        return Integer.numberOfTrailingZeros(this.circuits.cmpMax());
    }

    public final void setComparisonDepth(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("newDepth < 1: " + n);
        }
        this.circuits.setCmpMax(1 << n);
    }

    public final int bitwidth() {
        return this.bitwidth;
    }

    public abstract Options.IntEncoding intEncoding();

    public final boolean contains(BooleanValue booleanValue) {
        return this.circuits.canAssemble(booleanValue);
    }

    public final int numberOfVariables() {
        return this.circuits.numVars();
    }

    public final BooleanVariable variable(int n) {
        return this.circuits.variable(n);
    }

    public final BooleanValue not(BooleanValue booleanValue) {
        return booleanValue.negation();
    }

    public final BooleanValue and(BooleanValue booleanValue, BooleanValue booleanValue2) {
        return this.circuits.assemble(Operator.AND, booleanValue, booleanValue2);
    }

    public final BooleanValue or(BooleanValue booleanValue, BooleanValue booleanValue2) {
        return this.circuits.assemble(Operator.OR, booleanValue, booleanValue2);
    }

    public final BooleanValue xor(BooleanValue booleanValue, BooleanValue booleanValue2) {
        return this.circuits.assemble(booleanValue, booleanValue2.negation(), booleanValue2);
    }

    public final BooleanValue implies(BooleanValue booleanValue, BooleanValue booleanValue2) {
        return this.circuits.assemble(Operator.OR, booleanValue.negation(), booleanValue2);
    }

    public final BooleanValue iff(BooleanValue booleanValue, BooleanValue booleanValue2) {
        return this.circuits.assemble(booleanValue, booleanValue2, booleanValue2.negation());
    }

    public final BooleanValue ite(BooleanValue booleanValue, BooleanValue booleanValue2, BooleanValue booleanValue3) {
        return this.circuits.assemble(booleanValue, booleanValue2, booleanValue3);
    }

    public final BooleanValue sum(BooleanValue booleanValue, BooleanValue booleanValue2, BooleanValue booleanValue3) {
        return this.xor(booleanValue3, this.xor(booleanValue, booleanValue2));
    }

    public final BooleanValue carry(BooleanValue booleanValue, BooleanValue booleanValue2, BooleanValue booleanValue3) {
        return this.or(this.and(booleanValue, booleanValue2), this.and(booleanValue3, this.xor(booleanValue, booleanValue2)));
    }

    public final BooleanValue accumulate(BooleanAccumulator booleanAccumulator) {
        return this.circuits.assemble(booleanAccumulator);
    }

    public abstract Int integer(int var1);

    public abstract Int integer(int var1, BooleanValue var2);

    private Int sum(Iterator<BooleanValue> iterator, int n, int n2) {
        if (n > n2) {
            return this.integer(0);
        }
        if (n == n2) {
            return this.integer(1, iterator.next());
        }
        int n3 = (n + n2) / 2;
        Int intVal = this.sum(iterator, n, n3);
        Int intVal2 = this.sum(iterator, n3 + 1, n2);
        return intVal.plus(intVal2);
    }

    public final Int sum(Collection<BooleanValue> collection) {
        return this.sum(collection.iterator(), 0, collection.size() - 1);
    }

    public final void clear() {
        this.circuits.clear();
    }

    public final BooleanMatrix matrix(Dimensions dimensions) {
        if (dimensions == null) {
            throw new NullPointerException();
        }
        return new BooleanMatrix(dimensions, this);
    }

    private static void validate(IntSet intSet, Dimensions dimensions) {
        if (!(intSet.isEmpty() || dimensions.validate(intSet.min()) && dimensions.validate(intSet.max()))) {
            throw new IllegalArgumentException();
        }
    }

    public final BooleanMatrix matrix(Dimensions dimensions, IntSet intSet, IntSet intSet2) {
        assert (intSet.size() >= intSet2.size());
        BooleanFactory.validate(intSet, dimensions);
        BooleanFactory.validate(intSet2, dimensions);
        try {
            return new BooleanMatrix(dimensions, this, intSet, intSet2.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalArgumentException();
        }
    }

    private static final class TwosComplementFactory
    extends BooleanFactory {
        TwosComplementFactory(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        @Override
        public Options.IntEncoding intEncoding() {
            return Options.IntEncoding.TWOSCOMPLEMENT;
        }

        @Override
        public Int integer(int n) {
            return new TwosComplementInt(this, n, BooleanConstant.TRUE);
        }

        @Override
        public Int integer(int n, BooleanValue booleanValue) {
            return new TwosComplementInt(this, n, booleanValue);
        }
    }
}

