/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kodkod.ast.BinaryExpression;
import kodkod.ast.ComparisonFormula;
import kodkod.ast.ConstantExpression;
import kodkod.ast.ExprToIntCast;
import kodkod.ast.Formula;
import kodkod.ast.IntExpression;
import kodkod.ast.MultiplicityFormula;
import kodkod.ast.NaryExpression;
import kodkod.ast.Node;
import kodkod.ast.ProjectExpression;
import kodkod.ast.UnaryExpression;
import kodkod.ast.operator.ExprCastOperator;
import kodkod.ast.operator.ExprCompOperator;
import kodkod.ast.operator.ExprOperator;
import kodkod.ast.operator.Multiplicity;
import kodkod.ast.visitor.ReturnVisitor;
import kodkod.util.collections.Containers;

public abstract class Expression
extends Node {
    public static final Expression UNIV = new ConstantExpression("univ", 1);
    public static final Expression IDEN = new ConstantExpression("iden", 2);
    public static final Expression NONE = new ConstantExpression("none", 1);
    public static final Expression INTS = new ConstantExpression("ints", 1);

    Expression() {
    }

    public final Expression join(Expression expression) {
        return this.compose(ExprOperator.JOIN, expression);
    }

    public final Expression product(Expression expression) {
        return this.compose(ExprOperator.PRODUCT, expression);
    }

    public final Expression union(Expression expression) {
        return this.compose(ExprOperator.UNION, expression);
    }

    public final Expression difference(Expression expression) {
        return this.compose(ExprOperator.DIFFERENCE, expression);
    }

    public final Expression intersection(Expression expression) {
        return this.compose(ExprOperator.INTERSECTION, expression);
    }

    public final Expression override(Expression expression) {
        return this.compose(ExprOperator.OVERRIDE, expression);
    }

    public final Expression compose(ExprOperator exprOperator, Expression expression) {
        return new BinaryExpression(this, exprOperator, expression);
    }

    public static Expression union(Expression ... expressionArray) {
        return Expression.compose(ExprOperator.UNION, expressionArray);
    }

    public static Expression union(Collection<? extends Expression> collection) {
        return Expression.compose(ExprOperator.UNION, collection);
    }

    public static Expression intersection(Expression ... expressionArray) {
        return Expression.compose(ExprOperator.INTERSECTION, expressionArray);
    }

    public static Expression intersection(Collection<? extends Expression> collection) {
        return Expression.compose(ExprOperator.INTERSECTION, collection);
    }

    public static Expression product(Expression ... expressionArray) {
        return Expression.compose(ExprOperator.PRODUCT, expressionArray);
    }

    public static Expression product(Collection<? extends Expression> collection) {
        return Expression.compose(ExprOperator.PRODUCT, collection);
    }

    public static Expression override(Expression ... expressionArray) {
        return Expression.compose(ExprOperator.OVERRIDE, expressionArray);
    }

    public static Expression override(Collection<? extends Expression> collection) {
        return Expression.compose(ExprOperator.OVERRIDE, collection);
    }

    public static Expression compose(ExprOperator exprOperator, Expression ... expressionArray) {
        switch (expressionArray.length) {
            case 0: {
                throw new IllegalArgumentException("Expected at least one argument: " + Arrays.toString(expressionArray));
            }
            case 1: {
                return expressionArray[0];
            }
            case 2: {
                return new BinaryExpression(expressionArray[0], exprOperator, expressionArray[1]);
            }
        }
        return new NaryExpression(exprOperator, Containers.copy(expressionArray, new Expression[expressionArray.length]));
    }

    public static Expression compose(ExprOperator exprOperator, Collection<? extends Expression> collection) {
        switch (collection.size()) {
            case 0: {
                throw new IllegalArgumentException("Expected at least one argument: " + collection);
            }
            case 1: {
                return collection.iterator().next();
            }
            case 2: {
                Iterator<? extends Expression> iterator = collection.iterator();
                return new BinaryExpression(iterator.next(), exprOperator, iterator.next());
            }
        }
        return new NaryExpression(exprOperator, collection.toArray(new Expression[collection.size()]));
    }

    public final Expression transpose() {
        return this.apply(ExprOperator.TRANSPOSE);
    }

    public final Expression closure() {
        return this.apply(ExprOperator.CLOSURE);
    }

    public final Expression reflexiveClosure() {
        return this.apply(ExprOperator.REFLEXIVE_CLOSURE);
    }

    public final Expression apply(ExprOperator exprOperator) {
        return new UnaryExpression(exprOperator, this);
    }

    public final Expression project(IntExpression ... intExpressionArray) {
        return new ProjectExpression(this, intExpressionArray);
    }

    public final IntExpression count() {
        return this.apply(ExprCastOperator.CARDINALITY);
    }

    public final IntExpression sum() {
        return this.apply(ExprCastOperator.SUM);
    }

    public final IntExpression apply(ExprCastOperator exprCastOperator) {
        return new ExprToIntCast(this, exprCastOperator);
    }

    public final Formula eq(Expression expression) {
        return this.compare(ExprCompOperator.EQUALS, expression);
    }

    public final Formula in(Expression expression) {
        return this.compare(ExprCompOperator.SUBSET, expression);
    }

    public final Formula compare(ExprCompOperator exprCompOperator, Expression expression) {
        return new ComparisonFormula(this, exprCompOperator, expression);
    }

    public final Formula some() {
        return this.apply(Multiplicity.SOME);
    }

    public final Formula no() {
        return this.apply(Multiplicity.NO);
    }

    public final Formula one() {
        return this.apply(Multiplicity.ONE);
    }

    public final Formula lone() {
        return this.apply(Multiplicity.LONE);
    }

    public final Formula apply(Multiplicity multiplicity) {
        return new MultiplicityFormula(multiplicity, this);
    }

    public abstract int arity();

    public abstract <E, F, D, I> E accept(ReturnVisitor<E, F, D, I> var1);
}

