/*
 * Decompiled with CFR 0.152.
 */
package org.jedit.keymap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.jedit.keymap.Keymap;
import org.jedit.keymap.KeymapManagerImpl;

class KeymapImpl
implements Keymap {
    protected Properties props;
    protected final String name;
    private final File file;
    private boolean modified;

    KeymapImpl(String name, File file) {
        this.name = name;
        this.file = file;
        this.loadProperties();
    }

    protected InputStream getInputStream() {
        return Keymap.class.getResourceAsStream(this.name + "_keys.props");
    }

    private void loadProperties() {
        this.props = new Properties();
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));){
            this.props.load(in);
        }
        catch (IOException e) {
            Log.log(9, this, "Unable to load properties", e);
        }
    }

    @Override
    public String getShortcut(String name) {
        String property = this.props.getProperty(name);
        return property;
    }

    @Override
    public void setShortcut(String name, String shortcut) {
        if (shortcut == null || shortcut.isEmpty()) {
            if (this.props.containsKey(name)) {
                this.modified = true;
                this.props.remove(name);
            }
            return;
        }
        String oldShortcut = this.props.getProperty(name);
        if (!shortcut.equals(oldShortcut)) {
            this.modified = true;
            this.props.setProperty(name, shortcut);
        }
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Keymap)) {
            return false;
        }
        Keymap keymap = (Keymap)obj;
        return this.name.equals(keymap.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        if (this.modified) {
            this.modified = false;
            File userKeymapFile = KeymapManagerImpl.getUserKeymapFile(this.name);
            userKeymapFile.getParentFile().mkdirs();
            BufferedOutputStream out = null;
            try {
                out = new BufferedOutputStream(new FileOutputStream(userKeymapFile));
                MiscUtilities.storeProperties(this.props, out, "jEdit's keymap " + this.name);
            }
            catch (IOException e) {
                try {
                    Log.log(9, this, "Unable to save properties", e);
                }
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(out);
                    throw throwable;
                }
                IOUtilities.closeQuietly(out);
            }
            IOUtilities.closeQuietly(out);
        }
    }
}

