/*
 * Decompiled with CFR 0.152.
 */
package org.jedit.keymap;

import javax.swing.UIManager;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.InputHandler;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;

public class EmacsUtil {
    Buffer buffer = jEdit.getActiveView().getBuffer();
    TextArea textArea = jEdit.getActiveView().getTextArea();

    public void emacsKillLine() {
        char ch;
        int caret2;
        boolean lastActionWasThis = this.repeatingSameMacro("Emacs/Emacs_Kill_Line");
        int caret = this.textArea.getCaretPosition();
        int caretLine = this.textArea.getCaretLine();
        int lineEnd = this.textArea.getLineEndOffset(caretLine);
        for (caret2 = caret + 1; caret2 < lineEnd && Character.isWhitespace(ch = this.charAt(caret2)); ++caret2) {
        }
        String deletedText = null;
        Selection.Range selection = null;
        if (caret2 == lineEnd) {
            if (caretLine != this.textArea.getLastPhysicalLine()) {
                selection = new Selection.Range(caret, caret2);
            }
        } else {
            selection = new Selection.Range(caret, lineEnd - 1);
        }
        if (selection != null) {
            this.textArea.setSelection(selection);
            deletedText = this.textArea.getSelectedText();
            this.textArea.replaceSelection("");
            this.textArea.removeFromSelection(selection);
            if (lastActionWasThis) {
                String clipboard = this.getClipboard();
                if (clipboard == null) {
                    clipboard = "";
                }
                this.setClipboard(clipboard + deletedText);
            } else {
                this.setClipboard(deletedText);
            }
        }
    }

    public boolean repeatingSameMacro(String macroName) {
        InputHandler ih = jEdit.getActiveView().getInputHandler();
        EditAction lastAction = ih.getLastAction();
        int lastActionCount = ih.getLastActionCount();
        boolean repeat = false;
        if (lastAction.getName().equals(macroName) && lastActionCount > 1) {
            repeat = true;
        }
        return repeat;
    }

    public String lineAt(int i) {
        StringBuilder sb = new StringBuilder();
        while (!this.atEndOfBuffer(i)) {
            char c = this.charAt(i);
            sb.append(c);
            if (c != '\n') continue;
            break;
        }
        return sb.toString();
    }

    public char charAt(int i) {
        if (i >= this.buffer.getLength()) {
            return '\u0000';
        }
        return this.buffer.getText(i, 1).charAt(0);
    }

    public char charAtCaret() {
        int caret = this.textArea.getCaretPosition();
        return this.atEndOfBuffer() ? (char)'\u0000' : this.buffer.getText(caret, 1).charAt(0);
    }

    public boolean atEndOfBuffer() {
        JEditTextArea textArea = jEdit.getActiveView().getTextArea();
        return this.atEndOfBuffer(textArea.getCaretPosition());
    }

    public boolean atEndOfBuffer(int caret) {
        return caret >= this.buffer.getLength();
    }

    public int eatNonAlphanums() {
        boolean eat = true;
        while (eat) {
            char ch = this.charAtCaret();
            if (ch == '\n') {
                this.textArea.goToNextLine(false);
                this.textArea.goToStartOfLine(false);
                continue;
            }
            if (Character.isLetterOrDigit(ch)) {
                eat = false;
                continue;
            }
            this.textArea.goToNextCharacter(false);
        }
        return this.textArea.getCaretPosition();
    }

    public int eatWhitespace() {
        boolean eat = true;
        while (eat) {
            char ch = this.charAtCaret();
            if (ch == '\n') {
                this.textArea.goToNextLine(false);
                this.textArea.goToStartOfLine(false);
                continue;
            }
            if (Character.isWhitespace(ch)) {
                this.textArea.goToNextCharacter(false);
                continue;
            }
            eat = false;
        }
        return this.textArea.getCaretPosition();
    }

    public int getCardinalProperty(String name, int defaultValue) {
        int result = jEdit.getIntegerProperty(name, defaultValue);
        if (result <= 0) {
            result = defaultValue;
        }
        return result;
    }

    public String makeBufferPropertyName(String prefix) {
        return this.makeBufferPropertyName(this.buffer, prefix);
    }

    public String makeBufferPropertyName(Buffer theBuffer, String prefix) {
        String bufName;
        StringBuilder propName = new StringBuilder(prefix);
        String fileSep = System.getProperty("file.separator");
        if (!fileSep.equals("/")) {
            if (fileSep.equals("\\")) {
                fileSep = fileSep + '\\';
            }
            bufName = theBuffer.getPath().replaceAll(fileSep, "/");
        } else {
            bufName = theBuffer.getPath();
        }
        propName.append(bufName);
        return propName.toString();
    }

    public int getDefaultWrap() {
        return this.getCardinalProperty("buffer.maxLineLen", 79);
    }

    public int getMark(Buffer buffer) {
        String propName = this.makeBufferPropertyName("emacs.mark");
        int mark = this.getCardinalProperty(propName, -1);
        if (mark != -1 && mark >= buffer.getLength()) {
            mark = buffer.getLength() - 1;
        }
        return mark;
    }

    public void setMark(Buffer buffer, int pos) {
        String propName = this.makeBufferPropertyName(buffer, "emacs.mark");
        jEdit.setTemporaryProperty(propName, String.valueOf(pos));
    }

    public void beep() {
        UIManager.getLookAndFeel().provideErrorFeedback(null);
    }

    public Selection getKillRegion() {
        int caret = this.textArea.getCaretPosition();
        Selection selection = this.textArea.getSelectionAtOffset(caret);
        if (selection == null) {
            int mark = this.getMark(this.buffer);
            if (mark == -1) {
                this.beep();
                return null;
            }
            selection = new Selection.Range(Math.min(caret, mark), Math.max(caret, mark));
            this.textArea.setSelection(selection);
        }
        return selection;
    }

    public String getClipboard() {
        return String.valueOf(Registers.getRegister('$'));
    }

    public void setClipboard(String string) {
        Registers.setRegister('$', string);
    }

    public void setClipboard(Selection selection) {
        JEditTextArea textArea = jEdit.getActiveView().getTextArea();
        this.setClipboard(textArea.getSelectedText(selection));
    }

    public void addToClipboardAndHistory(String string) {
        this.setClipboard(string);
        HistoryModel.getModel("clipboard").addItem(string);
    }

    public void addToClipboardAndHistory(Selection selection) {
        this.addToClipboardAndHistory(this.textArea.getSelectedText(selection));
    }

    public int findEndOfSentence() {
        int caret = this.textArea.getCaretPosition();
        while (!this.atEndOfBuffer(caret)) {
            char ch = this.charAt(caret);
            if (ch == '.' && Character.isWhitespace(this.charAt(caret + 1))) {
                ++caret;
                break;
            }
            ++caret;
        }
        return caret;
    }

    public int findBeginningOfSentence() {
        int caret = this.textArea.getCaretPosition() - 1;
        if (this.charAt(caret) == '.') {
            --caret;
        }
        while (caret > 0) {
            char ch = this.charAt(caret);
            if (ch == '.') {
                if (Character.isWhitespace(this.charAt(caret + 1))) {
                    ++caret;
                    break;
                }
            } else if (Character.isUpperCase(ch) && (--caret <= 0 || Character.isWhitespace(this.charAt(caret)))) break;
            --caret;
        }
        return caret;
    }
}

