/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class ScrollLayout
implements LayoutManager {
    public static final String CENTER = "center";
    public static final String RIGHT = "right";
    public static final String LEFT = "left";
    public static final String BOTTOM = "bottom";
    public static final String TOP = "top";
    public static final String TOP_LEFT = "topLeft";
    public static final String TOP_RIGHT = "topRight";
    public static final String BOTTOM_LEFT = "bottomLeft";
    public static final String BOTTOM_RIGHT = "bottomRight";
    private Component center;
    private Component left;
    private Component right;
    private Component bottom;
    private Component top;
    private Component topLeft;
    private Component topRight;
    private Component bottomLeft;
    private Component bottomRight;

    @Override
    public void addLayoutComponent(String name, Component comp) {
        switch (name) {
            case "center": {
                this.center = comp;
                break;
            }
            case "right": {
                this.right = comp;
                break;
            }
            case "left": {
                this.left = comp;
                break;
            }
            case "bottom": {
                this.bottom = comp;
                break;
            }
            case "top": {
                this.top = comp;
                break;
            }
            case "topLeft": {
                this.topLeft = comp;
                break;
            }
            case "topRight": {
                this.topRight = comp;
                break;
            }
            case "bottomLeft": {
                this.bottomLeft = comp;
                break;
            }
            case "bottomRight": {
                this.bottomRight = comp;
            }
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (this.center == comp) {
            this.center = null;
        } else if (this.right == comp) {
            this.right = null;
        } else if (this.left == comp) {
            this.left = null;
        } else if (this.bottom == comp) {
            this.bottom = null;
        } else if (this.top == comp) {
            this.top = null;
        } else if (this.topLeft == comp) {
            this.topLeft = null;
        } else if (this.topRight == comp) {
            this.topRight = null;
        } else if (this.bottomLeft == comp) {
            this.bottomLeft = null;
        } else if (this.bottomRight == comp) {
            this.bottomRight = null;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension dim = new Dimension();
        Insets insets = ScrollLayout.getInsets(parent);
        dim.width = insets.left + insets.right;
        dim.width += this.getLeftPreferredWidth();
        dim.width += this.getCenterPreferredWidth();
        dim.width += this.getRightPreferredWidth();
        dim.height = insets.top + insets.bottom;
        dim.height += this.getTopPreferredHeight();
        dim.height += this.getCenterPreferredHeight();
        dim.height += this.getBottomPreferredHeight();
        return dim;
    }

    private int getLeftPreferredWidth() {
        if (this.left != null) {
            return this.left.getPreferredSize().width;
        }
        int tlw = this.topLeft == null ? 0 : this.topLeft.getPreferredSize().width;
        int lw = this.left == null ? 0 : this.left.getPreferredSize().width;
        int blw = this.bottomLeft == null ? 0 : this.bottomLeft.getPreferredSize().width;
        return Math.max(lw, Math.max(tlw, blw));
    }

    private int getCenterPreferredWidth() {
        int tw = this.top == null ? 0 : this.top.getPreferredSize().width;
        int cw = this.center == null ? 0 : this.center.getPreferredSize().width;
        int bw = this.bottom == null ? 0 : this.bottom.getPreferredSize().width;
        return Math.max(cw, Math.max(tw, bw));
    }

    private int getRightPreferredWidth() {
        if (this.right != null) {
            return this.right.getPreferredSize().width;
        }
        int trw = this.topRight == null ? 0 : this.topRight.getPreferredSize().width;
        int rw = this.right == null ? 0 : this.right.getPreferredSize().width;
        int brw = this.bottomRight == null ? 0 : this.bottomRight.getPreferredSize().width;
        return Math.max(rw, Math.max(trw, brw));
    }

    private int getTopPreferredHeight() {
        if (this.top != null) {
            return this.top.getPreferredSize().height;
        }
        int tlh = this.topLeft == null ? 0 : this.topLeft.getPreferredSize().height;
        int th = this.top == null ? 0 : this.top.getPreferredSize().height;
        int trh = this.topRight == null ? 0 : this.topRight.getPreferredSize().height;
        return Math.max(th, Math.max(tlh, trh));
    }

    private int getCenterPreferredHeight() {
        int lh = this.left == null ? 0 : this.left.getPreferredSize().height;
        int ch = this.center == null ? 0 : this.center.getPreferredSize().height;
        int rh = this.right == null ? 0 : this.right.getPreferredSize().height;
        return Math.max(ch, Math.max(lh, rh));
    }

    private int getBottomPreferredHeight() {
        if (this.bottom != null) {
            return this.bottom.getPreferredSize().height;
        }
        int blh = this.bottomLeft == null ? 0 : this.bottomLeft.getPreferredSize().height;
        int bh = this.bottom == null ? 0 : this.bottom.getPreferredSize().height;
        int brh = this.bottomRight == null ? 0 : this.bottomRight.getPreferredSize().height;
        return Math.max(bh, Math.max(brh, blh));
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension dim = new Dimension();
        Insets insets = ScrollLayout.getInsets(parent);
        dim.width = insets.left + insets.right;
        dim.height = insets.top + insets.bottom;
        int tlw = this.topLeft == null ? 0 : this.topLeft.getMinimumSize().width;
        int lw = this.left == null ? 0 : this.left.getMinimumSize().width;
        int blw = this.bottomLeft == null ? 0 : this.bottomLeft.getMinimumSize().width;
        dim.width += Math.max(lw, Math.max(tlw, blw));
        int tw = this.top == null ? 0 : this.top.getMinimumSize().width;
        int cw = this.center == null ? 0 : this.center.getMinimumSize().width;
        int bw = this.bottom == null ? 0 : this.bottom.getMinimumSize().width;
        dim.width += Math.max(cw, Math.max(tw, bw));
        int trw = this.topRight == null ? 0 : this.topRight.getMinimumSize().width;
        int rw = this.right == null ? 0 : this.right.getMinimumSize().width;
        int brw = this.bottomRight == null ? 0 : this.bottomRight.getMinimumSize().width;
        dim.width += Math.max(rw, Math.max(trw, brw));
        int tlh = this.topLeft == null ? 0 : this.topLeft.getMinimumSize().height;
        int lh = this.left == null ? 0 : this.left.getMinimumSize().height;
        int blh = this.bottomLeft == null ? 0 : this.bottomLeft.getMinimumSize().height;
        dim.height += Math.max(lh, Math.max(tlh, blh));
        int th = this.top == null ? 0 : this.top.getMinimumSize().height;
        int ch = this.center == null ? 0 : this.center.getMinimumSize().height;
        int bh = this.bottom == null ? 0 : this.bottom.getMinimumSize().height;
        dim.height += Math.max(ch, Math.max(th, bh));
        int trh = this.topRight == null ? 0 : this.topRight.getMinimumSize().height;
        int rh = this.right == null ? 0 : this.right.getMinimumSize().height;
        int brh = this.bottomRight == null ? 0 : this.bottomRight.getMinimumSize().height;
        dim.height += Math.max(rh, Math.max(trh, brh));
        return dim;
    }

    @Override
    public void layoutContainer(Container parent) {
        Dimension size = parent.getSize();
        Insets insets = ScrollLayout.getInsets(parent);
        int itop = insets.top;
        int ileft = insets.left;
        int ibottom = insets.bottom;
        int iright = insets.right;
        int leftWidth = this.getLeftPreferredWidth();
        int rightWidth = this.getRightPreferredWidth();
        int topHeight = this.getTopPreferredHeight();
        int bottomHeight = this.getBottomPreferredHeight();
        int centerWidth = Math.max(0, size.width - leftWidth - rightWidth - ileft - iright);
        int centerHeight = Math.max(0, size.height - topHeight - bottomHeight - itop - ibottom);
        if (this.left != null) {
            this.left.setBounds(ileft, itop + topHeight, leftWidth, centerHeight);
        }
        if (this.center != null) {
            this.center.setBounds(ileft + leftWidth, itop + topHeight, centerWidth, centerHeight);
        }
        if (this.right != null) {
            this.right.setBounds(ileft + leftWidth + centerWidth, itop + topHeight, rightWidth, centerHeight);
        }
        if (this.bottom != null) {
            this.bottom.setBounds(ileft + leftWidth, itop + topHeight + centerHeight, centerWidth, bottomHeight);
        }
        if (this.top != null) {
            this.top.setBounds(ileft + leftWidth, itop, centerWidth, topHeight);
        }
        if (this.topLeft != null) {
            this.topLeft.setBounds(ileft, itop, leftWidth, topHeight);
        }
        if (this.topRight != null) {
            this.topRight.setBounds(ileft + leftWidth + centerWidth, itop, rightWidth, topHeight);
        }
        if (this.bottomLeft != null) {
            this.bottomLeft.setBounds(ileft, itop + topHeight + centerHeight, leftWidth, bottomHeight);
        }
        if (this.bottomRight != null) {
            this.bottomRight.setBounds(ileft + leftWidth + centerWidth, itop + topHeight + centerHeight, rightWidth, bottomHeight);
        }
    }

    private static Insets getInsets(Component parent) {
        Border border = ((JComponent)parent).getBorder();
        if (border == null) {
            return new Insets(0, 0, 0, 0);
        }
        return border.getBorderInsets(parent);
    }
}

